/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.util;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.lang.management.ManagementFactory;
import java.lang.ref.WeakReference;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.Context;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.client.SessionFailureListener;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryImpl;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorImpl;
import org.apache.activemq.artemis.core.client.impl.Topology;
import org.apache.activemq.artemis.core.client.impl.TopologyMemberImpl;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.StoreConfiguration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.config.impl.SecurityConfiguration;
import org.apache.activemq.artemis.core.config.storage.DatabaseStorageConfiguration;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.aio.AIOSequentialFileFactory;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFileFactory;
import org.apache.activemq.artemis.core.journal.PreparedTransactionInfo;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;
import org.apache.activemq.artemis.core.journal.impl.JournalReaderCallback;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.persistence.impl.journal.OperationContextImpl;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMAcceptorFactory;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnector;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMRegistry;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyAcceptorFactory;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnector;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.core.replication.ReplicationEndpoint;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.cluster.ClusterConnection;
import org.apache.activemq.artemis.core.server.cluster.ClusterManager;
import org.apache.activemq.artemis.core.server.cluster.RemoteQueueBinding;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.impl.Activation;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.PrimaryOnlyActivation;
import org.apache.activemq.artemis.core.server.impl.ReplicationBackupActivation;
import org.apache.activemq.artemis.core.server.impl.SharedNothingBackupActivation;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.settings.impl.PageFullMessagePolicy;
import org.apache.activemq.artemis.core.transaction.impl.XidImpl;
import org.apache.activemq.artemis.json.JsonObject;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.spi.core.security.jaas.InVMLoginModule;
import org.apache.activemq.artemis.tests.extensions.LibaioContextCheckExtension;
import org.apache.activemq.artemis.tests.extensions.PortCheckExtension;
import org.apache.activemq.artemis.tests.extensions.RemoveDirectoryExtension;
import org.apache.activemq.artemis.tests.extensions.TargetTempDirFactory;
import org.apache.activemq.artemis.tests.util.ArtemisTestCase;
import org.apache.activemq.artemis.tests.util.ColocatedActiveMQServer;
import org.apache.activemq.artemis.tests.util.CountDownSessionFailureListener;
import org.apache.activemq.artemis.tests.util.DBSupportUtil;
import org.apache.activemq.artemis.tests.util.InVMNodeManagerServer;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.Env;
import org.apache.activemq.artemis.utils.FileUtil;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.activemq.artemis.utils.ThreadDumpUtil;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.apache.activemq.artemis.utils.Wait;
import org.apache.activemq.artemis.utils.actors.OrderedExecutorFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.io.TempDir;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={LibaioContextCheckExtension.class})
public abstract class ActiveMQTestBase
extends ArtemisTestCase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @RegisterExtension
    public static PortCheckExtension portCheckExtension;
    public static final String INVM_ACCEPTOR_FACTORY;
    public static final String INVM_CONNECTOR_FACTORY;
    public static final String NETTY_ACCEPTOR_FACTORY;
    public static final String NETTY_CONNECTOR_FACTORY;
    public static final String CLUSTER_PASSWORD = "UnitTestsClusterPassword";
    private static final String SEND_CALL_NUMBER = "sendCallNumber";
    private static final String OS_TYPE;
    private static final int DEFAULT_UDP_PORT;
    protected static final long WAIT_TIMEOUT = 30000L;
    private static Set<Thread> alreadyFailedThread;
    private final Collection<ActiveMQServer> servers = new ArrayList<ActiveMQServer>();
    private final Collection<ServerLocator> locators = new ArrayList<ServerLocator>();
    private final Collection<ClientSessionFactory> sessionFactories = new ArrayList<ClientSessionFactory>();
    private final Collection<ClientSession> clientSessions = new HashSet<ClientSession>();
    private final Collection<ClientConsumer> clientConsumers = new HashSet<ClientConsumer>();
    private final Collection<ClientProducer> clientProducers = new HashSet<ClientProducer>();
    private final Collection<ActiveMQComponent> otherComponents = new HashSet<ActiveMQComponent>();
    private final Set<ExecutorService> executorSet = new HashSet<ExecutorService>();
    private int sendMsgCount = 0;
    @TempDir(factory=TargetTempDirFactory.class)
    public File temporaryFolder;
    @RegisterExtension
    public RemoveDirectoryExtension removeDirectory = new RemoveDirectoryExtension("./target/tmp");
    private boolean derbyDropped = false;

    protected void clearServers() {
        this.servers.clear();
    }

    protected <T> T serialClone(Object object) throws Exception {
        logger.debug("object::{}", object);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream obOut = new ObjectOutputStream(bout);
        obOut.writeObject(object);
        ByteArrayInputStream binput = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream obinp = new ObjectInputStream(binput);
        return (T)obinp.readObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterEach
    public void tearDown() throws Exception {
        try {
            this.closeAllSessionFactories();
            this.closeAllServerLocatorsFactories();
            this.assertAllClientConsumersAreClosed();
            this.assertAllClientProducersAreClosed();
            this.assertAllClientSessionsAreClosed();
        }
        finally {
            List<Exception> exceptions;
            Collection<ActiveMQServer> collection = this.servers;
            synchronized (collection) {
                for (ActiveMQServer server : this.servers) {
                    if (server == null) continue;
                    try {
                        ((PrimaryOnlyActivation)server.getActivation()).getPrimaryOnlyPolicy().getScaleDownPolicy().setEnabled(false);
                    }
                    catch (Throwable throwable) {}
                    try {
                        ClusterManager clusterManager = server.getClusterManager();
                        if (clusterManager != null) {
                            for (ClusterConnection cc : clusterManager.getClusterConnections()) {
                                ActiveMQTestBase.stopComponent((ActiveMQComponent)cc);
                            }
                        }
                    }
                    catch (Exception clusterManager) {}
                    ActiveMQTestBase.stopComponentOutputExceptions((ActiveMQComponent)server);
                }
                this.clearServers();
            }
            this.closeAllOtherComponents();
            try {
                exceptions = this.checkCsfStopped();
            }
            finally {
                this.cleanupPools();
            }
            for (ExecutorService s : this.executorSet) {
                s.shutdown();
            }
            InVMConnector.resetThreadPool();
            this.assertAllExecutorsFinished();
            if (!exceptions.isEmpty()) {
                for (Exception exception : exceptions) {
                    exception.printStackTrace(System.out);
                }
                System.out.println(ActiveMQTestBase.threadDump("Thread dump with reconnects happening"));
            }
            Map<Thread, StackTraceElement[]> threadMap = Thread.getAllStackTraces();
            for (Map.Entry<Thread, StackTraceElement[]> entry : threadMap.entrySet()) {
                StackTraceElement[] stack;
                Thread thread = entry.getKey();
                for (StackTraceElement stackTraceElement : stack = entry.getValue()) {
                    if (stackTraceElement.getMethodName().contains("getConnectionWithRetry") && !alreadyFailedThread.contains(thread)) {
                        alreadyFailedThread.add(thread);
                        System.out.println(ActiveMQTestBase.threadDump(this.getName() + " has left threads running. Look at thread " + thread.getName() + " id = " + thread.getId() + " has running locators on test " + this.getName() + " on this following dump"));
                        Assertions.fail((String)("test '" + this.getName() + "' left serverlocator running, this could effect other tests"));
                        continue;
                    }
                    if (!stackTraceElement.getMethodName().contains("BroadcastGroupImpl.run") || alreadyFailedThread.contains(thread)) continue;
                    alreadyFailedThread.add(thread);
                    System.out.println(ActiveMQTestBase.threadDump(this.getName() + " has left threads running. Look at thread " + thread.getName() + " id = " + thread.getId() + " is still broadcasting " + this.getName() + " on this following dump"));
                    Assertions.fail((String)"test left broadcastgroupimpl running, this could effect other tests");
                }
            }
            if (Thread.currentThread().getContextClassLoader() == null) {
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                Assertions.fail((String)"Thread Context ClassLoader was set to null at some point before this test. We will set to this.getClass().getClassLoader(), but you are supposed to fix your tests");
            }
            this.checkFilesUsage();
        }
        if (InVMRegistry.instance.size() > 0) {
            Assertions.fail((String)"InVMREgistry size > 0");
        }
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.sendMsgCount = 0;
        this.clearDataRecreateServerDirs();
        OperationContextImpl.clearContext();
        InVMRegistry.instance.clear();
    }

    public static void assertEqualsByteArrays(byte[] expected, byte[] actual) {
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((byte)expected[i], (byte)actual[i], (String)("byte at index " + i));
        }
    }

    public static int countOccurrencesOf(String str, String sub) {
        int idx;
        if (str == null || sub == null || str.length() == 0 || sub.length() == 0) {
            return 0;
        }
        int count = 0;
        int pos = 0;
        while ((idx = str.indexOf(sub, pos)) != -1) {
            ++count;
            pos = idx + sub.length();
        }
        return count;
    }

    protected void disableCheckThread() {
        threadLeakCheckExtension.disable();
    }

    protected String getName() {
        return this.name;
    }

    protected boolean isWindows() {
        return OS_TYPE.indexOf("win") >= 0;
    }

    protected Configuration createDefaultInVMConfig() throws Exception {
        return this.createDefaultConfig(0, false);
    }

    protected Configuration createDefaultInVMConfig(int serverID) throws Exception {
        return this.createDefaultConfig(serverID, false);
    }

    protected Configuration createDefaultNettyConfig() throws Exception {
        return this.createDefaultConfig(0, true);
    }

    protected Configuration createDefaultConfig(boolean netty) throws Exception {
        return this.createDefaultConfig(0, netty);
    }

    protected Configuration createDefaultJDBCConfig(boolean isNetty) throws Exception {
        Configuration configuration = this.createDefaultConfig(isNetty);
        this.setDBStoreType(configuration);
        return configuration;
    }

    protected Configuration createDefaultConfig(int serverID, boolean netty) throws Exception {
        ConfigurationImpl configuration = this.createBasicConfig(serverID).setJMXManagementEnabled(false).addAcceptorConfiguration(new TransportConfiguration(INVM_ACCEPTOR_FACTORY, this.generateInVMParams(serverID), "invm"));
        if (netty) {
            configuration.addAcceptorConfiguration(new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, new HashMap(), "netty", new HashMap()));
        } else {
            configuration.setResolveProtocols(false);
        }
        return configuration;
    }

    private Configuration createDefaultConfig(int index, Map<String, Object> params, String ... acceptors) {
        ConfigurationImpl configuration = this.createBasicConfig(index);
        for (String acceptor : acceptors) {
            TransportConfiguration transportConfig = new TransportConfiguration(acceptor, params);
            configuration.getAcceptorConfigurations().add(transportConfig);
        }
        return configuration;
    }

    protected ConfigurationImpl createBasicConfig() throws Exception {
        return this.createBasicConfig(-1);
    }

    protected ConfigurationImpl createBasicConfig(int serverID) {
        ConfigurationImpl configuration = new ConfigurationImpl().setSecurityEnabled(false).setJournalMinFiles(2).setJournalFileSize(102400).setJournalType(ActiveMQTestBase.getDefaultJournalType()).setJournalDirectory(this.getJournalDir(serverID, false)).setBindingsDirectory(this.getBindingsDir(serverID, false)).setPagingDirectory(this.getPageDir(serverID, false)).setLargeMessagesDirectory(this.getLargeMessagesDir(serverID, false)).setJournalCompactMinFiles(0).setJournalCompactPercentage(0).setClusterPassword(CLUSTER_PASSWORD).setJournalDatasync(false);
        configuration.setJournalBufferTimeout_AIO(100).setJournalBufferTimeout_NIO(100);
        return configuration;
    }

    protected void setDBStoreType(Configuration configuration) {
        configuration.setStoreConfiguration((StoreConfiguration)this.createDefaultDatabaseStorageConfiguration());
    }

    protected void dropDerby() throws Exception {
        DBSupportUtil.dropDerbyDatabase((String)this.getJDBCUser(), (String)this.getJDBCPassword(), (String)this.getEmbeddedDataBaseName());
    }

    protected void shutdownDerby() throws SQLException {
        DBSupportUtil.shutdownDerby((String)this.getJDBCUser(), (String)this.getJDBCPassword());
    }

    protected DatabaseStorageConfiguration createDefaultDatabaseStorageConfiguration() {
        DatabaseStorageConfiguration dbStorageConfiguration = new DatabaseStorageConfiguration();
        String connectionURI = this.getTestJDBCConnectionUrl();
        if (connectionURI.contains("derby") && connectionURI.contains("memory") && !this.derbyDropped) {
            this.derbyDropped = true;
            this.runAfterEx(this::dropDerby);
            this.runAfterEx(this::shutdownDerby);
        }
        dbStorageConfiguration.setJdbcConnectionUrl(connectionURI);
        dbStorageConfiguration.setBindingsTableName("BINDINGS");
        dbStorageConfiguration.setMessageTableName("MESSAGE");
        dbStorageConfiguration.setLargeMessageTableName("LARGE_MESSAGE");
        dbStorageConfiguration.setPageStoreTableName("PAGE_STORE");
        dbStorageConfiguration.setJdbcPassword(this.getJDBCPassword());
        dbStorageConfiguration.setJdbcUser(this.getJDBCUser());
        dbStorageConfiguration.setJdbcDriverClassName(this.getJDBCClassName());
        dbStorageConfiguration.setJdbcLockAcquisitionTimeoutMillis(this.getJdbcLockAcquisitionTimeoutMillis());
        dbStorageConfiguration.setJdbcLockExpirationMillis(this.getJdbcLockExpirationMillis());
        dbStorageConfiguration.setJdbcLockRenewPeriodMillis(this.getJdbcLockRenewPeriodMillis());
        dbStorageConfiguration.setJdbcNetworkTimeout(-1);
        dbStorageConfiguration.setJdbcAllowedTimeDiff(250L);
        return dbStorageConfiguration;
    }

    protected long getJdbcLockAcquisitionTimeoutMillis() {
        return Long.getLong("jdbc.lock.acquisition", ActiveMQDefaultConfiguration.getDefaultJdbcLockAcquisitionTimeoutMillis());
    }

    protected long getJdbcLockExpirationMillis() {
        return Long.getLong("jdbc.lock.expiration", 4000L);
    }

    protected long getJdbcLockRenewPeriodMillis() {
        return Long.getLong("jdbc.lock.renew", 200L);
    }

    protected Map<String, Object> generateInVMParams(int node) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("serverId", node);
        return params;
    }

    protected ClusterConnectionConfiguration createBasicClusterConfig(String connectorName, String ... connectors) {
        return ActiveMQTestBase.basicClusterConnectionConfig(connectorName, connectors);
    }

    protected static final ClusterConnectionConfiguration basicClusterConnectionConfig(String connectorName, String ... connectors) {
        ArrayList<String> connectors0 = new ArrayList<String>();
        for (String c : connectors) {
            connectors0.add(c);
        }
        ClusterConnectionConfiguration clusterConnectionConfiguration = new ClusterConnectionConfiguration().setName("cluster1").setAddress("jms").setConnectorName(connectorName).setRetryInterval(100L).setDuplicateDetection(false).setMaxHops(1).setConfirmationWindowSize(1).setMessageLoadBalancingType(MessageLoadBalancingType.STRICT).setStaticConnectors(connectors0);
        return clusterConnectionConfiguration;
    }

    protected final OrderedExecutorFactory getOrderedExecutor() {
        ExecutorService executor = Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName()));
        this.runAfter(executor::shutdownNow);
        return new OrderedExecutorFactory((Executor)executor);
    }

    protected static String getUDPDiscoveryAddress() {
        return System.getProperty("TEST-UDP-ADDRESS", "230.1.2.3");
    }

    protected static String getUDPDiscoveryAddress(int variant) {
        String value = ActiveMQTestBase.getUDPDiscoveryAddress();
        int posPoint = value.lastIndexOf(46);
        int last = Integer.parseInt(value.substring(posPoint + 1));
        return value.substring(0, posPoint + 1) + (last + variant);
    }

    public static int getUDPDiscoveryPort() {
        String port = System.getProperty("TEST-UDP-PORT");
        if (port != null) {
            return Integer.parseInt(port);
        }
        return DEFAULT_UDP_PORT;
    }

    public static int getUDPDiscoveryPort(int variant) {
        return ActiveMQTestBase.getUDPDiscoveryPort() + variant;
    }

    public static JournalType getDefaultJournalType() {
        if (AIOSequentialFileFactory.isSupported()) {
            return JournalType.ASYNCIO;
        }
        return JournalType.NIO;
    }

    public static void checkWeakReferences(WeakReference<?> ... references) {
        int i = 0;
        boolean hasValue = false;
        block0: do {
            hasValue = false;
            if (i > 0) {
                ActiveMQTestBase.forceGC();
            }
            for (WeakReference<?> ref : references) {
                if (ref.get() == null) continue;
                hasValue = true;
                continue block0;
            }
        } while (i++ <= 200 && hasValue);
        for (WeakReference<?> ref : references) {
            Assertions.assertNull(ref.get());
        }
    }

    public static String threadDump(String msg) {
        return ThreadDumpUtil.threadDump((String)msg);
    }

    public void logAndSystemOut(String message, Exception e) {
        System.out.println(message);
        if (e != null) {
            e.printStackTrace(System.out);
        }
        logger.debug(message, (Throwable)e);
    }

    public void logAndSystemOut(String message) {
        this.logAndSystemOut(message, null);
    }

    public static String dumpBytes(byte[] bytes) {
        StringBuffer buff = new StringBuffer();
        buff.append(System.identityHashCode(bytes) + ", size: " + bytes.length + " [");
        for (int i = 0; i < bytes.length; ++i) {
            buff.append(bytes[i]);
            if (i == bytes.length - 1) continue;
            buff.append(", ");
        }
        buff.append("]");
        return buff.toString();
    }

    public static String dumpBytesHex(byte[] buffer, int bytesPerLine) {
        StringBuffer buff = new StringBuffer();
        buff.append("[");
        for (int i = 0; i < buffer.length; ++i) {
            buff.append(String.format("%1$2X", buffer[i]));
            if (i + 1 < buffer.length) {
                buff.append(", ");
            }
            if ((i + 1) % bytesPerLine != 0) continue;
            buff.append("\n ");
        }
        buff.append("]");
        return buff.toString();
    }

    public static void assertEqualsTransportConfigurations(TransportConfiguration[] expected, TransportConfiguration[] actual) {
        Assertions.assertEquals((int)expected.length, (int)actual.length);
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Object)expected[i], (Object)actual[i], (String)("TransportConfiguration at index " + i));
        }
    }

    public static void assertEqualsBuffers(int size, ActiveMQBuffer expected, ActiveMQBuffer actual) {
        expected.readerIndex(0);
        actual.readerIndex(0);
        for (int i = 0; i < size; ++i) {
            byte b1 = expected.readByte();
            byte b2 = actual.readByte();
            Assertions.assertEquals((byte)b1, (byte)b2, (String)("byte at index " + i));
        }
        expected.resetReaderIndex();
        actual.resetReaderIndex();
    }

    public static void assertEqualsByteArrays(int length, byte[] expected, byte[] actual) {
        Assertions.assertTrue((expected.length >= length ? (byte)1 : 0) != 0);
        Assertions.assertTrue((actual.length >= length ? (byte)1 : 0) != 0);
        for (int i = 0; i < length; ++i) {
            Assertions.assertEquals((byte)expected[i], (byte)actual[i], (String)("byte at index " + i));
        }
    }

    public static void assertSameXids(List<Xid> expected, List<Xid> actual) {
        Assertions.assertNotNull(expected);
        Assertions.assertNotNull(actual);
        Assertions.assertEquals((int)expected.size(), (int)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            Xid expectedXid = expected.get(i);
            Xid actualXid = actual.get(i);
            ActiveMQTestBase.assertEqualsByteArrays(expectedXid.getBranchQualifier(), actualXid.getBranchQualifier());
            Assertions.assertEquals((int)expectedXid.getFormatId(), (int)actualXid.getFormatId());
            ActiveMQTestBase.assertEqualsByteArrays(expectedXid.getGlobalTransactionId(), actualXid.getGlobalTransactionId());
        }
    }

    protected static void checkNoBinding(Context context, String binding) {
        try {
            context.lookup(binding);
            Assertions.fail((String)("there must be no resource to look up for " + binding));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static Object checkBinding(Context context, String binding) throws Exception {
        Object o = context.lookup(binding);
        Assertions.assertNotNull((Object)o);
        return o;
    }

    protected ArrayList<String> registerConnectors(ActiveMQServer server, List<TransportConfiguration> connectorConfigs) {
        ArrayList<String> connectors = new ArrayList<String>();
        for (TransportConfiguration tnsp : connectorConfigs) {
            String name1 = RandomUtil.randomString();
            server.getConfiguration().getConnectorConfigurations().put(name1, tnsp);
            connectors.add(name1);
        }
        return connectors;
    }

    protected final String getTestDir() {
        return this.temporaryFolder.getAbsolutePath();
    }

    protected String getEmbeddedDataBaseName() {
        return "memory:" + this.getTestDir();
    }

    protected String getTestJDBCConnectionUrl() {
        return System.getProperty("jdbc.connection.url", "jdbc:derby:" + this.getEmbeddedDataBaseName() + ";create=true");
    }

    protected String getJDBCClassName() {
        return System.getProperty("jdbc.driver.class", "org.apache.derby.jdbc.EmbeddedDriver");
    }

    protected String getJDBCUser() {
        return System.getProperty("jdbc.user", null);
    }

    protected String getJDBCPassword() {
        return System.getProperty("jdbc.password", null);
    }

    protected final File getTestDirfile() {
        return new File(this.getTestDir());
    }

    protected final void setTestDir(String testDir) {
        this.temporaryFolder = new File(testDir);
    }

    protected final void clearDataRecreateServerDirs() {
        this.clearDataRecreateServerDirs(0, false);
    }

    protected final void clearDataRecreateServerDirs(int index, boolean backup) {
        this.clearDataRecreateServerDirs(this.getTestDir(), index, backup);
    }

    protected void clearDataRecreateServerDirs(String testDir1, int index, boolean backup) {
        File file = new File(testDir1);
        ActiveMQTestBase.deleteDirectory(file);
        file.mkdirs();
        this.recreateDataDirectories(testDir1, index, backup);
    }

    protected void recreateDataDirectories(String testDir1, int index, boolean backup) {
        ActiveMQTestBase.recreateDirectory(ActiveMQTestBase.getJournalDir(testDir1, index, backup));
        ActiveMQTestBase.recreateDirectory(ActiveMQTestBase.getBindingsDir(testDir1, index, backup));
        ActiveMQTestBase.recreateDirectory(ActiveMQTestBase.getPageDir(testDir1, index, backup));
        ActiveMQTestBase.recreateDirectory(ActiveMQTestBase.getLargeMessagesDir(testDir1, index, backup));
        ActiveMQTestBase.recreateDirectory(this.getClientLargeMessagesDir(testDir1));
        ActiveMQTestBase.recreateDirectory(this.getTemporaryDir(testDir1));
    }

    public String getJournalDir() {
        return this.getJournalDir(0, false);
    }

    protected static String getJournalDir(String testDir1) {
        return testDir1 + "/journal";
    }

    public String getJournalDir(int index, boolean backup) {
        return ActiveMQTestBase.getJournalDir(this.getTestDir(), index, backup);
    }

    public static String getJournalDir(String testDir, int index, boolean backup) {
        return ActiveMQTestBase.getJournalDir(testDir) + ActiveMQTestBase.directoryNameSuffix(index, backup);
    }

    protected String getBindingsDir() {
        return this.getBindingsDir(0, false);
    }

    protected static String getBindingsDir(String testDir1) {
        return testDir1 + "/bindings";
    }

    protected String getBindingsDir(int index, boolean backup) {
        return ActiveMQTestBase.getBindingsDir(this.getTestDir(), index, backup);
    }

    public static String getBindingsDir(String testDir, int index, boolean backup) {
        return ActiveMQTestBase.getBindingsDir(testDir) + ActiveMQTestBase.directoryNameSuffix(index, backup);
    }

    protected String getPageDir() {
        return this.getPageDir(0, false);
    }

    protected File getPageDirFile() {
        return new File(this.getPageDir());
    }

    protected static String getPageDir(String testDir1) {
        return testDir1 + "/page";
    }

    protected String getPageDir(int index, boolean backup) {
        return ActiveMQTestBase.getPageDir(this.getTestDir(), index, backup);
    }

    public static String getPageDir(String testDir, int index, boolean backup) {
        return ActiveMQTestBase.getPageDir(testDir) + ActiveMQTestBase.directoryNameSuffix(index, backup);
    }

    protected String getLargeMessagesDir() {
        return this.getLargeMessagesDir(0, false);
    }

    protected static String getLargeMessagesDir(String testDir1) {
        return testDir1 + "/large-msg";
    }

    protected String getLargeMessagesDir(int index, boolean backup) {
        return ActiveMQTestBase.getLargeMessagesDir(this.getTestDir(), index, backup);
    }

    public static String getLargeMessagesDir(String testDir, int index, boolean backup) {
        return ActiveMQTestBase.getLargeMessagesDir(testDir) + ActiveMQTestBase.directoryNameSuffix(index, backup);
    }

    private static String directoryNameSuffix(int index, boolean backup) {
        if (index == -1) {
            return "";
        }
        return index + "-" + (backup ? "B" : "L");
    }

    protected String getClientLargeMessagesDir() {
        return this.getClientLargeMessagesDir(this.getTestDir());
    }

    protected String getClientLargeMessagesDir(String testDir1) {
        return testDir1 + "/client-large-msg";
    }

    protected final String getTemporaryDir() {
        return this.getTemporaryDir(this.getTestDir());
    }

    protected String getTemporaryDir(String testDir1) {
        return testDir1 + "/temp";
    }

    protected static void expectActiveMQException(String message, ActiveMQExceptionType errorCode, ActiveMQAction action) {
        try {
            action.run();
            Assertions.fail((String)message);
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof ActiveMQException));
            Assertions.assertEquals((Object)errorCode, (Object)((ActiveMQException)((Object)e)).getType());
        }
    }

    protected static void expectActiveMQException(ActiveMQExceptionType errorCode, ActiveMQAction action) {
        ActiveMQTestBase.expectActiveMQException("must throw an ActiveMQException with the expected errorCode: " + errorCode, errorCode, action);
    }

    protected static void expectXAException(int errorCode, ActiveMQAction action) {
        try {
            action.run();
            Assertions.fail((String)("must throw a XAException with the expected errorCode: " + errorCode));
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof XAException));
            Assertions.assertEquals((int)errorCode, (int)((XAException)e).errorCode);
        }
    }

    public static byte getSamplebyte(long position) {
        return (byte)(97L + position % 26L);
    }

    public static InputStream createFakeLargeStream(final long size) throws Exception {
        return new InputStream(){
            private long count;
            private boolean closed = false;

            @Override
            public void close() throws IOException {
                super.close();
                this.closed = true;
            }

            @Override
            public int read() throws IOException {
                if (this.closed) {
                    throw new IOException("Stream was closed");
                }
                if (this.count++ < size) {
                    return ActiveMQTestBase.getSamplebyte(this.count - 1L);
                }
                return -1;
            }
        };
    }

    protected void validateGettersAndSetters(Object pojo, String ... ignoredProperties) throws Exception {
        PropertyDescriptor[] properties;
        HashSet<String> ignoreSet = new HashSet<String>();
        for (String ignore : ignoredProperties) {
            ignoreSet.add(ignore);
        }
        BeanInfo info = Introspector.getBeanInfo(pojo.getClass());
        for (PropertyDescriptor prop : properties = info.getPropertyDescriptors()) {
            Object value;
            if (prop.getPropertyType() == String.class) {
                value = RandomUtil.randomString();
            } else if (prop.getPropertyType() == Integer.class || prop.getPropertyType() == Integer.TYPE) {
                value = RandomUtil.randomInt();
            } else if (prop.getPropertyType() == Long.class || prop.getPropertyType() == Long.TYPE) {
                value = RandomUtil.randomLong();
            } else if (prop.getPropertyType() == Boolean.class || prop.getPropertyType() == Boolean.TYPE) {
                value = RandomUtil.randomBoolean();
            } else if (prop.getPropertyType() == Double.class || prop.getPropertyType() == Double.TYPE) {
                value = RandomUtil.randomDouble();
            } else {
                logger.debug("Can't validate property of type {} on {}", prop.getPropertyType(), (Object)prop.getName());
                value = null;
            }
            if (value != null && prop.getWriteMethod() != null && prop.getReadMethod() == null) {
                logger.debug("WriteOnly property {} on {}", (Object)prop.getName(), pojo.getClass());
                continue;
            }
            if (value == null || prop.getWriteMethod() == null || prop.getReadMethod() == null || ignoreSet.contains(prop.getName())) continue;
            logger.debug("Validating {} type = {}", (Object)prop.getName(), prop.getPropertyType());
            prop.getWriteMethod().invoke(pojo, value);
            Assertions.assertEquals((Object)value, (Object)prop.getReadMethod().invoke(pojo, new Object[0]), (String)("Property " + prop.getName()));
        }
    }

    protected void waitForNotPaging(Queue queue) throws InterruptedException {
        this.waitForNotPaging(queue.getPagingStore());
    }

    protected void waitForNotPaging(PagingStore store) throws InterruptedException {
        Wait.assertFalse((String)"Store is still paging", () -> ((PagingStore)store).isPaging(), (long)20000L);
    }

    protected static Topology waitForTopology(ActiveMQServer server, int nodes) throws Exception {
        return ActiveMQTestBase.waitForTopology(server, nodes, -1, 30000L);
    }

    protected static Topology waitForTopology(ActiveMQServer server, int nodes, int backups) throws Exception {
        return ActiveMQTestBase.waitForTopology(server, nodes, backups, 30000L);
    }

    protected static Topology waitForTopology(ActiveMQServer server, int primaryNodes, int backupNodes, long timeout) throws Exception {
        logger.debug("waiting for {} on the topology for server = {}", (Object)primaryNodes, (Object)server);
        Set ccs = server.getClusterManager().getClusterConnections();
        if (ccs.size() != 1) {
            throw new IllegalStateException("You need a single cluster connection on this version of waitForTopology on ServiceTestBase");
        }
        Topology topology = server.getClusterManager().getDefaultConnection(null).getTopology();
        return ActiveMQTestBase.waitForTopology(topology, timeout, primaryNodes, backupNodes);
    }

    protected static Topology waitForTopology(Topology topology, long timeout, int primaryNodes, int backupNodes) throws Exception {
        long start = System.currentTimeMillis();
        int primaryNodesCount = 0;
        int backupNodesCount = 0;
        do {
            primaryNodesCount = 0;
            backupNodesCount = 0;
            for (TopologyMemberImpl member : topology.getMembers()) {
                if (member.getPrimary() != null) {
                    ++primaryNodesCount;
                }
                if (member.getBackup() == null) continue;
                ++backupNodesCount;
            }
            if (!(primaryNodes != -1 && primaryNodes != primaryNodesCount || backupNodes != -1 && backupNodes != backupNodesCount)) {
                return topology;
            }
            Thread.sleep(10L);
        } while (System.currentTimeMillis() - start < timeout);
        String msg = "Timed out waiting for cluster topology of live=" + primaryNodes + ",backup=" + backupNodes + " (received live=" + primaryNodesCount + ", backup=" + backupNodesCount + ") topology = " + topology.describe() + ")";
        logger.error(msg);
        throw new Exception(msg);
    }

    protected void waitForTopology(ActiveMQServer server, String clusterConnectionName, int nodes, long timeout) throws Exception {
        logger.debug("waiting for {} on the topology for server = {}", (Object)nodes, (Object)server);
        long start = System.currentTimeMillis();
        ClusterConnection clusterConnection = server.getClusterManager().getClusterConnection(clusterConnectionName);
        Topology topology = clusterConnection.getTopology();
        do {
            if (nodes == topology.getMembers().size()) {
                return;
            }
            Thread.sleep(10L);
        } while (System.currentTimeMillis() - start < timeout);
        String msg = "Timed out waiting for cluster topology of " + nodes + " (received " + topology.getMembers().size() + ") topology = " + topology + ")";
        logger.error(msg);
        throw new Exception(msg);
    }

    protected static final void waitForComponent(ActiveMQComponent component, long seconds) throws InterruptedException {
        long time = System.currentTimeMillis();
        long toWait = seconds * 1000L;
        while (!component.isStarted()) {
            Thread.sleep(50L);
            if (System.currentTimeMillis() <= time + toWait) continue;
            Assertions.fail((String)("component did not start within timeout of " + seconds));
        }
    }

    protected static final void waitForBridges(ActiveMQServer server, int connectedBridges) throws Exception {
        ActiveMQTestBase.waitForBridges(server.getClusterManager().getDefaultConnection(null), connectedBridges);
    }

    protected static final void waitForBridges(ClusterConnection clusterConnection, int connectedBridges) throws Exception {
        Wait.assertTrue(() -> Arrays.stream(clusterConnection.getBridges()).filter(bridge -> bridge.isConnected()).count() >= (long)connectedBridges);
    }

    protected static final Map<String, Object> generateParams(int node, boolean netty) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (netty) {
            params.put("port", 61616 + node);
        } else {
            params.put("serverId", node);
        }
        return params;
    }

    protected TransportConfiguration getNettyAcceptorTransportConfiguration(boolean live) {
        if (live) {
            return new TransportConfiguration(NETTY_ACCEPTOR_FACTORY);
        }
        HashMap<String, Integer> server1Params = new HashMap<String, Integer>();
        server1Params.put("port", 61617);
        return new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, server1Params);
    }

    protected TransportConfiguration getNettyConnectorTransportConfiguration(boolean live) {
        if (live) {
            return new TransportConfiguration(NETTY_CONNECTOR_FACTORY);
        }
        HashMap<String, Integer> server1Params = new HashMap<String, Integer>();
        server1Params.put("port", 61617);
        server1Params.put("connect-timeout-millis", 1000);
        return new TransportConfiguration(NETTY_CONNECTOR_FACTORY, server1Params);
    }

    protected static final TransportConfiguration createTransportConfiguration(boolean netty, boolean acceptor, Map<String, Object> params) {
        return ActiveMQTestBase.createTransportConfiguration(UUIDGenerator.getInstance().generateStringUUID(), netty, acceptor, params);
    }

    protected static final TransportConfiguration createTransportConfiguration(String name, boolean netty, boolean acceptor, Map<String, Object> params) {
        String className = netty ? (acceptor ? NETTY_ACCEPTOR_FACTORY : NETTY_CONNECTOR_FACTORY) : (acceptor ? INVM_ACCEPTOR_FACTORY : INVM_CONNECTOR_FACTORY);
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        return new TransportConfiguration(className, params, name, new HashMap());
    }

    protected void waitForServerToStart(ActiveMQServer server) throws InterruptedException {
        this.waitForServerToStart(server, true);
    }

    protected void waitForServerToStart(ActiveMQServer server, boolean activation) throws InterruptedException {
        if (server == null) {
            return;
        }
        long wait = 5000L;
        long timetowait = System.currentTimeMillis() + 5000L;
        while (!server.isStarted() && System.currentTimeMillis() < timetowait) {
            Thread.sleep(50L);
        }
        if (!server.isStarted()) {
            logger.info(ActiveMQTestBase.threadDump("Server didn't start"));
            Assertions.fail((String)("server didn't start: " + server));
        }
        if (activation && !server.getHAPolicy().isBackup() && !server.waitForActivation(5000L, TimeUnit.MILLISECONDS)) {
            Assertions.fail((String)("Server didn't initialize: " + server));
        }
    }

    protected void waitForServerToStop(ActiveMQServer server) throws InterruptedException {
        if (server == null) {
            return;
        }
        long wait = 5000L;
        long timetowait = System.currentTimeMillis() + 5000L;
        while (server.isStarted() && System.currentTimeMillis() < timetowait) {
            Thread.sleep(50L);
        }
        if (server.isStarted()) {
            logger.info(ActiveMQTestBase.threadDump("Server didn't start"));
            Assertions.fail((String)("Server didn't start: " + server));
        }
    }

    public static final void waitForRemoteBackupSynchronization(ActiveMQServer backup) {
        ActiveMQTestBase.waitForRemoteBackup(null, 20, true, backup);
    }

    public static final void waitForRemoteBackup(ClientSessionFactory sessionFactoryP, int seconds, boolean waitForSync, ActiveMQServer backup) {
        ClientSessionFactoryInternal sessionFactory = (ClientSessionFactoryInternal)sessionFactoryP;
        ActiveMQServerImpl actualServer = (ActiveMQServerImpl)backup;
        long toWait = (long)seconds * 1000L;
        long time = System.currentTimeMillis();
        int loop = 0;
        int maxLoop = 40;
        while (true) {
            Activation activation = actualServer.getActivation();
            boolean isReplicated = !backup.getHAPolicy().isSharedStore();
            boolean isRemoteUpToDate = true;
            if (isReplicated) {
                isRemoteUpToDate = activation instanceof SharedNothingBackupActivation ? backup.isReplicaSync() : (activation instanceof ReplicationBackupActivation ? backup.isReplicaSync() : (actualServer.isStarted() ? loop++ > 40 : false));
            }
            if (!(sessionFactory != null && sessionFactory.getBackupConnector() == null || !isRemoteUpToDate && waitForSync) && (!waitForSync || actualServer.getBackupManager() != null && actualServer.getBackupManager().isBackupAnnounced())) break;
            if (System.currentTimeMillis() > time + toWait) {
                String threadDump = ActiveMQTestBase.threadDump("can't get synchronization finished " + backup.isReplicaSync());
                System.err.println(threadDump);
                Assertions.fail((String)("backup started? (" + actualServer.isStarted() + "). Finished synchronizing (" + activation + "). SessionFactory!=null ? " + (sessionFactory != null) + " || sessionFactory.getBackupConnector()==" + (sessionFactory != null ? sessionFactory.getBackupConnector() : "not-applicable") + "\n" + threadDump));
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Assertions.fail((String)e.getMessage());
            }
        }
    }

    public static final void waitForRemoteBackup(ClientSessionFactory sessionFactory, int seconds) {
        ClientSessionFactoryInternal factoryInternal = (ClientSessionFactoryInternal)sessionFactory;
        long toWait = (long)seconds * 1000L;
        long time = System.currentTimeMillis();
        while (factoryInternal.getBackupConnector() == null) {
            if (System.currentTimeMillis() > time + toWait) {
                Assertions.fail((String)"Backup wasn't located");
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Assertions.fail((String)e.getMessage());
            }
        }
    }

    protected final ActiveMQServer createServer(boolean realFiles, Configuration configuration, int pageSize, long maxAddressSize) {
        return this.createServer(realFiles, configuration, pageSize, maxAddressSize, null);
    }

    protected final ActiveMQServer createServer(boolean realFiles, Configuration configuration, int pageSize, long maxAddressSize, int maxReadMessages, int maxReadBytes) {
        return this.createServer(realFiles, configuration, pageSize, maxAddressSize, maxReadMessages, maxReadBytes, null);
    }

    protected final ActiveMQServer createServer(boolean realFiles, Configuration configuration, int pageSize, long maxAddressSize, Map<String, AddressSettings> settings) {
        return this.createServer(realFiles, configuration, pageSize, maxAddressSize, null, null, settings);
    }

    protected final ActiveMQServer createServer(boolean realFiles, Configuration configuration, int pageSize, long maxAddressSize, Integer maxReadPageMessages, Integer maxReadPageBytes, Map<String, AddressSettings> settings) {
        return this.createServer(realFiles, configuration, pageSize, maxAddressSize, maxReadPageMessages, maxReadPageBytes, null, null, null, settings);
    }

    protected final ActiveMQServer createServer(boolean realFiles, Configuration configuration, int pageSize, long maxAddressSize, Integer maxReadPageMessages, Integer maxReadPageBytes, Long pageLimitBytes, Long pageLimitMessages, String pageLimitPolicy, Map<String, AddressSettings> settings) {
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)configuration, (boolean)realFiles));
        if (settings != null) {
            for (Map.Entry<String, AddressSettings> setting : settings.entrySet()) {
                if (maxReadPageBytes != null) {
                    setting.getValue().setMaxReadPageBytes(maxReadPageBytes.intValue());
                }
                if (maxReadPageMessages != null) {
                    setting.getValue().setMaxReadPageMessages(maxReadPageMessages.intValue());
                }
                if (pageLimitBytes != null) {
                    setting.getValue().setPageLimitBytes(pageLimitBytes);
                }
                if (pageLimitMessages != null) {
                    setting.getValue().setPageLimitMessages(pageLimitMessages);
                }
                if (pageLimitPolicy != null) {
                    setting.getValue().setPageFullMessagePolicy(PageFullMessagePolicy.valueOf((String)pageLimitPolicy));
                }
                server.getAddressSettingsRepository().addMatch(setting.getKey(), (Object)setting.getValue());
            }
        }
        AddressSettings defaultSetting = new AddressSettings().setPageSizeBytes(pageSize).setMaxSizeBytes(maxAddressSize).setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
        if (maxReadPageBytes != null) {
            defaultSetting.setMaxReadPageBytes(maxReadPageBytes.intValue());
        }
        if (maxReadPageMessages != null) {
            defaultSetting.setMaxReadPageMessages(maxReadPageMessages.intValue());
        }
        if (pageLimitBytes != null) {
            defaultSetting.setPageLimitBytes(pageLimitBytes);
        }
        if (pageLimitMessages != null) {
            defaultSetting.setPageLimitMessages(pageLimitMessages);
        }
        if (pageLimitPolicy != null) {
            defaultSetting.setPageFullMessagePolicy(PageFullMessagePolicy.valueOf((String)pageLimitPolicy));
        }
        server.getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
        this.applySettings(server, configuration, pageSize, maxAddressSize, maxReadPageMessages, maxReadPageBytes, settings);
        return server;
    }

    protected void applySettings(ActiveMQServer server, Configuration configuration, int pageSize, long maxAddressSize, Integer maxReadPageMessages, Integer maxReadPageBytes, Map<String, AddressSettings> settings) {
    }

    protected final ActiveMQServer createServer(boolean realFiles, Configuration configuration, int pageSize, long maxAddressSize, Map<String, AddressSettings> settings, StoreConfiguration.StoreType storeType) {
        if (storeType == StoreConfiguration.StoreType.DATABASE) {
            this.setDBStoreType(configuration);
        }
        return this.createServer(realFiles, configuration, pageSize, maxAddressSize, -1, -1, settings);
    }

    protected final ActiveMQServer createServer(boolean realFiles) throws Exception {
        return this.createServer(realFiles, false);
    }

    protected final ActiveMQServer createServer(boolean realFiles, boolean netty) throws Exception {
        return this.createServer(realFiles, this.createDefaultConfig(netty), 0xA00000, -1L, -1, -1);
    }

    protected ActiveMQServer createServer(boolean realFiles, Configuration configuration) {
        return this.createServer(realFiles, configuration, 0xA00000, -1L);
    }

    protected final ActiveMQServer createServer(Configuration configuration) {
        return this.createServer(configuration.isPersistenceEnabled(), configuration, 0xA00000, -1L);
    }

    protected ActiveMQServer createServer(boolean realFiles, boolean isNetty, StoreConfiguration.StoreType storeType) throws Exception {
        Configuration configuration = storeType == StoreConfiguration.StoreType.DATABASE ? this.createDefaultJDBCConfig(isNetty) : this.createDefaultConfig(isNetty);
        return this.createServer(realFiles, configuration, 0xA00000, -1L);
    }

    protected ActiveMQServer createInVMFailoverServer(boolean realFiles, Configuration configuration, NodeManager nodeManager, int id) {
        return this.createInVMFailoverServer(realFiles, configuration, -1, -1, new HashMap<String, AddressSettings>(), nodeManager, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ActiveMQServer createInVMFailoverServer(boolean realFiles, Configuration configuration, int pageSize, int maxAddressSize, Map<String, AddressSettings> settings, NodeManager nodeManager, int id) {
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager(InVMLoginModule.class.getName(), new SecurityConfiguration());
        configuration.setPersistenceEnabled(realFiles);
        ActiveMQServer server = this.addServer((ActiveMQServer)new InVMNodeManagerServer(configuration, ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, nodeManager));
        try {
            server.setIdentity("Server " + id);
            for (Map.Entry<String, AddressSettings> setting : settings.entrySet()) {
                server.getAddressSettingsRepository().addMatch(setting.getKey(), (Object)setting.getValue());
            }
            AddressSettings defaultSetting = new AddressSettings();
            defaultSetting.setPageSizeBytes(pageSize);
            defaultSetting.setMaxSizeBytes((long)maxAddressSize).setMaxReadPageBytes(-1).setMaxSizeBytes(-1L);
            server.getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
            ActiveMQServer activeMQServer = server;
            return activeMQServer;
        }
        finally {
            this.addServer(server);
        }
    }

    protected ActiveMQServer createColocatedInVMFailoverServer(boolean realFiles, Configuration configuration, NodeManager primaryNodeManager, NodeManager backupNodeManager, int id) {
        return this.createColocatedInVMFailoverServer(realFiles, configuration, -1, -1, new HashMap<String, AddressSettings>(), primaryNodeManager, backupNodeManager, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ActiveMQServer createColocatedInVMFailoverServer(boolean realFiles, Configuration configuration, int pageSize, int maxAddressSize, Map<String, AddressSettings> settings, NodeManager primaryNodeManager, NodeManager backupNodeManager, int id) {
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager(InVMLoginModule.class.getName(), new SecurityConfiguration());
        configuration.setPersistenceEnabled(realFiles);
        ColocatedActiveMQServer server = new ColocatedActiveMQServer(configuration, ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, primaryNodeManager, backupNodeManager);
        try {
            server.setIdentity("Server " + id);
            for (Map.Entry<String, AddressSettings> setting : settings.entrySet()) {
                server.getAddressSettingsRepository().addMatch(setting.getKey(), (Object)setting.getValue());
            }
            AddressSettings defaultSetting = new AddressSettings();
            defaultSetting.setPageSizeBytes(pageSize);
            defaultSetting.setMaxSizeBytes((long)maxAddressSize);
            server.getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
            ColocatedActiveMQServer colocatedActiveMQServer = server;
            return colocatedActiveMQServer;
        }
        finally {
            this.addServer((ActiveMQServer)server);
        }
    }

    protected ActiveMQServer createClusteredServerWithParams(boolean isNetty, int index, boolean realFiles, Map<String, Object> params) throws Exception {
        String acceptor = isNetty ? NETTY_ACCEPTOR_FACTORY : INVM_ACCEPTOR_FACTORY;
        return this.createServer(realFiles, this.createDefaultConfig(index, params, acceptor), -1, -1L);
    }

    protected ActiveMQServer createClusteredServerWithParams(boolean isNetty, int index, boolean realFiles, int pageSize, int maxAddressSize, Map<String, Object> params) throws Exception {
        return this.createServer(realFiles, this.createDefaultConfig(index, params, isNetty ? NETTY_ACCEPTOR_FACTORY : INVM_ACCEPTOR_FACTORY), pageSize, maxAddressSize);
    }

    protected ServerLocator createFactory(boolean isNetty) throws Exception {
        if (isNetty) {
            return this.createNettyNonHALocator();
        }
        return this.createInVMNonHALocator();
    }

    protected void createAnycastPair(ActiveMQServer server, String queueName) throws Exception {
        server.addAddressInfo(new AddressInfo(queueName).addRoutingType(RoutingType.ANYCAST).setAutoCreated(false));
        server.createQueue(QueueConfiguration.of((String)queueName).setRoutingType(RoutingType.ANYCAST).setAddress(queueName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createQueue(String address, String queue) throws Exception {
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = locator.createSessionFactory();
        ClientSession session = sf.createSession();
        try {
            session.createQueue(QueueConfiguration.of((String)queue).setAddress(address));
        }
        finally {
            session.close();
            ActiveMQTestBase.closeSessionFactory(sf);
            ActiveMQTestBase.closeServerLocator(locator);
        }
    }

    protected final ServerLocator createInVMLocator(int serverID) {
        TransportConfiguration tnspConfig = this.createInVMTransportConnectorConfig(serverID, UUIDGenerator.getInstance().generateStringUUID());
        ServerLocator locator = ActiveMQClient.createServerLocatorWithHA((TransportConfiguration[])new TransportConfiguration[]{tnspConfig});
        return this.addServerLocator(locator);
    }

    protected final TransportConfiguration createInVMTransportConnectorConfig(int serverID, String name1) {
        HashMap<String, Integer> server1Params = new HashMap<String, Integer>();
        if (serverID != 0) {
            server1Params.put("serverId", serverID);
        }
        TransportConfiguration tnspConfig = new TransportConfiguration(INVM_CONNECTOR_FACTORY, server1Params, name1);
        return tnspConfig;
    }

    public String getTextMessage(ClientMessage m) {
        m.getBodyBuffer().resetReaderIndex();
        return m.getBodyBuffer().readString();
    }

    protected ClientMessage createBytesMessage(ClientSession session, byte type, byte[] b, boolean durable) {
        ClientMessage message = session.createMessage(type, durable, 0L, System.currentTimeMillis(), (byte)1);
        message.getBodyBuffer().writeBytes(b);
        return message;
    }

    protected void setBody(int i, ClientMessage message) {
        message.getBodyBuffer().writeString("message" + i);
    }

    protected void assertMessageBody(int i, ClientMessage message) {
        Assertions.assertEquals((Object)("message" + i), (Object)message.getBodyBuffer().readString(), (String)message.toString());
    }

    public final void sendMessages(ClientSession session, ClientProducer producer, int numMessages) throws ActiveMQException {
        for (int i = 0; i < numMessages; ++i) {
            producer.send((Message)this.createMessage(session, i, true));
        }
    }

    public List<String> sendMessageBatch(int batchSize, ClientSession session, SimpleString queueAddr) throws ActiveMQException {
        return this.sendMessageBatch(batchSize, 1024, session, queueAddr);
    }

    public ClientMessage createMessage(ClientSession session, int messageSize, int seq, List<String> collectIds) {
        ClientMessage message = session.createMessage(true);
        message.getBodyBuffer().writeBytes(new byte[messageSize]);
        String id = UUID.randomUUID().toString();
        message.putStringProperty("id", id);
        message.putIntProperty("seq", seq);
        if (collectIds != null) {
            collectIds.add(id);
        }
        return message;
    }

    public List<String> sendMessageBatch(int batchSize, int messageSize, ClientSession session, SimpleString queueAddr) throws ActiveMQException {
        ArrayList<String> messageIds = new ArrayList<String>();
        ClientProducer producer = session.createProducer(queueAddr);
        for (int i = 0; i < batchSize; ++i) {
            ClientMessage message = this.createMessage(session, messageSize, i, messageIds);
            producer.send((Message)message);
        }
        session.commit();
        return messageIds;
    }

    public boolean waitForMessages(Queue queue, int count, long timeout) throws Exception {
        long timeToWait = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < timeToWait) {
            if (queue.getMessageCount() >= (long)count) {
                return true;
            }
            Thread.sleep(100L);
        }
        return false;
    }

    protected final ClientMessage createMessage(ClientSession session, int counter, boolean durable) throws ActiveMQException {
        ClientMessage message = session.createMessage(durable);
        this.setBody(counter, message);
        message.putIntProperty("counter", counter);
        message.putIntProperty(SEND_CALL_NUMBER, this.sendMsgCount++);
        return message;
    }

    protected final void receiveMessages(ClientConsumer consumer, int start, int msgCount, boolean ack) throws ActiveMQException {
        for (int i = start; i < msgCount; ++i) {
            ClientMessage message = consumer.receive(1000L);
            Assertions.assertNotNull((Object)message, (String)("Expecting a message " + i));
            Object prop = message.getObjectProperty(SEND_CALL_NUMBER);
            if (prop == null) {
                prop = -1;
            }
            int actual = message.getIntProperty("counter");
            Assertions.assertEquals((int)i, (int)actual, (String)("expected=" + i + ". Got: property['counter']=" + actual + " sendNumber=" + prop));
            this.assertMessageBody(i, message);
            if (!ack) continue;
            message.acknowledge();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Pair<List<RecordInfo>, List<PreparedTransactionInfo>> loadMessageJournal(Configuration config) throws Exception {
        JournalImpl messagesJournal = null;
        try {
            NIOSequentialFileFactory messagesFF = new NIOSequentialFileFactory(new File(this.getJournalDir()), null, 1);
            messagesJournal = new JournalImpl(config.getJournalFileSize(), config.getJournalMinFiles(), config.getJournalPoolFiles(), 0, 0, (SequentialFileFactory)messagesFF, "activemq-data", "amq", 1);
            LinkedList committedRecords = new LinkedList();
            LinkedList preparedTransactions = new LinkedList();
            messagesJournal.start();
            messagesJournal.load(committedRecords, preparedTransactions, null, false);
            Pair pair = new Pair(committedRecords, preparedTransactions);
            return pair;
        }
        finally {
            try {
                if (messagesJournal != null) {
                    messagesJournal.stop();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    protected HashMap<Integer, AtomicInteger> countJournal(Configuration config) throws Exception {
        File location = config.getJournalLocation();
        return this.countJournal(location, config.getJournalFileSize(), config.getJournalMinFiles(), config.getJournalPoolFiles());
    }

    protected HashMap<Integer, AtomicInteger> countJournal(File location, int journalFileSize, int minFiles, int poolfiles) throws Exception {
        HashMap<Integer, AtomicInteger> recordsType = new HashMap<Integer, AtomicInteger>();
        NIOSequentialFileFactory messagesFF = new NIOSequentialFileFactory(location, null, 1);
        JournalImpl messagesJournal = new JournalImpl(journalFileSize, minFiles, poolfiles, 0, 0, (SequentialFileFactory)messagesFF, "activemq-data", "amq", 1);
        List filesToRead = messagesJournal.orderFiles();
        for (JournalFile file : filesToRead) {
            JournalImpl.readJournalFile((SequentialFileFactory)messagesFF, (JournalFile)file, (JournalReaderCallback)new RecordTypeCounter(recordsType));
        }
        return recordsType;
    }

    protected HashMap<Integer, AtomicInteger> countBindingJournal(Configuration config) throws Exception {
        HashMap<Integer, AtomicInteger> recordsType = new HashMap<Integer, AtomicInteger>();
        NIOSequentialFileFactory messagesFF = new NIOSequentialFileFactory(config.getBindingsLocation(), null, 1);
        JournalImpl messagesJournal = new JournalImpl(config.getJournalFileSize(), config.getJournalMinFiles(), config.getJournalPoolFiles(), 0, 0, (SequentialFileFactory)messagesFF, "activemq-bindings", "bindings", 1);
        List filesToRead = messagesJournal.orderFiles();
        for (JournalFile file : filesToRead) {
            JournalImpl.readJournalFile((SequentialFileFactory)messagesFF, (JournalFile)file, (JournalReaderCallback)new RecordTypeCounter(recordsType));
        }
        return recordsType;
    }

    protected HashMap<Integer, AtomicInteger> countJournalLivingRecords(Configuration config) throws Exception {
        return this.internalCountJournalLivingRecords(config, true);
    }

    protected HashMap<Integer, AtomicInteger> internalCountJournalLivingRecords(Configuration config, boolean messageJournal) throws Exception {
        JournalImpl journal;
        NIOSequentialFileFactory ff;
        HashMap<Integer, AtomicInteger> recordsType = new HashMap<Integer, AtomicInteger>();
        if (messageJournal) {
            ff = new NIOSequentialFileFactory(config.getJournalLocation(), null, 1);
            journal = new JournalImpl(config.getJournalFileSize(), config.getJournalMinFiles(), config.getJournalPoolFiles(), 0, 0, (SequentialFileFactory)ff, "activemq-data", "amq", 1);
        } else {
            ff = new NIOSequentialFileFactory(config.getBindingsLocation(), null, 1);
            journal = new JournalImpl(0x100000, 2, config.getJournalCompactMinFiles(), config.getJournalPoolFiles(), config.getJournalCompactPercentage(), (SequentialFileFactory)ff, "activemq-bindings", "bindings", 1);
        }
        journal.start();
        LinkedList committedRecords = new LinkedList();
        LinkedList preparedTransactions = new LinkedList();
        journal.load(committedRecords, preparedTransactions, null, false);
        for (RecordInfo info : committedRecords) {
            Integer ikey = info.getUserRecordType();
            AtomicInteger value = recordsType.get(ikey);
            if (value == null) {
                value = new AtomicInteger();
                recordsType.put(ikey, value);
            }
            value.incrementAndGet();
        }
        journal.stop();
        return recordsType;
    }

    protected boolean waitForBindings(ActiveMQServer server, String address, boolean local, int expectedBindingCount, int expectedConsumerCount, long timeout) throws Exception {
        PostOffice po = server.getPostOffice();
        long start = System.currentTimeMillis();
        int bindingCount = 0;
        int totConsumers = 0;
        do {
            bindingCount = 0;
            totConsumers = 0;
            Bindings bindings = po.getBindingsForAddress(SimpleString.of((String)address));
            for (Binding binding : bindings.getBindings()) {
                if (!binding.isConnected() || (!(binding instanceof LocalQueueBinding) || !local) && (!(binding instanceof RemoteQueueBinding) || local)) continue;
                QueueBinding qBinding = (QueueBinding)binding;
                ++bindingCount;
                totConsumers += qBinding.consumerCount();
            }
            if (bindingCount == expectedBindingCount && (expectedConsumerCount == -1 || totConsumers == expectedConsumerCount)) {
                return true;
            }
            Thread.sleep(10L);
        } while (System.currentTimeMillis() - start < timeout);
        logger.error("Timed out waiting for bindings (bindingCount = {} (expecting {}) , totConsumers = {} (expecting {}))", new Object[]{bindingCount, expectedBindingCount, totConsumers, expectedConsumerCount});
        return false;
    }

    protected int getNumberOfFiles(File directory) {
        return directory.listFiles().length;
    }

    protected void validateNoFilesOnLargeDir(String directory, int expect) throws Exception {
        File largeMessagesFileDir = new File(directory);
        Wait.assertEquals((int)expect, () -> this.getNumberOfFiles(largeMessagesFileDir));
    }

    protected void validateNoFilesOnLargeDir() throws Exception {
        this.validateNoFilesOnLargeDir(this.getLargeMessagesDir(), 0);
    }

    public void printBindings(ActiveMQServer server, String address) throws Exception {
        PostOffice po = server.getPostOffice();
        Bindings bindings = po.getBindingsForAddress(SimpleString.of((String)address));
        System.err.println("=======================================================================");
        System.err.println("Binding information for address = " + address + " for server " + server);
        for (Binding binding : bindings.getBindings()) {
            QueueBinding qBinding = (QueueBinding)binding;
            System.err.println("Binding = " + qBinding + ", queue=" + qBinding.getQueue());
        }
    }

    private void assertAllExecutorsFinished() throws InterruptedException {
        for (ExecutorService s : this.executorSet) {
            Assertions.assertTrue((boolean)s.awaitTermination(5L, TimeUnit.SECONDS));
        }
    }

    private List<Exception> checkCsfStopped() throws Exception {
        if (!Wait.waitFor(ClientSessionFactoryImpl.CLOSE_RUNNABLES::isEmpty, (long)5000L)) {
            ArrayList closeRunnables = new ArrayList(ClientSessionFactoryImpl.CLOSE_RUNNABLES);
            ArrayList<Exception> exceptions = new ArrayList<Exception>();
            if (!closeRunnables.isEmpty()) {
                for (ClientSessionFactoryImpl.CloseRunnable closeRunnable : closeRunnables) {
                    if (closeRunnable == null) continue;
                    exceptions.add(closeRunnable.stop().createTrace);
                }
            }
            return exceptions;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertAllClientProducersAreClosed() {
        Collection<ClientProducer> collection = this.clientProducers;
        synchronized (collection) {
            for (ClientProducer p : this.clientProducers) {
                Assertions.assertTrue((boolean)p.isClosed(), (String)(p + " should be closed"));
            }
            this.clientProducers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAllOtherComponents() {
        Collection<ActiveMQComponent> collection = this.otherComponents;
        synchronized (collection) {
            for (ActiveMQComponent c : this.otherComponents) {
                ActiveMQTestBase.stopComponent(c);
            }
            this.otherComponents.clear();
        }
    }

    private void checkFilesUsage() throws Exception {
        int invmSize = InVMRegistry.instance.size();
        if (invmSize > 0) {
            InVMRegistry.instance.clear();
            logger.info(ActiveMQTestBase.threadDump("Thread dump"));
            Assertions.fail((String)"invm registry still had acceptors registered");
        }
    }

    private void cleanupPools() {
        OperationContextImpl.clearContext();
        try {
            ServerLocatorImpl.clearThreadPools();
        }
        catch (Throwable e) {
            logger.info(ActiveMQTestBase.threadDump(e.getMessage()));
            System.err.println(ActiveMQTestBase.threadDump(e.getMessage()));
        }
        try {
            NettyConnector.clearThreadPools();
        }
        catch (Exception e) {
            logger.info(ActiveMQTestBase.threadDump(e.getMessage()));
            System.err.println(ActiveMQTestBase.threadDump(e.getMessage()));
        }
    }

    protected static final void recreateDirectory(String directory) {
        File file = new File(directory);
        ActiveMQTestBase.deleteDirectory(file);
        file.mkdirs();
    }

    protected static final boolean deleteDirectory(File directory) {
        return FileUtil.deleteDirectory((File)directory);
    }

    protected static final void copyRecursive(File from, File to) throws Exception {
        if (from.isDirectory()) {
            String[] subs;
            if (!to.exists()) {
                to.mkdir();
            }
            for (String sub : subs = from.list()) {
                ActiveMQTestBase.copyRecursive(new File(from, sub), new File(to, sub));
            }
        } else {
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(from));
                 BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(to));){
                int b;
                while ((b = ((InputStream)in).read()) != -1) {
                    ((OutputStream)out).write(b);
                }
            }
        }
    }

    protected void assertRefListsIdenticalRefs(List<MessageReference> l1, List<MessageReference> l2) {
        if (l1.size() != l2.size()) {
            Assertions.fail((String)("Lists different sizes: " + l1.size() + ", " + l2.size()));
        }
        Iterator<MessageReference> iter1 = l1.iterator();
        Iterator<MessageReference> iter2 = l2.iterator();
        while (iter1.hasNext()) {
            MessageReference o2;
            MessageReference o1 = iter1.next();
            Assertions.assertTrue((o1 == (o2 = iter2.next()) ? (byte)1 : 0) != 0, (String)("expected " + o1 + " but was " + o2));
        }
    }

    protected Message generateMessage(long id) {
        CoreMessage message = new CoreMessage(id, 1000);
        message.setMessageID(id);
        message.getBodyBuffer().writeString(UUID.randomUUID().toString());
        message.setAddress(SimpleString.of((String)"foo"));
        return message;
    }

    protected MessageReference generateReference(Queue queue, long id) {
        Message message = this.generateMessage(id);
        return MessageReference.Factory.createReference((Message)message, (Queue)queue);
    }

    protected int calculateRecordSize(int size, int alignment) {
        return (size / alignment + (size % alignment != 0 ? 1 : 0)) * alignment;
    }

    protected ClientMessage createTextMessage(ClientSession session, String s) {
        return this.createTextMessage(session, s, true);
    }

    protected ClientMessage createTextMessage(ClientSession session, String s, boolean durable) {
        ClientMessage message = session.createMessage((byte)3, durable, 0L, System.currentTimeMillis(), (byte)4);
        message.getBodyBuffer().writeString(s);
        return message;
    }

    protected ClientMessage createTextMessage(ClientSession session, boolean durable, int numChars) {
        ClientMessage message = session.createMessage((byte)3, durable, 0L, System.currentTimeMillis(), (byte)4);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < numChars; ++i) {
            builder.append('a');
        }
        message.getBodyBuffer().writeString(builder.toString());
        return message;
    }

    protected XidImpl newXID() {
        return new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
    }

    protected int getMessageCount(ActiveMQServer service, String address) throws Exception {
        return this.getMessageCount(service.getPostOffice(), address);
    }

    protected int getMessageCount(PostOffice postOffice, String address) throws Exception {
        int messageCount = 0;
        List<QueueBinding> bindings = this.getLocalQueueBindings(postOffice, address);
        for (QueueBinding qBinding : bindings) {
            qBinding.getQueue().flushExecutor();
            messageCount += this.getMessageCount(qBinding.getQueue());
        }
        return messageCount;
    }

    protected int getMessageCount(Queue queue) {
        try {
            Wait.waitFor(() -> !queue.getPageSubscription().isCounterPending());
        }
        catch (Exception exception) {
            // empty catch block
        }
        queue.flushExecutor();
        return (int)queue.getMessageCount();
    }

    protected int getMessagesAdded(PostOffice postOffice, String address) throws Exception {
        int messageCount = 0;
        List<QueueBinding> bindings = this.getLocalQueueBindings(postOffice, address);
        for (QueueBinding qBinding : bindings) {
            qBinding.getQueue().flushExecutor();
            messageCount += this.getMessagesAdded(qBinding.getQueue());
        }
        return messageCount;
    }

    protected int getMessagesAdded(Queue queue) {
        queue.flushExecutor();
        return (int)queue.getMessagesAdded();
    }

    private List<QueueBinding> getLocalQueueBindings(PostOffice postOffice, String address) throws Exception {
        ArrayList<QueueBinding> bindingsFound = new ArrayList<QueueBinding>();
        Bindings bindings = postOffice.getBindingsForAddress(SimpleString.of((String)address));
        for (Binding binding : bindings.getBindings()) {
            if (!(binding instanceof LocalQueueBinding)) continue;
            bindingsFound.add((QueueBinding)binding);
        }
        return bindingsFound;
    }

    protected final ServerLocator createInVMNonHALocator() {
        return this.createNonHALocator(false);
    }

    protected final ServerLocator createNettyNonHALocator() {
        return this.createNonHALocator(true);
    }

    protected final ServerLocator createNonHALocator(boolean isNetty) {
        ServerLocator locatorWithoutHA = this.internalCreateNonHALocator(isNetty);
        return this.addServerLocator(locatorWithoutHA);
    }

    public ServerLocator internalCreateNonHALocator(boolean isNetty) {
        return isNetty ? ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(NETTY_CONNECTOR_FACTORY)}) : ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY)});
    }

    protected static final void stopComponent(ActiveMQComponent component) {
        if (component == null) {
            return;
        }
        try {
            component.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static final void stopComponentOutputExceptions(ActiveMQComponent component) {
        if (component == null) {
            return;
        }
        try {
            component.stop();
        }
        catch (Exception e) {
            System.err.println("Exception closing " + component);
            e.printStackTrace();
        }
    }

    protected final ClientSessionFactory createSessionFactory(ServerLocator locator) throws Exception {
        ClientSessionFactory sf = locator.createSessionFactory();
        this.addSessionFactory(sf);
        return sf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ActiveMQServer addServer(ActiveMQServer server) {
        if (server != null) {
            Collection<ActiveMQServer> collection = this.servers;
            synchronized (collection) {
                this.servers.add(server);
            }
        }
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ServerLocator addServerLocator(ServerLocator locator) {
        if (locator != null) {
            Collection<ServerLocator> collection = this.locators;
            synchronized (collection) {
                this.locators.add(locator);
            }
        }
        return locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ClientSession addClientSession(ClientSession session) {
        if (session != null) {
            Collection<ClientSession> collection = this.clientSessions;
            synchronized (collection) {
                this.clientSessions.add(session);
            }
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ClientConsumer addClientConsumer(ClientConsumer consumer) {
        if (consumer != null) {
            Collection<ClientConsumer> collection = this.clientConsumers;
            synchronized (collection) {
                this.clientConsumers.add(consumer);
            }
        }
        return consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ClientProducer addClientProducer(ClientProducer producer) {
        if (producer != null) {
            Collection<ClientProducer> collection = this.clientProducers;
            synchronized (collection) {
                this.clientProducers.add(producer);
            }
        }
        return producer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addActiveMQComponent(ActiveMQComponent component) {
        if (component != null) {
            Collection<ActiveMQComponent> collection = this.otherComponents;
            synchronized (collection) {
                this.otherComponents.add(component);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ClientSessionFactory addSessionFactory(ClientSessionFactory sf) {
        if (sf != null) {
            Collection<ClientSessionFactory> collection = this.sessionFactories;
            synchronized (collection) {
                this.sessionFactories.add(sf);
            }
        }
        return sf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertAllClientConsumersAreClosed() {
        Collection<ClientConsumer> collection = this.clientConsumers;
        synchronized (collection) {
            for (ClientConsumer cc : this.clientConsumers) {
                if (cc == null) continue;
                Assertions.assertTrue((boolean)cc.isClosed());
            }
            this.clientConsumers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertAllClientSessionsAreClosed() {
        Collection<ClientSession> collection = this.clientSessions;
        synchronized (collection) {
            for (ClientSession cs : this.clientSessions) {
                if (cs == null) continue;
                Assertions.assertTrue((boolean)cs.isClosed());
            }
            this.clientSessions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeAllSessionFactories() {
        Collection<ClientSessionFactory> collection = this.sessionFactories;
        synchronized (collection) {
            for (ClientSessionFactory sf : this.sessionFactories) {
                if (sf.isClosed()) continue;
                ActiveMQTestBase.closeSessionFactory(sf);
                assert (sf.isClosed());
            }
            this.sessionFactories.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeAllServerLocatorsFactories() {
        Collection<ServerLocator> collection = this.locators;
        synchronized (collection) {
            for (ServerLocator locator : this.locators) {
                ActiveMQTestBase.closeServerLocator(locator);
            }
            this.locators.clear();
        }
    }

    public static final void closeServerLocator(ServerLocator locator) {
        if (locator == null) {
            return;
        }
        try {
            locator.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void closeSessionFactory(ClientSessionFactory sf) {
        if (sf == null) {
            return;
        }
        try {
            sf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void crashAndWaitForFailure(ActiveMQServer server, ClientSession ... sessions) throws Exception {
        CountDownLatch latch = new CountDownLatch(sessions.length);
        for (ClientSession session : sessions) {
            CountDownSessionFailureListener listener = new CountDownSessionFailureListener(latch, session);
            session.addFailureListener((SessionFailureListener)listener);
        }
        ClusterManager clusterManager = server.getClusterManager();
        clusterManager.flushExecutor();
        clusterManager.clear();
        Assertions.assertTrue((boolean)server.isStarted(), (String)"server should be running!");
        server.fail(true);
        if (sessions.length > 0) {
            boolean ok = latch.await(10000L, TimeUnit.MILLISECONDS);
            Assertions.assertTrue((boolean)ok, (String)("Failed to stop the server! Latch count is " + latch.getCount() + " out of " + sessions.length));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void crashAndWaitForFailure(ActiveMQServer server, ServerLocator locator) throws Exception {
        ClientSessionFactory sf = locator.createSessionFactory();
        ClientSession session = sf.createSession();
        try {
            ActiveMQTestBase.crashAndWaitForFailure(server, session);
        }
        finally {
            try {
                session.close();
                sf.close();
            }
            catch (Exception exception) {}
        }
    }

    public boolean runWithTimeout(final RunnerWithEX runner, long timeoutMilliseconds) throws Throwable {
        class ThreadRunner
        extends Thread {
            Throwable t;
            final RunnerWithEX run;

            ThreadRunner(RunnerWithEX run) {
                this.run = run;
            }

            @Override
            public void run() {
                try {
                    runner.run();
                }
                catch (Throwable t) {
                    this.t = t;
                }
            }
        }
        ThreadRunner runnerThread = new ThreadRunner(runner);
        runnerThread.start();
        boolean hadToInterrupt = false;
        while (runnerThread.isAlive()) {
            runnerThread.join(timeoutMilliseconds);
            if (!runnerThread.isAlive()) continue;
            System.err.println("Thread still running, interrupting it now:");
            for (StackTraceElement t : runnerThread.getStackTrace()) {
                System.err.println(t);
            }
            hadToInterrupt = true;
            runnerThread.interrupt();
        }
        if (runnerThread.t != null) {
            runnerThread.t.printStackTrace();
            throw runnerThread.t;
        }
        return !hadToInterrupt;
    }

    public String createJsonFilter(String fieldName, String operationName, String value) {
        HashMap<String, String> filterMap = new HashMap<String, String>();
        filterMap.put("field", fieldName);
        filterMap.put("operation", operationName);
        filterMap.put("value", value);
        JsonObject jsonFilterObject = JsonUtil.toJsonObject(filterMap);
        return jsonFilterObject.toString();
    }

    protected static ReplicationEndpoint getReplicationEndpoint(ActiveMQServer server) {
        Activation activation = server.getActivation();
        if (activation instanceof SharedNothingBackupActivation) {
            return ((SharedNothingBackupActivation)activation).getReplicationEndpoint();
        }
        if (activation instanceof ReplicationBackupActivation) {
            return ((ReplicationBackupActivation)activation).getReplicationEndpoint();
        }
        return null;
    }

    public static void waitForLatch(CountDownLatch latch) throws InterruptedException {
        Assertions.assertTrue((boolean)latch.await(1L, TimeUnit.MINUTES), (String)"Latch has got to return within a minute");
    }

    static {
        Env.setTestEnv((boolean)true);
        portCheckExtension = new PortCheckExtension(new int[]{61616});
        INVM_ACCEPTOR_FACTORY = InVMAcceptorFactory.class.getCanonicalName();
        INVM_CONNECTOR_FACTORY = InVMConnectorFactory.class.getCanonicalName();
        NETTY_ACCEPTOR_FACTORY = NettyAcceptorFactory.class.getCanonicalName();
        NETTY_CONNECTOR_FACTORY = NettyConnectorFactory.class.getCanonicalName();
        OS_TYPE = System.getProperty("os.name").toLowerCase();
        alreadyFailedThread = new HashSet<Thread>();
        Random random = new Random();
        DEFAULT_UDP_PORT = 6000 + random.nextInt(1000);
    }

    protected static interface ActiveMQAction {
        public void run() throws Exception;
    }

    private static final class RecordTypeCounter
    implements JournalReaderCallback {
        private final HashMap<Integer, AtomicInteger> recordsType;

        private RecordTypeCounter(HashMap<Integer, AtomicInteger> recordsType) {
            this.recordsType = recordsType;
        }

        AtomicInteger getType(byte key) {
            Integer ikey = key;
            AtomicInteger value = this.recordsType.get(ikey);
            if (value == null) {
                value = new AtomicInteger();
                this.recordsType.put(ikey, value);
            }
            return value;
        }

        public void onReadUpdateRecordTX(long transactionID, RecordInfo recordInfo) throws Exception {
            this.getType(recordInfo.getUserRecordType()).incrementAndGet();
        }

        public void onReadUpdateRecord(RecordInfo recordInfo) throws Exception {
            this.getType(recordInfo.getUserRecordType()).incrementAndGet();
        }

        public void onReadAddRecordTX(long transactionID, RecordInfo recordInfo) throws Exception {
            this.getType(recordInfo.getUserRecordType()).incrementAndGet();
        }

        public void onReadAddRecord(RecordInfo recordInfo) throws Exception {
            this.getType(recordInfo.getUserRecordType()).incrementAndGet();
        }

        public void onReadRollbackRecord(long transactionID) throws Exception {
        }

        public void onReadPrepareRecord(long transactionID, byte[] extraData, int numberOfRecords) throws Exception {
        }

        public void onReadDeleteRecordTX(long transactionID, RecordInfo recordInfo) throws Exception {
        }

        public void onReadDeleteRecord(long recordID) throws Exception {
        }

        public void onReadCommitRecord(long transactionID, int numberOfRecords) throws Exception {
        }

        public void markAsDataFile(JournalFile file0) {
        }
    }

    public static interface RunnerWithEX {
        public void run() throws Throwable;
    }
}

