/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.security.Principal;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.activemq.transport.amqp.client.util.IOExceptionSupport;
import org.apache.activemq.transport.netty.NettyTransport;
import org.apache.activemq.transport.netty.NettyTransportListener;
import org.apache.activemq.transport.netty.NettyTransportOptions;
import org.apache.activemq.transport.netty.NettyTransportSslOptions;
import org.apache.activemq.transport.netty.NettyTransportSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyTcpTransport
implements NettyTransport {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int SHUTDOWN_TIMEOUT = 100;
    public static final int DEFAULT_MAX_FRAME_SIZE = 65535;
    protected Bootstrap bootstrap;
    protected EventLoopGroup group;
    protected Channel channel;
    protected NettyTransportListener listener;
    protected final NettyTransportOptions options;
    protected final URI remote;
    protected int maxFrameSize = 65535;
    private final AtomicBoolean connected = new AtomicBoolean();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final CountDownLatch connectLatch = new CountDownLatch(1);
    private volatile IOException failureCause;

    public NettyTcpTransport(URI remoteLocation, NettyTransportOptions options) {
        this(null, remoteLocation, options);
    }

    public NettyTcpTransport(NettyTransportListener listener, URI remoteLocation, NettyTransportOptions options) {
        if (options == null) {
            throw new IllegalArgumentException("Transport Options cannot be null");
        }
        if (remoteLocation == null) {
            throw new IllegalArgumentException("Transport remote location cannot be null");
        }
        this.options = options;
        this.listener = listener;
        this.remote = remoteLocation;
    }

    @Override
    public void connect() throws IOException {
        SslHandler sslHandler;
        if (this.listener == null) {
            throw new IllegalStateException("A transport listener must be set before connection attempts.");
        }
        if (this.isSSL()) {
            try {
                sslHandler = NettyTransportSupport.createSslHandler(this.getRemoteLocation(), this.getSslOptions());
            }
            catch (Exception ex) {
                throw IOExceptionSupport.create(ex);
            }
        } else {
            sslHandler = null;
        }
        this.group = new NioEventLoopGroup(1);
        this.bootstrap = new Bootstrap();
        this.bootstrap.group(this.group);
        this.bootstrap.channel(NioSocketChannel.class);
        this.bootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            public void initChannel(Channel connectedChannel) throws Exception {
                NettyTcpTransport.this.configureChannel(connectedChannel, sslHandler);
            }
        });
        this.configureNetty(this.bootstrap, this.getTransportOptions());
        ChannelFuture future = this.bootstrap.connect(this.getRemoteHost(), this.getRemotePort());
        future.addListener((GenericFutureListener)((ChannelFutureListener)future1 -> {
            if (!future1.isSuccess()) {
                this.handleException(future1.channel(), IOExceptionSupport.create(future1.cause()));
            }
        }));
        try {
            this.connectLatch.await();
        }
        catch (InterruptedException ex) {
            logger.debug("Transport connection was interrupted.");
            Thread.interrupted();
            this.failureCause = IOExceptionSupport.create(ex);
        }
        if (this.failureCause != null) {
            if (this.channel != null) {
                this.channel.close().syncUninterruptibly();
                this.channel = null;
            }
            if (this.group != null) {
                Future fut = this.group.shutdownGracefully(0L, 100L, TimeUnit.MILLISECONDS);
                if (!fut.awaitUninterruptibly(200L)) {
                    logger.trace("Channel group shutdown failed to complete in allotted time");
                }
                this.group = null;
            }
            throw this.failureCause;
        }
        this.channel.eventLoop().execute(() -> {
            if (this.failureCause != null) {
                this.channel.pipeline().fireExceptionCaught((Throwable)this.failureCause);
            }
        });
    }

    @Override
    public boolean isConnected() {
        return this.connected.get();
    }

    @Override
    public boolean isSSL() {
        return this.options.isSSL();
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.connected.set(false);
            try {
                if (this.channel != null) {
                    this.channel.close().syncUninterruptibly();
                }
            }
            finally {
                Future fut;
                if (this.group != null && !(fut = this.group.shutdownGracefully(0L, 100L, TimeUnit.MILLISECONDS)).awaitUninterruptibly(200L)) {
                    logger.trace("Channel group shutdown failed to complete in allotted time");
                }
            }
        }
    }

    @Override
    public ByteBuf allocateSendBuffer(int size) throws IOException {
        this.checkConnected();
        return this.channel.alloc().ioBuffer(size, size);
    }

    protected final ChannelFuture writeAndFlush(ByteBuf output, ChannelPromise promise, Function<? super ByteBuf, ? extends ReferenceCounted> bufferTransformer) throws IOException {
        try {
            this.checkConnected();
        }
        catch (IOException ioEx) {
            output.release();
            throw ioEx;
        }
        int length = output.readableBytes();
        if (length == 0) {
            output.release();
            return null;
        }
        logger.trace("Attempted write of: {} bytes", (Object)length);
        return this.channel.writeAndFlush((Object)bufferTransformer.apply((ByteBuf)output), promise);
    }

    @Override
    public ChannelFuture send(ByteBuf output) throws IOException {
        return this.writeAndFlush(output, this.channel.newPromise(), Function.identity());
    }

    @Override
    public void sendVoidPromise(ByteBuf output) throws IOException {
        this.writeAndFlush(output, this.channel.voidPromise(), Function.identity());
    }

    @Override
    public NettyTransportListener getTransportListener() {
        return this.listener;
    }

    @Override
    public void setTransportListener(NettyTransportListener listener) {
        this.listener = listener;
    }

    @Override
    public NettyTransportOptions getTransportOptions() {
        return this.options;
    }

    @Override
    public URI getRemoteLocation() {
        return this.remote;
    }

    @Override
    public Principal getLocalPrincipal() {
        Principal result = null;
        if (this.isSSL()) {
            SslHandler sslHandler = (SslHandler)this.channel.pipeline().get(SslHandler.class);
            result = sslHandler.engine().getSession().getLocalPrincipal();
        }
        return result;
    }

    @Override
    public void setMaxFrameSize(int maxFrameSize) {
        if (this.connected.get()) {
            throw new IllegalStateException("Cannot change Max Frame Size while connected.");
        }
        this.maxFrameSize = maxFrameSize;
    }

    @Override
    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    protected String getRemoteHost() {
        return this.remote.getHost();
    }

    protected int getRemotePort() {
        if (this.remote.getPort() != -1) {
            return this.remote.getPort();
        }
        return this.isSSL() ? this.getSslOptions().getDefaultSslPort() : this.getTransportOptions().getDefaultTcpPort();
    }

    protected void addAdditionalHandlers(ChannelPipeline pipeline) {
    }

    protected ChannelInboundHandlerAdapter createChannelHandler() {
        return new NettyTcpTransportHandler();
    }

    protected void handleConnected(Channel channel) throws Exception {
        logger.trace("Channel has become active! Channel is {}", (Object)channel);
        this.connectionEstablished(channel);
    }

    protected void handleChannelInactive(Channel channel) throws Exception {
        logger.trace("Channel has gone inactive! Channel is {}", (Object)channel);
        if (this.connected.compareAndSet(true, false) && !this.closed.get()) {
            logger.trace("Firing onTransportClosed listener");
            this.listener.onTransportClosed();
        }
    }

    protected void handleException(Channel channel, Throwable cause) throws Exception {
        logger.trace("Exception on channel! Channel is {}", (Object)channel);
        if (this.connected.compareAndSet(true, false) && !this.closed.get()) {
            logger.trace("Firing onTransportError listener");
            if (this.failureCause != null) {
                this.listener.onTransportError(this.failureCause);
            } else {
                this.listener.onTransportError(cause);
            }
        } else {
            if (this.failureCause == null) {
                logger.trace("Holding error until connect succeeds: {}", (Object)cause.getMessage());
                this.failureCause = IOExceptionSupport.create(cause);
            }
            this.connectionFailed(channel, this.failureCause);
        }
    }

    protected final void checkConnected() throws IOException {
        if (!this.connected.get()) {
            throw new IOException("Cannot send to a non-connected transport.");
        }
    }

    private void connectionEstablished(Channel connectedChannel) {
        this.channel = connectedChannel;
        this.connected.set(true);
        this.connectLatch.countDown();
    }

    private void connectionFailed(Channel failedChannel, IOException cause) {
        this.failureCause = cause;
        this.channel = failedChannel;
        this.connected.set(false);
        this.connectLatch.countDown();
    }

    private NettyTransportSslOptions getSslOptions() {
        return (NettyTransportSslOptions)this.getTransportOptions();
    }

    private void configureNetty(Bootstrap bootstrap, NettyTransportOptions options) {
        bootstrap.option(ChannelOption.TCP_NODELAY, (Object)options.isTcpNoDelay());
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)options.getConnectTimeout());
        bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)options.isTcpKeepAlive());
        bootstrap.option(ChannelOption.SO_LINGER, (Object)options.getSoLinger());
        if (options.getSendBufferSize() != -1) {
            bootstrap.option(ChannelOption.SO_SNDBUF, (Object)options.getSendBufferSize());
        }
        if (options.getReceiveBufferSize() != -1) {
            bootstrap.option(ChannelOption.SO_RCVBUF, (Object)options.getReceiveBufferSize());
            bootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new FixedRecvByteBufAllocator(options.getReceiveBufferSize()));
        }
        if (options.getTrafficClass() != -1) {
            bootstrap.option(ChannelOption.IP_TOS, (Object)options.getTrafficClass());
        }
    }

    private void configureChannel(Channel channel, SslHandler sslHandler) throws Exception {
        if (this.isSSL()) {
            channel.pipeline().addLast(new ChannelHandler[]{sslHandler});
        }
        if (this.getTransportOptions().isTraceBytes()) {
            channel.pipeline().addLast("logger", (ChannelHandler)new LoggingHandler(this.getClass()));
        }
        this.addAdditionalHandlers(channel.pipeline());
        channel.pipeline().addLast(new ChannelHandler[]{this.createChannelHandler()});
    }

    protected class NettyTcpTransportHandler
    extends NettyDefaultHandler<ByteBuf> {
        protected NettyTcpTransportHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, ByteBuf buffer) throws Exception {
            logger.trace("New data read: {} bytes incoming: {}", (Object)buffer.readableBytes(), (Object)buffer);
            NettyTcpTransport.this.listener.onData(buffer);
        }
    }

    protected abstract class NettyDefaultHandler<E>
    extends SimpleChannelInboundHandler<E> {
        protected NettyDefaultHandler() {
        }

        public void channelRegistered(ChannelHandlerContext context) throws Exception {
            NettyTcpTransport.this.channel = context.channel();
        }

        public void channelActive(ChannelHandlerContext context) throws Exception {
            if (!NettyTcpTransport.this.isSSL()) {
                NettyTcpTransport.this.handleConnected(context.channel());
            } else {
                SslHandler sslHandler = (SslHandler)context.pipeline().get(SslHandler.class);
                sslHandler.handshakeFuture().addListener(future -> {
                    if (future.isSuccess()) {
                        logger.trace("SSL Handshake has completed: {}", (Object)NettyTcpTransport.this.channel);
                        NettyTcpTransport.this.handleConnected(NettyTcpTransport.this.channel);
                    } else {
                        logger.trace("SSL Handshake has failed: {}", (Object)NettyTcpTransport.this.channel);
                        NettyTcpTransport.this.handleException(NettyTcpTransport.this.channel, future.cause());
                    }
                });
            }
        }

        public void channelInactive(ChannelHandlerContext context) throws Exception {
            NettyTcpTransport.this.handleChannelInactive(context.channel());
        }

        public void exceptionCaught(ChannelHandlerContext context, Throwable cause) throws Exception {
            NettyTcpTransport.this.handleException(context.channel(), cause);
        }
    }
}

