/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.naming;

import io.undertow.client.ClientRequest;
import io.undertow.util.Headers;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.naming.Name;
import org.wildfly.httpclient.common.HeadersHelper;
import org.wildfly.httpclient.common.Protocol;
import org.wildfly.httpclient.naming.Constants;
import org.wildfly.httpclient.naming.RequestType;

final class RequestBuilder {
    private RequestType requestType;
    private Name name;
    private Name newName;
    private Object object;
    private int version = Protocol.LATEST;

    RequestBuilder() {
    }

    RequestBuilder setRequestType(RequestType requestType) {
        this.requestType = requestType;
        return this;
    }

    RequestBuilder setName(Name name) {
        this.name = name;
        return this;
    }

    RequestBuilder setNewName(Name newName) {
        this.newName = newName;
        return this;
    }

    RequestBuilder setObject(Object object) {
        this.object = object;
        return this;
    }

    RequestBuilder setVersion(int version) {
        this.version = version;
        return this;
    }

    ClientRequest createRequest(String prefix) {
        ClientRequest request = new ClientRequest();
        this.setRequestMethod(request);
        this.setRequestPath(request, prefix);
        this.setRequestHeaders(request);
        return request;
    }

    private void setRequestMethod(ClientRequest request) {
        request.setMethod(this.requestType.getMethod());
    }

    private void setRequestPath(ClientRequest request, String prefix) {
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix);
        }
        RequestBuilder.appendPath(sb, "/naming", false);
        RequestBuilder.appendPath(sb, "/v" + this.version, false);
        RequestBuilder.appendPath(sb, this.requestType.getPath(), false);
        RequestBuilder.appendPath(sb, this.name.toString(), true);
        if (this.newName != null) {
            sb.append("?new=");
            sb.append(URLEncoder.encode(this.newName.toString(), StandardCharsets.UTF_8));
        }
        request.setPath(sb.toString());
    }

    private void setRequestHeaders(ClientRequest request) {
        HeadersHelper.putRequestHeader(request, Headers.ACCEPT, Constants.VALUE + "," + Constants.EXCEPTION);
        if (this.object != null) {
            HeadersHelper.putRequestHeader(request, Headers.CONTENT_TYPE, Constants.VALUE);
        }
    }

    private static void appendPath(StringBuilder sb, String path, boolean encode) {
        if (!path.startsWith("/")) {
            sb.append("/");
        }
        sb.append(encode ? URLEncoder.encode(path, StandardCharsets.UTF_8) : path);
    }
}

