/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.interceptor;

import jakarta.xml.ws.handler.Handler;
import jakarta.xml.ws.handler.LogicalMessageContext;
import jakarta.xml.ws.handler.MessageContext;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.List;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.jaxws.handler.HandlerChainInvoker;
import org.apache.cxf.jaxws.handler.logical.LogicalHandlerInInterceptor;
import org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.service.invoker.MethodDispatcher;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.jboss.wsf.spi.security.EJBMethodSecurityAttribute;
import org.jboss.wsf.spi.security.EJBMethodSecurityAttributeProvider;
import org.jboss.wsf.stack.cxf.JAXPDelegateClassLoader;
import org.jboss.wsf.stack.cxf.i18n.Messages;
import org.jboss.wsf.stack.cxf.interceptor.SecurityActions;

public class HandlerConfigInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final String KEY = HandlerConfigInterceptor.class.getName() + ".SECURITY_EXCEPTION";
    private final boolean skipAuth;

    public HandlerConfigInterceptor() {
        super("pre-protocol-frontend");
        this.addBefore(SOAPHandlerInterceptor.class.getName());
        this.addBefore(LogicalHandlerInInterceptor.class.getName());
        this.skipAuth = false;
    }

    public HandlerConfigInterceptor(boolean skipAuth) {
        super("pre-protocol-frontend");
        this.addBefore(SOAPHandlerInterceptor.class.getName());
        this.addBefore(LogicalHandlerInInterceptor.class.getName());
        this.skipAuth = skipAuth;
    }

    public void handleMessage(Message message) throws Fault {
        JaxWsEndpointImpl ep;
        List handlerChain;
        Endpoint endpoint;
        Exchange ex = message.getExchange();
        HandlerChainInvoker invoker = (HandlerChainInvoker)ex.get(HandlerChainInvoker.class);
        if (null == invoker && (endpoint = ex.getEndpoint()) instanceof JaxWsEndpointImpl && (handlerChain = (ep = (JaxWsEndpointImpl)endpoint).getJaxwsBinding().getHandlerChain()) != null && !handlerChain.isEmpty()) {
            invoker = new JBossWSHandlerChainInvoker(handlerChain, this.isOutbound(message, ex), this.skipAuth);
            ex.put(HandlerChainInvoker.class, (Object)invoker);
        }
    }

    private boolean isOutbound(Message message, Exchange ex) {
        return message == ex.getOutMessage() || message == ex.getOutFaultMessage();
    }

    private static class JBossWSHandlerChainInvoker
    extends HandlerChainInvoker {
        private final boolean skip;

        public JBossWSHandlerChainInvoker(List<Handler> hc, boolean isOutbound) {
            super(hc, isOutbound);
            this.skip = false;
        }

        public JBossWSHandlerChainInvoker(List<Handler> hc, boolean isOutbound, boolean skipAuth) {
            super(hc, isOutbound);
            this.skip = skipAuth;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean invokeLogicalHandlers(boolean requestor, LogicalMessageContext context) {
            if (!this.skip) {
                this.checkAuthorization((MessageContext)context);
            }
            ClassLoader original = SecurityActions.getContextClassLoader();
            try {
                if (original instanceof JAXPDelegateClassLoader) {
                    JAXPDelegateClassLoader jaxpLoader = (JAXPDelegateClassLoader)((Object)original);
                    SecurityActions.setContextClassLoader(jaxpLoader.getDelegate());
                }
                boolean bl = super.invokeLogicalHandlers(requestor, context);
                return bl;
            }
            finally {
                SecurityActions.setContextClassLoader(original);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean invokeProtocolHandlers(boolean requestor, MessageContext context) {
            if (!this.skip) {
                this.checkAuthorization(context);
            }
            ClassLoader original = SecurityActions.getContextClassLoader();
            try {
                if (original instanceof JAXPDelegateClassLoader) {
                    JAXPDelegateClassLoader jaxpLoader = (JAXPDelegateClassLoader)((Object)original);
                    SecurityActions.setContextClassLoader(jaxpLoader.getDelegate());
                }
                boolean bl = super.invokeProtocolHandlers(requestor, context);
                return bl;
            }
            finally {
                SecurityActions.setContextClassLoader(original);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean invokeLogicalHandlersHandleFault(boolean requestor, LogicalMessageContext context) {
            if (!this.skip && context.containsKey((Object)KEY)) {
                return true;
            }
            ClassLoader original = SecurityActions.getContextClassLoader();
            try {
                if (original instanceof JAXPDelegateClassLoader) {
                    JAXPDelegateClassLoader jaxpLoader = (JAXPDelegateClassLoader)((Object)original);
                    SecurityActions.setContextClassLoader(jaxpLoader.getDelegate());
                }
                boolean bl = super.invokeLogicalHandlersHandleFault(requestor, context);
                return bl;
            }
            finally {
                SecurityActions.setContextClassLoader(original);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean invokeProtocolHandlersHandleFault(boolean requestor, MessageContext context) {
            if (!this.skip && context.containsKey((Object)KEY)) {
                return true;
            }
            ClassLoader original = SecurityActions.getContextClassLoader();
            try {
                if (original instanceof JAXPDelegateClassLoader) {
                    JAXPDelegateClassLoader jaxpLoader = (JAXPDelegateClassLoader)((Object)original);
                    SecurityActions.setContextClassLoader(jaxpLoader.getDelegate());
                }
                boolean bl = super.invokeProtocolHandlersHandleFault(requestor, context);
                return bl;
            }
            finally {
                SecurityActions.setContextClassLoader(original);
            }
        }

        protected void checkAuthorization(MessageContext ctx) {
            if (((Boolean)ctx.get((Object)"jakarta.xml.ws.handler.message.outbound")).booleanValue()) {
                return;
            }
            Message message = ((WrappedMessageContext)ctx).getWrappedMessage();
            Exchange exchange = message.getExchange();
            org.jboss.wsf.spi.deployment.Endpoint ep = (org.jboss.wsf.spi.deployment.Endpoint)exchange.get(org.jboss.wsf.spi.deployment.Endpoint.class);
            EJBMethodSecurityAttributeProvider attributeProvider = (EJBMethodSecurityAttributeProvider)ep.getAttachment(EJBMethodSecurityAttributeProvider.class);
            if (attributeProvider != null) {
                SecurityContext secCtx = (SecurityContext)message.get(SecurityContext.class);
                BindingOperationInfo bop = exchange.getBindingOperationInfo();
                if (bop == null) {
                    throw Messages.MESSAGES.missingBindingOperationForAuthorization();
                }
                MethodDispatcher md = (MethodDispatcher)exchange.getService().get((Object)MethodDispatcher.class.getName());
                Method method = md.getMethod(bop);
                EJBMethodSecurityAttribute attributes = attributeProvider.getSecurityAttributes(method);
                if (attributes == null || attributes.isPermitAll()) {
                    return;
                }
                if (!attributes.isDenyAll() && attributes.getRolesAllowed() != null) {
                    for (String role : attributes.getRolesAllowed()) {
                        if (!secCtx.isUserInRole(role)) continue;
                        return;
                    }
                }
                Principal p = secCtx.getUserPrincipal();
                ctx.put((Object)KEY, (Object)true);
                throw Messages.MESSAGES.authorizationFailed(p != null ? p.getName() : null);
            }
        }
    }
}

