/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.embedded;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.wildfly.clustering.cache.Key;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.context.DefaultThreadFactory;
import org.wildfly.clustering.server.expiration.ExpirationMetaData;
import org.wildfly.clustering.server.infinispan.scheduler.AbstractCacheEntryScheduler;
import org.wildfly.clustering.server.local.scheduler.LocalScheduler;
import org.wildfly.clustering.server.local.scheduler.LocalSchedulerConfiguration;
import org.wildfly.clustering.server.scheduler.Scheduler;
import org.wildfly.clustering.session.ImmutableSessionMetaData;
import org.wildfly.clustering.session.cache.metadata.ImmutableSessionMetaDataFactory;

public class SessionExpirationScheduler<K extends Key<String>, V>
extends AbstractCacheEntryScheduler<String, K, V, ExpirationMetaData> {
    private static final Logger LOGGER = Logger.getLogger(SessionExpirationScheduler.class);
    private static final ThreadFactory THREAD_FACTORY = new DefaultThreadFactory(SessionExpirationScheduler.class, AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

        @Override
        public ClassLoader run() {
            return SessionExpirationScheduler.class.getClassLoader();
        }
    }));
    private final ImmutableSessionMetaDataFactory<V> metaDataFactory;

    public SessionExpirationScheduler(final String name, final Supplier<Batch> batchFactory, ImmutableSessionMetaDataFactory<V> metaDataFactory, final Predicate<String> remover, final Duration closeTimeout) {
        this(new LocalSchedulerConfiguration<String>(){

            public String getName() {
                return name;
            }

            public Predicate<String> getTask() {
                return new SessionRemoveTask(batchFactory, remover);
            }

            public Duration getCloseTimeout() {
                return closeTimeout;
            }

            public ThreadFactory getThreadFactory() {
                return THREAD_FACTORY;
            }
        }, metaDataFactory);
    }

    public SessionExpirationScheduler(LocalSchedulerConfiguration<String> config, ImmutableSessionMetaDataFactory<V> metaDataFactory) {
        this((Scheduler<String, Instant>)new LocalScheduler(config), metaDataFactory);
    }

    public SessionExpirationScheduler(Scheduler<String, Instant> scheduler, ImmutableSessionMetaDataFactory<V> metaDataFactory) {
        super(scheduler.map(ExpirationMetaData::getExpirationTime));
        this.metaDataFactory = metaDataFactory;
    }

    public void schedule(String id) {
        Object value = this.metaDataFactory.findValue((Object)id);
        if (value != null) {
            this.schedule(id, value);
        }
    }

    public void schedule(Map.Entry<K, V> entry) {
        this.schedule((String)((Key)entry.getKey()).getId(), entry.getValue());
    }

    private void schedule(String id, V value) {
        ImmutableSessionMetaData metaData = this.metaDataFactory.createImmutableSessionMetaData(id, value);
        if (!metaData.isImmortal()) {
            this.schedule(id, metaData);
        }
    }

    private static class SessionRemoveTask
    implements Predicate<String> {
        private final Supplier<Batch> batchFactory;
        private final Predicate<String> remover;

        SessionRemoveTask(Supplier<Batch> batchFactory, Predicate<String> remover) {
            this.batchFactory = batchFactory;
            this.remover = remover;
        }

        @Override
        public boolean test(String id) {
            boolean bl;
            block10: {
                LOGGER.debugf("Expiring session %s", (Object)id);
                Batch batch = this.batchFactory.get();
                try {
                    bl = this.remover.test(id);
                    if (batch == null) break block10;
                }
                catch (RuntimeException e) {
                    try {
                        try {
                            batch.discard();
                            throw e;
                        }
                        catch (Throwable throwable) {
                            if (batch != null) {
                                try {
                                    batch.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                    catch (RuntimeException e2) {
                        LOGGER.warnf((Throwable)e2, id.toString(), new Object[0]);
                        return false;
                    }
                }
                batch.close();
            }
            return bl;
        }
    }
}

