/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.inject.spi.CDIProvider;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.as.weld.deployment.WeldDeployment;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.as.weld.services.ModuleGroupSingletonProvider;
import org.jboss.as.weld.util.Reflections;
import org.jboss.weld.AbstractCDI;
import org.jboss.weld.Container;
import org.jboss.weld.ContainerState;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.logging.BeanManagerLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.wildfly.security.manager.WildFlySecurityManager;

public class WeldProvider
implements CDIProvider {
    private static final ConcurrentMap<Container, CdiImpl> containers = new ConcurrentHashMap<Container, CdiImpl>();

    static void containerInitialized(Container container, BeanManagerImpl rootBeanManager, WeldDeployment deployment) {
        containers.put(container, new CdiImpl(container, new BeanManagerProxy(rootBeanManager), deployment));
    }

    static void containerShutDown(Container container) {
        containers.remove(container);
    }

    public CDI<Object> getCDI() {
        if (ModuleGroupSingletonProvider.deploymentClassLoaders.isEmpty()) {
            throw WeldLogger.ROOT_LOGGER.weldNotInitialized();
        }
        Container container = Container.instance();
        WeldProvider.checkContainerState(container);
        return (CDI)containers.get(container);
    }

    private static void checkContainerState(Container container) {
        ContainerState state = container.getState();
        if (state.equals((Object)ContainerState.STOPPED) || state.equals((Object)ContainerState.SHUTDOWN)) {
            throw BeanManagerLogger.LOG.beanManagerNotAvailable();
        }
    }

    private static class CdiImpl
    extends AbstractCDI<Object> {
        private final Container container;
        private final BeanManagerProxy rootBeanManager;
        private final WeldDeployment deployment;

        public CdiImpl(Container container, BeanManagerProxy rootBeanManager, WeldDeployment deployment) {
            this.container = container;
            this.rootBeanManager = rootBeanManager;
            this.deployment = deployment;
        }

        public BeanManager getBeanManager() {
            BeanDeploymentArchive bda;
            ClassLoader tccl;
            Class callerClass;
            WeldProvider.checkContainerState(this.container);
            String callerName = this.getCallingClassName();
            if (callerName.startsWith("org.glassfish.soteria") || callerName.startsWith("org.eclipse.krazo")) {
                try {
                    BeanManager bm = (BeanManager)new InitialContext().lookup("java:comp/BeanManager");
                    if (bm != null) {
                        return bm;
                    }
                }
                catch (NamingException bm) {
                    // empty catch block
                }
            }
            if ((callerClass = Reflections.loadClass((String)callerName, (ClassLoader)(tccl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged()))) != null && (bda = this.deployment.getBeanDeploymentArchive(callerClass)) != null) {
                return new BeanManagerProxy((BeanManagerImpl)this.container.beanDeploymentArchives().get(bda));
            }
            return this.rootBeanManager;
        }

        public String toString() {
            return "Weld instance for deployment " + BeanManagerProxy.unwrap((BeanManager)this.rootBeanManager).getContextId();
        }
    }
}

