/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.singleton;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Consumer;
import org.jboss.as.clustering.controller.DeploymentChainContributingResourceRegistrar;
import org.jboss.as.clustering.controller.ManagementResourceRegistration;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SubsystemRegistration;
import org.jboss.as.clustering.controller.SubsystemResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.ServiceNameFactory;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.jbossallxml.JBossAllSchema;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.clustering.singleton.SingletonPolicy;
import org.wildfly.clustering.singleton.service.ServiceTargetFactory;
import org.wildfly.extension.clustering.singleton.SingletonExtension;
import org.wildfly.extension.clustering.singleton.SingletonPolicyResourceDefinition;
import org.wildfly.extension.clustering.singleton.deployment.SingletonDeploymentDependencyProcessor;
import org.wildfly.extension.clustering.singleton.deployment.SingletonDeploymentParsingProcessor;
import org.wildfly.extension.clustering.singleton.deployment.SingletonDeploymentProcessor;
import org.wildfly.extension.clustering.singleton.deployment.SingletonDeploymentSchema;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.capability.CapabilityReferenceRecorder;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public class SingletonResourceDefinition
extends SubsystemResourceDefinition
implements ResourceServiceConfigurator,
Consumer<DeploymentProcessorTarget> {
    static final PathElement PATH = SingletonResourceDefinition.pathElement((String)"singleton");
    private static final RuntimeCapability<Void> DEFAULT_SERVICE_TARGET_FACTORY = RuntimeCapability.Builder.of((NullaryServiceDescriptor)ServiceTargetFactory.DEFAULT_SERVICE_DESCRIPTOR).build();

    SingletonResourceDefinition() {
        super(PATH, (ResourceDescriptionResolver)SingletonExtension.SUBSYSTEM_RESOLVER);
    }

    public void register(SubsystemRegistration parentRegistration) {
        ManagementResourceRegistration registration = parentRegistration.registerSubsystemModel((ResourceDefinition)this);
        registration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        ResourceDescriptor descriptor = new ResourceDescriptor(this.getResourceDescriptionResolver()).addAttributes(Attribute.class).addCapabilities(List.of(DEFAULT_SERVICE_TARGET_FACTORY));
        ResourceOperationRuntimeHandler handler = ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this);
        new DeploymentChainContributingResourceRegistrar(descriptor, ResourceServiceHandler.of((ResourceOperationRuntimeHandler[])new ResourceOperationRuntimeHandler[]{handler}), (Consumer)this).register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        new SingletonPolicyResourceDefinition().register(registration);
    }

    @Override
    public void accept(DeploymentProcessorTarget target) {
        target.addDeploymentProcessor("singleton", Phase.STRUCTURE, 2588, JBossAllSchema.createDeploymentUnitProcessor(EnumSet.allOf(SingletonDeploymentSchema.class), SingletonDeploymentDependencyProcessor.CONFIGURATION_KEY));
        target.addDeploymentProcessor("singleton", Phase.PARSE, 19200, (DeploymentUnitProcessor)new SingletonDeploymentParsingProcessor());
        target.addDeploymentProcessor("singleton", Phase.DEPENDENCIES, 8960, (DeploymentUnitProcessor)new SingletonDeploymentDependencyProcessor());
        target.addDeploymentProcessor("singleton", Phase.CONFIGURE_MODULE, 1024, (DeploymentUnitProcessor)new SingletonDeploymentProcessor());
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        String defaultPolicy = Attribute.DEFAULT.resolveModelAttribute((ExpressionResolver)context, model).asString();
        return (ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder(DEFAULT_SERVICE_TARGET_FACTORY, (ServiceDependency)ServiceDependency.on((UnaryServiceDescriptor)ServiceTargetFactory.SERVICE_DESCRIPTOR, (String)defaultPolicy)).provides(ServiceNameFactory.resolveServiceName((NullaryServiceDescriptor)org.wildfly.clustering.singleton.service.SingletonPolicy.DEFAULT_SERVICE_DESCRIPTOR))).provides(ServiceNameFactory.resolveServiceName((NullaryServiceDescriptor)SingletonPolicy.DEFAULT_SERVICE_DESCRIPTOR))).build();
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute
    {
        DEFAULT("default", ModelType.STRING, CapabilityReferenceRecorder.builder(DEFAULT_SERVICE_TARGET_FACTORY, (UnaryServiceDescriptor)ServiceTargetFactory.SERVICE_DESCRIPTOR).build());

        private final SimpleAttributeDefinition definition;

        private Attribute(String name, ModelType type, CapabilityReferenceRecorder<?> reference) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setCapabilityReference(reference)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public SimpleAttributeDefinition getDefinition() {
            return this.definition;
        }
    }
}

