/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.cache;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.wildfly.clustering.server.cache.Cache;
import org.wildfly.clustering.server.cache.CacheFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum CacheStrategy implements CacheFactory
{
    NONE{

        @Override
        public <K, V> Cache<K, V> createCache(final Consumer<V> startTask, final Consumer<V> stopTask) {
            return new Cache<K, V>(){

                @Override
                public V computeIfAbsent(K key, BiFunction<K, Runnable, V> factory) {
                    AtomicReference reference = new AtomicReference();
                    Object value = factory.apply(key, () -> Optional.ofNullable(reference.getPlain()).ifPresent(stopTask::accept));
                    if (value != null) {
                        startTask.accept(value);
                        reference.setPlain(value);
                    }
                    return value;
                }
            };
        }
    }
    ,
    CONCURRENT{

        @Override
        public <K, V> Cache<K, V> createCache(final Consumer<V> startTask, final Consumer<V> stopTask) {
            final AddIfAbsentFunction addMutexFunction = new AddIfAbsentFunction(Object::new);
            final RemoveIfPresentFunction removeMutexFunction = new RemoveIfPresentFunction();
            final AddIfAbsentFunction addReferenceFunction = new AddIfAbsentFunction(AtomicReference::new);
            final RemoveIfPresentFunction removeReferenceFunction = new RemoveIfPresentFunction();
            return new Cache<K, V>(){
                private final Map<K, Map.Entry<Integer, Object>> mutexes = new ConcurrentHashMap();
                private final Map<K, Map.Entry<Integer, AtomicReference<V>>> references = new ConcurrentHashMap();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public V computeIfAbsent(K key, BiFunction<K, Runnable, V> factory) {
                    Object mutex = this.mutexes.compute(key, addMutexFunction).getValue();
                    AtomicReference reference = this.references.compute(key, addReferenceFunction).getValue();
                    Object result = reference.get();
                    if (result == null) {
                        Object object = mutex;
                        synchronized (object) {
                            result = reference.get();
                            if (result == null) {
                                Runnable closeTask = () -> {
                                    if (this.references.compute(key, removeReferenceFunction) == null) {
                                        Object object = mutex;
                                        synchronized (object) {
                                            Object value = reference.get();
                                            if (value != null) {
                                                stopTask.accept(value);
                                            }
                                        }
                                    }
                                    this.mutexes.compute(key, removeMutexFunction);
                                };
                                result = factory.apply(key, closeTask);
                                if (result != null) {
                                    startTask.accept(result);
                                    reference.set(result);
                                } else {
                                    closeTask.run();
                                }
                            }
                        }
                    }
                    return result;
                }
            };
        }
    };


    private static class RemoveIfPresentFunction<K, V>
    implements BiFunction<K, Map.Entry<Integer, V>, Map.Entry<Integer, V>> {
        private RemoveIfPresentFunction() {
        }

        @Override
        public Map.Entry<Integer, V> apply(K id, Map.Entry<Integer, V> entry) {
            int count = entry != null ? entry.getKey() : 0;
            return count > 0 ? Map.entry(count - 1, entry.getValue()) : null;
        }
    }

    private static class AddIfAbsentFunction<K, V>
    implements BiFunction<K, Map.Entry<Integer, V>, Map.Entry<Integer, V>> {
        private Supplier<V> factory;

        AddIfAbsentFunction(Supplier<V> factory) {
            this.factory = factory;
        }

        @Override
        public Map.Entry<Integer, V> apply(K id, Map.Entry<Integer, V> entry) {
            return entry != null ? Map.entry(entry.getKey() + 1, entry.getValue()) : Map.entry(0, this.factory.get());
        }
    }
}

