/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.naming;

import java.util.LinkedList;
import java.util.List;
import org.jboss.as.controller.RequirementServiceTarget;
import org.jboss.as.naming.ManagedReferenceInjector;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.subsystem.service.ServiceInstaller;

public class BinderServiceInstaller
implements ServiceInstaller {
    private final ContextNames.BindInfo binding;
    private final ServiceName targetServiceName;
    private final List<ContextNames.BindInfo> aliases = new LinkedList<ContextNames.BindInfo>();

    public BinderServiceInstaller(ContextNames.BindInfo binding, ServiceName targetServiceName) {
        this.binding = binding;
        this.targetServiceName = targetServiceName;
    }

    public BinderServiceInstaller withAlias(ContextNames.BindInfo alias) {
        this.aliases.add(alias);
        return this;
    }

    public ServiceController<?> install(RequirementServiceTarget target) {
        String name = this.binding.getBindName();
        BinderService binder = new BinderService(name);
        ServiceBuilder builder = target.addService(this.binding.getBinderServiceName(), (Service)binder).addAliases(new ServiceName[]{ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{name})}).addDependency(this.targetServiceName, Object.class, (Injector)new ManagedReferenceInjector((Injector)binder.getManagedObjectInjector())).addDependency(this.binding.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)binder.getNamingStoreInjector());
        for (ContextNames.BindInfo alias : this.aliases) {
            builder.addAliases(new ServiceName[]{alias.getBinderServiceName(), ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{alias.getBindName()})});
        }
        return builder.setInitialMode(ServiceController.Mode.PASSIVE).install();
    }
}

