/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.hornetq.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.core.Packet;

public class HQPropertiesConverter {
    private static Map<SimpleString, SimpleString> hqAmqDictionary;
    private static Map<SimpleString, SimpleString> amqHqDictionary;

    public static void replaceAMQProperties(Message message) {
        HQPropertiesConverter.replaceDict(message, amqHqDictionary);
    }

    public static void replaceHQProperties(Message message) {
        HQPropertiesConverter.replaceDict(message, hqAmqDictionary);
    }

    private static void replaceDict(Message message, Map<SimpleString, SimpleString> dictionary) {
        for (SimpleString property : new HashSet(message.getPropertyNames())) {
            SimpleString replaceTo = dictionary.get(property);
            if (replaceTo == null) continue;
            message.putObjectProperty(replaceTo, message.removeProperty(property));
        }
    }

    public static boolean isMessagePacket(Packet packet) {
        byte type = packet.getType();
        return type == 71 || type == 72 || type == 76 || type == 75;
    }

    static {
        HashMap<SimpleString, SimpleString> d = new HashMap<SimpleString, SimpleString>();
        d.put(SimpleString.of((String)"_HQ_ACTUAL_EXPIRY"), SimpleString.of((String)"_AMQ_ACTUAL_EXPIRY"));
        d.put(SimpleString.of((String)"_HQ_ORIG_ADDRESS"), SimpleString.of((String)"_AMQ_ORIG_ADDRESS"));
        d.put(SimpleString.of((String)"_HQ_ORIG_QUEUE"), SimpleString.of((String)"_AMQ_ORIG_QUEUE"));
        d.put(SimpleString.of((String)"_HQ_ORIG_MESSAGE_ID"), SimpleString.of((String)"_AMQ_ORIG_MESSAGE_ID"));
        d.put(SimpleString.of((String)"_HQ_GROUP_ID"), SimpleString.of((String)"_AMQ_GROUP_ID"));
        d.put(SimpleString.of((String)"_HQ_LARGE_COMPRESSED"), SimpleString.of((String)"_AMQ_LARGE_COMPRESSED"));
        d.put(SimpleString.of((String)"_HQ_LARGE_SIZE"), SimpleString.of((String)"_AMQ_LARGE_SIZE"));
        d.put(SimpleString.of((String)"_HQ_SCHED_DELIVERY"), SimpleString.of((String)"_AMQ_SCHED_DELIVERY"));
        d.put(SimpleString.of((String)"_HQ_DUPL_ID"), SimpleString.of((String)"_AMQ_DUPL_ID"));
        d.put(SimpleString.of((String)"_HQ_LVQ_NAME"), SimpleString.of((String)"_AMQ_LVQ_NAME"));
        hqAmqDictionary = Collections.unmodifiableMap(d);
        d = new HashMap();
        for (Map.Entry<SimpleString, SimpleString> entry : hqAmqDictionary.entrySet()) {
            d.put(entry.getValue(), entry.getKey());
        }
        amqHqDictionary = Collections.unmodifiableMap(d);
    }
}

