/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.unstable.api.annotation.classpath.index;

import java.util.HashSet;
import java.util.Set;
import org.wildfly.unstable.api.annotation.classpath.index.AnnotatedConstructor;
import org.wildfly.unstable.api.annotation.classpath.index.AnnotatedField;
import org.wildfly.unstable.api.annotation.classpath.index.AnnotatedMethod;
import org.wildfly.unstable.api.annotation.classpath.index.AnnotationIndex;

public class JarAnnotationIndex
extends AnnotationIndex {
    private JarAnnotationIndex(ResultBuilder builder) {
        super(builder.annotationName, builder.annotatedInterfaces, builder.annotatedClasses, builder.annotatedAnnotations, builder.annotatedMethods, builder.annotatedConstructors, builder.annotatedFields);
    }

    static ResultBuilder builder(String annotationName) {
        return new ResultBuilder(annotationName);
    }

    static class ResultBuilder {
        private final String annotationName;
        private final Set<String> annotatedInterfaces = new HashSet<String>();
        private final Set<String> annotatedClasses = new HashSet<String>();
        private final Set<String> annotatedAnnotations = new HashSet<String>();
        private final Set<AnnotatedMethod> annotatedMethods = new HashSet<AnnotatedMethod>();
        private final Set<AnnotatedConstructor> annotatedConstructors = new HashSet<AnnotatedConstructor>();
        private final Set<AnnotatedField> annotatedFields = new HashSet<AnnotatedField>();

        public ResultBuilder(String annotationName) {
            this.annotationName = annotationName;
        }

        ResultBuilder addAnnotatedInterface(String name) {
            this.annotatedInterfaces.add(name);
            return this;
        }

        ResultBuilder addAnnotatedClass(String name) {
            this.annotatedClasses.add(name);
            return this;
        }

        ResultBuilder addAnnotatedAnnotation(String name) {
            this.annotatedAnnotations.add(name);
            return this;
        }

        ResultBuilder addAnnotatedMethod(AnnotatedMethod method) {
            this.annotatedMethods.add(method);
            return this;
        }

        public ResultBuilder addAnnotatedConstructor(AnnotatedConstructor constructor) {
            this.annotatedConstructors.add(constructor);
            return this;
        }

        ResultBuilder addAnnotatedField(AnnotatedField field) {
            this.annotatedFields.add(field);
            return this;
        }

        JarAnnotationIndex build() {
            return new JarAnnotationIndex(this);
        }
    }
}

