/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem.remote;

import java.util.TreeMap;
import java.util.function.Consumer;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemModel;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteCacheContainerResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;

public class RemoteCacheContainerResourceTransformer
implements Consumer<ModelVersion> {
    private final ResourceTransformationDescriptionBuilder builder;

    public RemoteCacheContainerResourceTransformer(ResourceTransformationDescriptionBuilder parent) {
        this.builder = parent.addChildResource(RemoteCacheContainerResourceDefinition.WILDCARD_PATH);
    }

    @Override
    public void accept(ModelVersion version) {
        final TreeMap<String, String> legacyModules = new TreeMap<String, String>();
        if (InfinispanSubsystemModel.VERSION_20_0_0.requiresTransformation(version)) {
            ((AttributeTransformationDescriptionBuilder)this.builder.getAttributeBuilder().setValueConverter(AttributeConverter.DEFAULT_VALUE, new AttributeDefinition[]{RemoteCacheContainerResourceDefinition.Attribute.PROTOCOL_VERSION.getDefinition()})).end();
        }
        if (InfinispanSubsystemModel.VERSION_18_0_0.requiresTransformation(version)) {
            legacyModules.put("org.wildfly.clustering.session.infinispan.remote", "org.wildfly.clustering.web.hotrod");
        }
        if (InfinispanSubsystemModel.VERSION_15_0_0.requiresTransformation(version)) {
            ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)this.builder.getAttributeBuilder().setDiscard(DiscardAttributeChecker.ALWAYS, new AttributeDefinition[]{RemoteCacheContainerResourceDefinition.Attribute.TRANSACTION_TIMEOUT.getDefinition()})).setDiscard(DiscardAttributeChecker.DEFAULT_VALUE, new AttributeDefinition[]{RemoteCacheContainerResourceDefinition.Attribute.MARSHALLER.getDefinition()})).addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.SimpleAcceptAttributeChecker(RemoteCacheContainerResourceDefinition.Attribute.MARSHALLER.getDefinition().getDefaultValue()), new AttributeDefinition[]{RemoteCacheContainerResourceDefinition.Attribute.MARSHALLER.getDefinition()})).end();
        }
        if (!legacyModules.isEmpty()) {
            ((AttributeTransformationDescriptionBuilder)this.builder.getAttributeBuilder().setValueConverter((AttributeConverter)new AttributeConverter.DefaultAttributeConverter(){

                protected void convertAttribute(PathAddress address, String name, ModelNode modules, TransformationContext context) {
                    if (modules.isDefined()) {
                        for (ModelNode module : modules.asList()) {
                            String legacyModule = (String)legacyModules.get(module.asString());
                            if (legacyModule == null) continue;
                            module.set(legacyModule);
                        }
                    }
                }
            }, new AttributeDefinition[]{RemoteCacheContainerResourceDefinition.ListAttribute.MODULES.getDefinition()})).end();
        }
    }
}

