/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.DistributedLockManagerConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicaPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicatedPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationPrimaryPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStorePrimaryPolicyConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.lockmanager.file.FileBasedLockManager;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.apache.activemq.artemis.tests.integration.cluster.util.SameProcessActiveMQServer;
import org.apache.activemq.artemis.tests.integration.cluster.util.TestableServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.TransportConfigurationUtils;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.BeforeEach;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MultipleServerFailoverTestBase
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private DistributedLockManagerConfiguration pluggableQuorumConfiguration = null;
    protected static final SimpleString ADDRESS = SimpleString.of((String)"jms.FailoverTestAddress");
    protected List<TestableServer> primaryServers = new ArrayList<TestableServer>();
    protected List<TestableServer> backupServers = new ArrayList<TestableServer>();
    protected List<Configuration> backupConfigs = new ArrayList<Configuration>();
    protected List<Configuration> primaryConfigs = new ArrayList<Configuration>();
    protected List<NodeManager> nodeManagers;

    private DistributedLockManagerConfiguration getOrCreatePluggableQuorumConfiguration() {
        if (this.pluggableQuorumConfiguration != null) {
            return this.pluggableQuorumConfiguration;
        }
        try {
            this.pluggableQuorumConfiguration = new DistributedLockManagerConfiguration(FileBasedLockManager.class.getName(), Collections.singletonMap("locks-folder", MultipleServerFailoverTestBase.newFolder(this.temporaryFolder, "manager").toString()));
        }
        catch (IOException ioException) {
            return null;
        }
        return this.pluggableQuorumConfiguration;
    }

    public abstract int getPrimaryServerCount();

    public abstract int getBackupServerCount();

    public abstract boolean isNetty();

    public abstract HAType haType();

    protected final boolean isSharedStore() {
        return ClusterTestBase.HAType.SharedStore.equals((Object)this.haType());
    }

    public abstract String getNodeGroupName();

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        ActiveMQServer server;
        String[] input;
        TransportConfiguration staticTc;
        ArrayList<String> connectors;
        Configuration configuration;
        SharedStorePrimaryPolicyConfiguration haPolicyConfiguration;
        int i;
        super.setUp();
        this.primaryServers = new ArrayList<TestableServer>();
        this.backupServers = new ArrayList<TestableServer>();
        this.backupConfigs = new ArrayList<Configuration>();
        this.primaryConfigs = new ArrayList<Configuration>();
        for (i = 0; i < this.getPrimaryServerCount(); ++i) {
            haPolicyConfiguration = null;
            switch (this.haType()) {
                case SharedStore: {
                    haPolicyConfiguration = new SharedStorePrimaryPolicyConfiguration();
                    break;
                }
                case SharedNothingReplication: {
                    haPolicyConfiguration = new ReplicatedPolicyConfiguration();
                    if (this.getNodeGroupName() == null) break;
                    ((ReplicatedPolicyConfiguration)haPolicyConfiguration).setGroupName(this.getNodeGroupName() + "-" + i);
                    break;
                }
                case PluggableQuorumReplication: {
                    haPolicyConfiguration = ReplicationPrimaryPolicyConfiguration.withDefault().setDistributedManagerConfiguration(this.getOrCreatePluggableQuorumConfiguration()).setGroupName(this.getNodeGroupName() != null ? this.getNodeGroupName() + "-" + i : null);
                }
            }
            configuration = this.createDefaultConfig(this.isNetty()).clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(true, i)).setHAPolicyConfiguration((HAPolicyConfiguration)haPolicyConfiguration);
            if (!this.isSharedStore()) {
                configuration.setBindingsDirectory(this.getBindingsDir(i, false));
                configuration.setJournalDirectory(this.getJournalDir(i, false));
                configuration.setPagingDirectory(this.getPageDir(i, false));
                configuration.setLargeMessagesDirectory(this.getLargeMessagesDir(i, false));
            }
            TransportConfiguration livetc = this.getConnectorTransportConfiguration(true, i);
            configuration.addConnectorConfiguration(livetc.getName(), livetc);
            connectors = new ArrayList<String>();
            for (int j = 0; j < this.getPrimaryServerCount(); ++j) {
                if (j == i) continue;
                staticTc = this.getConnectorTransportConfiguration(true, j);
                configuration.getConnectorConfigurations().put(staticTc.getName(), staticTc);
                connectors.add(staticTc.getName());
            }
            input = new String[connectors.size()];
            connectors.toArray(input);
            configuration.addClusterConfiguration(MultipleServerFailoverTestBase.basicClusterConnectionConfig(livetc.getName(), input));
            this.primaryConfigs.add(configuration);
            server = this.createServer(true, configuration);
            SameProcessActiveMQServer activeMQServer = new SameProcessActiveMQServer(server);
            activeMQServer.setIdentity("Primary-" + i);
            this.primaryServers.add(activeMQServer);
        }
        for (i = 0; i < this.getBackupServerCount(); ++i) {
            int j;
            haPolicyConfiguration = null;
            switch (this.haType()) {
                case SharedStore: {
                    haPolicyConfiguration = new SharedStoreBackupPolicyConfiguration();
                    break;
                }
                case SharedNothingReplication: {
                    haPolicyConfiguration = new ReplicaPolicyConfiguration();
                    if (this.getNodeGroupName() == null) break;
                    ((ReplicaPolicyConfiguration)haPolicyConfiguration).setGroupName(this.getNodeGroupName() + "-" + i);
                    break;
                }
                case PluggableQuorumReplication: {
                    haPolicyConfiguration = ReplicationBackupPolicyConfiguration.withDefault().setDistributedManagerConfiguration(this.getOrCreatePluggableQuorumConfiguration()).setGroupName(this.getNodeGroupName() != null ? this.getNodeGroupName() + "-" + i : null);
                }
            }
            configuration = this.createDefaultConfig(this.isNetty()).clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(false, i)).setHAPolicyConfiguration((HAPolicyConfiguration)haPolicyConfiguration);
            if (!this.isSharedStore()) {
                configuration.setBindingsDirectory(this.getBindingsDir(i, true));
                configuration.setJournalDirectory(this.getJournalDir(i, true));
                configuration.setPagingDirectory(this.getPageDir(i, true));
                configuration.setLargeMessagesDirectory(this.getLargeMessagesDir(i, true));
            }
            TransportConfiguration backuptc = this.getConnectorTransportConfiguration(false, i);
            configuration.addConnectorConfiguration(backuptc.getName(), backuptc);
            connectors = new ArrayList();
            for (j = 0; j < this.getBackupServerCount(); ++j) {
                staticTc = this.getConnectorTransportConfiguration(true, j);
                configuration.addConnectorConfiguration(staticTc.getName(), staticTc);
                connectors.add(staticTc.getName());
            }
            for (j = 0; j < this.getBackupServerCount(); ++j) {
                if (j == i) continue;
                staticTc = this.getConnectorTransportConfiguration(false, j);
                configuration.getConnectorConfigurations().put(staticTc.getName(), staticTc);
                connectors.add(staticTc.getName());
            }
            input = new String[connectors.size()];
            connectors.toArray(input);
            configuration.addClusterConfiguration(MultipleServerFailoverTestBase.basicClusterConnectionConfig(backuptc.getName(), input));
            this.backupConfigs.add(configuration);
            server = this.createServer(true, configuration);
            SameProcessActiveMQServer testableServer = new SameProcessActiveMQServer(server);
            testableServer.setIdentity("Backup-" + i);
            this.backupServers.add(testableServer);
        }
    }

    protected TransportConfiguration getAcceptorTransportConfiguration(boolean live, int node) {
        TransportConfiguration transportConfiguration = this.isNetty() ? TransportConfigurationUtils.getNettyAcceptor(live, node, (live ? "live-" : "backup-") + node) : TransportConfigurationUtils.getInVMAcceptor(live, node, (live ? "live-" : "backup-") + node);
        return transportConfiguration;
    }

    protected TransportConfiguration getConnectorTransportConfiguration(boolean live, int node) {
        TransportConfiguration transportConfiguration = this.isNetty() ? TransportConfigurationUtils.getNettyConnector(live, node, (live ? "live-" : "backup-") + node) : TransportConfigurationUtils.getInVMConnector(live, node, (live ? "live-" : "backup-") + node);
        return transportConfiguration;
    }

    protected ServerLocatorInternal getServerLocator(int node) throws Exception {
        return (ServerLocatorInternal)this.addServerLocator(ActiveMQClient.createServerLocatorWithHA((TransportConfiguration[])new TransportConfiguration[]{this.getConnectorTransportConfiguration(true, node)})).setRetryInterval(100L).setReconnectAttempts(300).setInitialConnectAttempts(300);
    }

    protected ServerLocatorInternal getBackupServerLocator(int node) throws Exception {
        return (ServerLocatorInternal)this.addServerLocator(ActiveMQClient.createServerLocatorWithHA((TransportConfiguration[])new TransportConfiguration[]{this.getConnectorTransportConfiguration(false, node)})).setRetryInterval(100L).setReconnectAttempts(300).setInitialConnectAttempts(300);
    }

    protected ClientSession createSession(ClientSessionFactory sf, boolean autoCommitSends, boolean autoCommitAcks, int ackBatchSize) throws Exception {
        return this.addClientSession(sf.createSession(autoCommitSends, autoCommitAcks, ackBatchSize));
    }

    protected ClientSession createSession(ClientSessionFactory sf, boolean autoCommitSends, boolean autoCommitAcks) throws Exception {
        return this.addClientSession(sf.createSession(autoCommitSends, autoCommitAcks));
    }

    protected ClientSession createSession(ClientSessionFactory sf) throws Exception {
        return this.addClientSession(sf.createSession());
    }

    protected ClientSession createSession(ClientSessionFactory sf, boolean xa, boolean autoCommitSends, boolean autoCommitAcks) throws Exception {
        return this.addClientSession(sf.createSession(xa, autoCommitSends, autoCommitAcks));
    }

    protected boolean waitForDistribution(SimpleString address, ActiveMQServer server, int messageCount) throws Exception {
        logger.debug("waiting for distribution of messages on server {}", (Object)server);
        Queue q = (Queue)server.getPostOffice().getBinding(address).getBindable();
        return Wait.waitFor(() -> this.getMessageCount(q) >= messageCount);
    }

    private static File newFolder(File root, String subFolder) throws IOException {
        File result = new File(root, subFolder);
        if (!result.mkdirs()) {
            throw new IOException("Couldn't create folders " + root);
        }
        return result;
    }

    public static enum HAType {
        SharedStore,
        SharedNothingReplication,
        PluggableQuorumReplication;

    }
}

