/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorImpl;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicaPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicatedPolicyConfiguration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.config.impl.SecurityConfiguration;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.PagingStoreFactory;
import org.apache.activemq.artemis.core.paging.impl.PagingStoreFactoryNIO;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.spi.core.security.jaas.InVMLoginModule;
import org.apache.activemq.artemis.tests.integration.cluster.failover.DelayPagingStoreImpl;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.SpawnedVMSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PrimaryCrashOnBackupSyncTest
extends ActiveMQTestBase {
    static int OK = 2;
    public File primaryDir;
    public File backupDir;

    @BeforeEach
    public void setupDirectories() throws Exception {
        this.primaryDir = PrimaryCrashOnBackupSyncTest.newFolder(this.temporaryFolder, "primary");
        this.backupDir = PrimaryCrashOnBackupSyncTest.newFolder(this.temporaryFolder, "backup");
        this.primaryDir.mkdirs();
        this.backupDir.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void primaryCrashOnBackupSyncLargeMessageTest() throws Exception {
        Process process = SpawnedVMSupport.spawnVM((String)PrimaryCrashOnBackupSyncTest.class.getCanonicalName(), (String[])new String[]{this.backupDir.getAbsolutePath(), this.primaryDir.getAbsolutePath()});
        try {
            Assertions.assertEquals((int)OK, (int)process.waitFor());
            Configuration primaryConfiguration = this.createPrimaryConfiguration();
            ActiveMQServer primaryServer = ActiveMQServers.newActiveMQServer((Configuration)primaryConfiguration);
            primaryServer.start();
            Wait.waitFor(() -> primaryServer.isStarted());
            File primaryLMDir = primaryServer.getConfiguration().getLargeMessagesLocation();
            Wait.assertTrue(() -> this.getAllMessageFileIds(primaryLMDir).size() == 0, (long)5000L, (long)100L);
            Set<Long> primaryLM = this.getAllMessageFileIds(primaryLMDir);
            Assertions.assertEquals((int)0, (int)primaryLM.size(), (String)"we really ought to delete these after delivery");
            primaryServer.stop();
        }
        finally {
            process.destroy();
            Assertions.assertTrue((boolean)process.waitFor(5L, TimeUnit.SECONDS));
            Assertions.assertFalse((boolean)process.isAlive());
        }
    }

    private Configuration createPrimaryConfiguration() throws Exception {
        ConfigurationImpl conf = new ConfigurationImpl();
        conf.setName("localhost::primary");
        conf.setBrokerInstance(this.primaryDir);
        conf.addAcceptorConfiguration("primary", "tcp://localhost:61616");
        conf.addConnectorConfiguration("backup", "tcp://localhost:61617");
        conf.addConnectorConfiguration("primary", "tcp://localhost:61616");
        conf.setClusterUser("mycluster");
        conf.setClusterPassword("mypassword");
        ReplicatedPolicyConfiguration haPolicy = new ReplicatedPolicyConfiguration();
        haPolicy.setVoteOnReplicationFailure(false);
        haPolicy.setCheckForActiveServer(false);
        conf.setHAPolicyConfiguration((HAPolicyConfiguration)haPolicy);
        ClusterConnectionConfiguration ccconf = new ClusterConnectionConfiguration();
        ccconf.setStaticConnectors(new ArrayList()).getStaticConnectors().add("backup");
        ccconf.setName("cluster");
        ccconf.setConnectorName("primary");
        conf.addClusterConfiguration(ccconf);
        conf.setSecurityEnabled(false).setJMXManagementEnabled(false).setJournalType(JournalType.MAPPED).setJournalFileSize(524288).setConnectionTTLOverride(60000L);
        return conf;
    }

    private Configuration createBackupConfiguration() throws Exception {
        ConfigurationImpl conf = new ConfigurationImpl();
        conf.setName("localhost::backup");
        conf.setBrokerInstance(this.backupDir);
        ReplicaPolicyConfiguration haPolicy = new ReplicaPolicyConfiguration();
        haPolicy.setClusterName("cluster");
        conf.setHAPolicyConfiguration((HAPolicyConfiguration)haPolicy);
        conf.addAcceptorConfiguration("backup", "tcp://localhost:61617");
        conf.addConnectorConfiguration("primary", "tcp://localhost:61616");
        conf.addConnectorConfiguration("backup", "tcp://localhost:61617");
        conf.setClusterUser("mycluster");
        conf.setClusterPassword("mypassword");
        ClusterConnectionConfiguration ccconf = new ClusterConnectionConfiguration();
        ccconf.setStaticConnectors(new ArrayList()).getStaticConnectors().add("primary");
        ccconf.setName("cluster");
        ccconf.setConnectorName("backup");
        conf.addClusterConfiguration(ccconf);
        conf.setSecurityEnabled(false).setJMXManagementEnabled(false).setJournalType(JournalType.MAPPED).setJournalFileSize(524288).setConnectionTTLOverride(60000L);
        return conf;
    }

    private void createProducerSendSomeLargeMessages(int msgCount) throws Exception {
        byte[] buffer = new byte[102400];
        ServerLocator locator = ServerLocatorImpl.newLocator((String)"tcp://localhost:61616");
        locator.setCallTimeout(60000L);
        locator.setConnectionTTL(60000L);
        ClientSessionFactory csf = locator.createSessionFactory();
        ClientSession session = csf.createSession();
        session.createQueue(QueueConfiguration.of((String)"PrimaryCrashTestQueue").setRoutingType(RoutingType.ANYCAST));
        ClientProducer producer = session.createProducer("PrimaryCrashTestQueue");
        ClientMessage msgs = session.createMessage(true);
        msgs.getBodyBuffer().writeBytes(buffer);
        for (int i = 0; i < msgCount; ++i) {
            producer.send((Message)msgs);
        }
        producer.close();
        session.close();
    }

    private void receiveMsgs(int msgCount) throws Exception {
        ServerLocator locator = ServerLocatorImpl.newLocator((String)"tcp://localhost:61616");
        locator.setCallTimeout(60000L);
        locator.setConnectionTTL(60000L);
        ClientSessionFactory csf = locator.createSessionFactory();
        ClientSession session = csf.createSession();
        session.start();
        ClientConsumer consumer = session.createConsumer("PrimaryCrashTestQueue");
        for (int i = 0; i < msgCount; ++i) {
            ClientMessage message = consumer.receive(1000L);
            Assertions.assertNotNull((Object)message, (String)("Expecting a message " + i));
            message.acknowledge();
        }
        session.commit();
        consumer.close();
        session.close();
    }

    private Set<Long> getAllMessageFileIds(File dir) {
        TreeSet<Long> idsOnBkp = new TreeSet<Long>();
        String[] fileList = dir.list();
        if (fileList != null) {
            for (String filename : fileList) {
                if (!filename.endsWith(".msg")) continue;
                idsOnBkp.add(Long.valueOf(filename.split("\\.")[0]));
            }
        }
        return idsOnBkp;
    }

    public static void main(String[] arg) {
        try {
            if (arg.length < 2) {
                System.err.println("Expected backup and primary as parameters");
                System.exit(-1);
            }
            PrimaryCrashOnBackupSyncTest stop = new PrimaryCrashOnBackupSyncTest();
            stop.backupDir = new File(arg[0]);
            stop.primaryDir = new File(arg[1]);
            final Configuration primaryConfiguration = stop.createPrimaryConfiguration();
            ActiveMQServerImpl primaryServer = new ActiveMQServerImpl(primaryConfiguration, ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)new ActiveMQJAASSecurityManager(InVMLoginModule.class.getName(), new SecurityConfiguration())){

                protected PagingStoreFactoryNIO getPagingStoreFactory() {
                    return new PagingStoreFactoryNIO(this.getStorageManager(), this.getConfiguration().getPagingLocation(), this.getConfiguration().getJournalBufferTimeout_NIO(), this.getScheduledPool(), this.getExecutorFactory(), this.getExecutorFactory(), this.getConfiguration().isJournalSyncNonTransactional(), null){

                        public synchronized PagingStore newStore(SimpleString address, AddressSettings settings) {
                            return new DelayPagingStoreImpl(address, this.getScheduledExecutor(), primaryConfiguration.getJournalBufferTimeout_NIO(), this.getPagingManager(), this.getStorageManager(), null, (PagingStoreFactory)this, address, settings, this.getExecutorFactory().getExecutor(), this.getExecutorFactory().getExecutor(), this.isSyncNonTransactional());
                        }
                    };
                }
            };
            primaryServer.start();
            Wait.waitFor(() -> PrimaryCrashOnBackupSyncTest.lambda$main$2((ActiveMQServer)primaryServer));
            Configuration backupConfiguration = stop.createBackupConfiguration();
            ActiveMQServer backupServer = ActiveMQServers.newActiveMQServer((Configuration)backupConfiguration);
            backupServer.start();
            Wait.waitFor(() -> backupServer.isStarted());
            stop.createProducerSendSomeLargeMessages(100);
            stop.receiveMsgs(100);
            primaryServer.getStorageManager().getMessageJournal().stop();
            System.exit(OK);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static File newFolder(File root, String ... subDirs) throws IOException {
        String subFolder = String.join((CharSequence)"/", subDirs);
        File result = new File(root, subFolder);
        if (!result.mkdirs()) {
            throw new IOException("Couldn't create folders " + root);
        }
        return result;
    }

    private static /* synthetic */ boolean lambda$main$2(ActiveMQServer primaryServer) throws Exception {
        return primaryServer.isStarted();
    }
}

