/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.client;

import jakarta.jms.Connection;
import jakarta.jms.InvalidClientIDException;
import jakarta.jms.JMSException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBasePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerPlugin;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class SessionMetadataAddExceptionTest
extends JMSTestBase {
    private AtomicInteger duplicateCount = new AtomicInteger();

    @Override
    protected Configuration createDefaultConfig(boolean netty) throws Exception {
        this.duplicateCount.set(0);
        Configuration config = super.createDefaultConfig(netty);
        config.registerBrokerPlugin((ActiveMQServerBasePlugin)new ActiveMQServerPlugin(){

            public void beforeSessionMetadataAdded(ServerSession session, String key, String data) throws ActiveMQException {
                if ("jms-client-id".equals(key) && "invalid".equals(data)) {
                    throw new ActiveMQException("Invalid clientId");
                }
            }

            public void duplicateSessionMetadataFailure(ServerSession session, String key, String data) throws ActiveMQException {
                SessionMetadataAddExceptionTest.this.duplicateCount.incrementAndGet();
                if (data.equals("valid2")) {
                    throw new ActiveMQException("failure");
                }
            }
        });
        return config;
    }

    @Test
    @Timeout(value=5L)
    public void testInvalidClientIdSetConnection() throws Exception {
        Assertions.assertThrows(JMSException.class, () -> {
            Connection con = this.cf.createConnection();
            try {
                con.setClientID("invalid");
            }
            finally {
                try {
                    con.close();
                }
                catch (Exception exception) {}
            }
        });
    }

    @Test
    @Timeout(value=5L)
    public void testInvalidClientIdSetFactory() throws Exception {
        Assertions.assertThrows(JMSException.class, () -> {
            ActiveMQConnectionFactory activeMQConnectionFactory = (ActiveMQConnectionFactory)this.cf;
            activeMQConnectionFactory.setClientID("invalid");
            this.cf.createConnection();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=5L)
    public void testDuplicateClientIdSet() throws Exception {
        ActiveMQConnectionFactory activeMQConnectionFactory = (ActiveMQConnectionFactory)this.cf;
        Connection con = this.cf.createConnection();
        Connection con2 = this.cf.createConnection();
        try {
            con.setClientID("valid");
            con2.setClientID("valid");
            Assertions.fail((String)"Should have failed for duplicate clientId");
        }
        catch (InvalidClientIDException e) {
            Assertions.assertEquals((int)1, (int)this.duplicateCount.get());
        }
        finally {
            activeMQConnectionFactory.close();
        }
    }

    @Test
    @Timeout(value=5L)
    public void testDuplicateClientIdSetActiveMQException() throws Exception {
        Assertions.assertThrows(JMSException.class, () -> {
            ActiveMQConnectionFactory activeMQConnectionFactory = (ActiveMQConnectionFactory)this.cf;
            Connection con = this.cf.createConnection();
            Connection con2 = this.cf.createConnection();
            try {
                con.setClientID("valid2");
                con2.setClientID("valid2");
                Assertions.fail((String)"Should have failed");
            }
            finally {
                activeMQConnectionFactory.close();
            }
        });
    }

    @Test
    @Timeout(value=5L)
    public void testValidIdSetConnection() throws Exception {
        try (Connection con = this.cf.createConnection();){
            con.setClientID("valid");
            con.start();
        }
    }

    @Test
    @Timeout(value=5L)
    public void testValidClientIdSetFactory() throws Exception {
        ActiveMQConnectionFactory activeMQConnectionFactory = (ActiveMQConnectionFactory)this.cf;
        activeMQConnectionFactory.setClientID("valid");
        try (Connection con = this.cf.createConnection();){
            con.start();
        }
    }
}

