/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.Session;
import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.command.ActiveMQDestination;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class JMSConsumer3Test
extends BasicOpenWireTest {
    public ActiveMQDestination destination;
    public int deliveryMode;
    public int prefetch;
    public int ackMode;
    public byte destinationType;
    public boolean durableConsumer;

    @Parameters(name="deliveryMode={0} ackMode={1} destinationType={2}")
    public static Collection<Object[]> getParams() {
        return Arrays.asList({1, 1, (byte)1}, {1, 1, (byte)2}, {1, 1, (byte)5}, {1, 1, (byte)6}, {1, 3, (byte)1}, {1, 3, (byte)2}, {1, 3, (byte)5}, {1, 3, (byte)6}, {1, 2, (byte)1}, {1, 2, (byte)2}, {1, 2, (byte)5}, {1, 2, (byte)6}, {2, 1, (byte)1}, {2, 1, (byte)2}, {2, 1, (byte)5}, {2, 1, (byte)6}, {2, 3, (byte)1}, {2, 3, (byte)2}, {2, 3, (byte)5}, {2, 3, (byte)6}, {2, 2, (byte)1}, {2, 2, (byte)2}, {2, 2, (byte)5}, {2, 2, (byte)6});
    }

    public JMSConsumer3Test(int deliveryMode, int ackMode, byte destinationType) {
        this.deliveryMode = deliveryMode;
        this.ackMode = ackMode;
        this.destinationType = destinationType;
    }

    @TestTemplate
    public void testMutiReceiveWithPrefetch1() throws Exception {
        this.connection.getPrefetchPolicy().setAll(1);
        this.connection.start();
        Session session = this.connection.createSession(false, this.ackMode);
        this.destination = this.createDestination(session, this.destinationType);
        MessageConsumer consumer = session.createConsumer((Destination)this.destination);
        this.sendMessages(session, (Destination)this.destination, 4);
        Message message = null;
        for (int i = 0; i < 4; ++i) {
            message = consumer.receive(5000L);
            Assertions.assertNotNull((Object)message);
        }
        Assertions.assertNull((Object)consumer.receiveNoWait());
        message.acknowledge();
    }
}

