/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.paging;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.paging.PageTransactionInfo;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.paging.impl.Page;
import org.apache.activemq.artemis.core.paging.impl.PageTransactionInfoImpl;
import org.apache.activemq.artemis.core.paging.impl.PagingStoreImpl;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.QueueImpl;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.transaction.impl.XidImpl;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.collections.LinkedList;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournalPagingTest
extends ActiveMQTestBase {
    protected static final int PAGE_MAX = 102400;
    protected static final int PAGE_SIZE = 10240;
    static final int MESSAGE_SIZE = 1024;
    static final SimpleString ADDRESS = SimpleString.of((String)"SimpleAddress");
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected ServerLocator locator;
    protected ActiveMQServer server;
    protected ClientSessionFactory sf;
    private AssertionLoggerHandler loggerHandler;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.locator = this.createInVMNonHALocator();
        this.loggerHandler = new AssertionLoggerHandler();
    }

    @AfterEach
    public void checkLoggerEnd() throws Exception {
        if (this.loggerHandler != null) {
            try {
                Assertions.assertFalse((boolean)this.loggerHandler.findText(new String[]{"222214"}));
                Assertions.assertFalse((boolean)this.loggerHandler.findText(new String[]{"222215"}));
            }
            finally {
                this.loggerHandler.close();
            }
        }
    }

    @Test
    public void testPageCleanupWithInvalidDataTruncated() throws Exception {
        this.testPageCleanupWithInvalidData(true);
    }

    @Test
    public void testPageCleanupWithInvalidData() throws Exception {
        this.testPageCleanupWithInvalidData(false);
    }

    public void testPageCleanupWithInvalidData(boolean truncated) throws Exception {
        int i;
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        int numberOfMessages = 100;
        this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)ADDRESS));
        ClientProducer producer = session.createProducer(ADDRESS);
        ClientMessage message = null;
        byte[] body = new byte[10];
        ByteBuffer bb = ByteBuffer.wrap(body);
        for (int j = 1; j <= 10; ++j) {
            bb.put(JournalPagingTest.getSamplebyte(j));
        }
        Queue queue = this.server.locateQueue(ADDRESS);
        queue.getPagingStore().startPaging();
        queue.getPagingStore().forceAnotherPage();
        int page = 1;
        for (int i2 = 0; i2 < 100; ++i2) {
            if (i2 % 10 == 0 && i2 > 0) {
                queue.getPagingStore().forceAnotherPage();
                ++page;
            }
            message = session.createMessage(true);
            ActiveMQBuffer bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(body);
            message.putIntProperty("i", i2);
            message.putIntProperty("page", page);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        queue.getPagingStore().getCursorProvider().disableCleanup();
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        session.start();
        for (int i3 = 0; i3 < 11; ++i3) {
            ClientMessage msgRec = consumer.receive(1000L);
            Assertions.assertNotNull((Object)msgRec);
            msgRec.acknowledge();
        }
        session.commit();
        consumer.close();
        consumer = session.createConsumer(ADDRESS, SimpleString.of((String)"i=29"));
        message = consumer.receive(5000L);
        Assertions.assertNotNull((Object)message);
        message.acknowledge();
        session.commit();
        File folder = queue.getPagingStore().getFolder();
        for (int f = 2; f <= 3; ++f) {
            String fileName = ((PagingStoreImpl)queue.getPagingStore()).createFileName((long)f);
            File file = new File(folder, fileName);
            file.delete();
            file.createNewFile();
            if (truncated) continue;
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(new byte[10]);
            fileOutputStream.close();
        }
        this.sf.close();
        this.server.getStorageManager().getMessageJournal().scheduleCompactAndBlock(5000);
        Page page4 = queue.getPagingStore().newPageObject(4L);
        page4.open(true);
        LinkedList messagesRead = page4.read(this.server.getStorageManager());
        Assertions.assertEquals((int)10, (int)messagesRead.size());
        page4.close(false);
        page4.delete(null);
        page4.open(true);
        for (i = 0; i < 9; ++i) {
            page4.write((PagedMessage)messagesRead.get(i));
        }
        page4.close(false);
        this.server.stop();
        this.server.start();
        queue = this.server.locateQueue(ADDRESS);
        Assertions.assertTrue((boolean)queue.getPagingStore().isPaging());
        queue.getPageSubscription().enableAutoCleanup();
        this.sf = this.createSessionFactory(this.locator);
        session = this.sf.createSession(false, true, true);
        logger.info("*******************************************************************************************************************************");
        logger.info("Creating consumer");
        consumer = session.createConsumer(ADDRESS);
        session.start();
        for (i = 20; i < 100; ++i) {
            if (i == 29) continue;
            ClientMessage msgClient = consumer.receive(1000L);
            Assertions.assertNotNull((Object)msgClient);
            Assertions.assertEquals((int)i, (int)msgClient.getIntProperty("i"));
            msgClient.acknowledge();
        }
        ClientMessage msgClient = consumer.receiveImmediate();
        Assertions.assertNull((Object)msgClient);
        session.commit();
        Wait.assertFalse(() -> ((PagingStore)queue.getPagingStore()).isPaging(), (long)5000L, (long)100L);
    }

    @Test
    public void testEmptyAddress() throws Exception {
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        int numberOfMessages = 500;
        this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(false, false, false);
        session.createQueue(QueueConfiguration.of((SimpleString)ADDRESS).setRoutingType(RoutingType.ANYCAST));
        ClientProducer producer = session.createProducer(ADDRESS);
        byte[] body = new byte[1024];
        ByteBuffer bb = ByteBuffer.wrap(body);
        for (int j = 1; j <= 1024; ++j) {
            bb.put(JournalPagingTest.getSamplebyte(j));
        }
        for (int i = 0; i < 500; ++i) {
            ClientMessage message = session.createMessage(true);
            message.getBodyBuffer().writeBytes(body);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            if (i % 1000 != 0) continue;
            session.commit();
        }
        session.commit();
        producer.close();
        session.close();
        String addressTxt = this.server.getPagingManager().getPageStore(ADDRESS).getFolder().getAbsolutePath() + File.separator + "address.txt";
        this.server.stop();
        new PrintWriter(addressTxt).close();
        Assertions.assertTrue((boolean)new File(addressTxt).exists());
        AtomicBoolean activationFailures = new AtomicBoolean();
        this.server.registerActivationFailureListener(exception -> activationFailures.set(true));
        this.server.start();
        this.server.stop();
        Assertions.assertFalse((boolean)activationFailures.get());
    }

    @Test
    public void testPurge() throws Exception {
        int i;
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultNettyConfig().setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        SimpleString queue = SimpleString.of((String)("testPurge:" + RandomUtil.randomString()));
        this.server.addAddressInfo(new AddressInfo(queue, RoutingType.ANYCAST));
        QueueImpl purgeQueue = (QueueImpl)this.server.createQueue(QueueConfiguration.of((SimpleString)queue).setRoutingType(RoutingType.ANYCAST).setMaxConsumers(Integer.valueOf(1)).setPurgeOnNoConsumers(Boolean.valueOf(true)).setAutoCreateAddress(Boolean.valueOf(false)));
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory();
        Connection connection = cf.createConnection();
        Session session = connection.createSession(true, 0);
        jakarta.jms.Queue jmsQueue = session.createQueue(queue.toString());
        MessageProducer producer = session.createProducer((Destination)jmsQueue);
        for (int i2 = 0; i2 < 100; ++i2) {
            producer.send((Message)session.createTextMessage("hello" + i2));
        }
        session.commit();
        Wait.assertEquals((long)0L, () -> ((QueueImpl)purgeQueue).getMessageCount());
        Wait.assertEquals((long)0L, () -> ((PagingStore)purgeQueue.getPageSubscription().getPagingStore()).getAddressSize());
        MessageConsumer consumer = session.createConsumer((Destination)jmsQueue);
        for (i = 0; i < 100; ++i) {
            producer.send((Message)session.createTextMessage("hello" + i));
            if (i != 10) continue;
            purgeQueue.getPageSubscription().getPagingStore().startPaging();
        }
        session.commit();
        consumer.close();
        Wait.assertEquals((long)0L, () -> ((QueueImpl)purgeQueue).getMessageCount());
        Wait.assertFalse(() -> ((PageSubscription)purgeQueue.getPageSubscription()).isPaging());
        Wait.assertEquals((long)0L, () -> ((PagingStore)purgeQueue.getPageSubscription().getPagingStore()).getAddressSize());
        consumer = session.createConsumer((Destination)jmsQueue);
        for (i = 0; i < 100; ++i) {
            purgeQueue.getPageSubscription().getPagingStore().startPaging();
            Assertions.assertTrue((boolean)purgeQueue.getPageSubscription().isPaging());
            producer.send((Message)session.createTextMessage("hello" + i));
            if (i % 2 != 0) continue;
            session.commit();
        }
        session.commit();
        Wait.assertTrue(() -> ((PageSubscription)purgeQueue.getPageSubscription()).isPaging());
        connection.start();
        this.server.getStorageManager().getMessageJournal().scheduleCompactAndBlock(50000);
        Assertions.assertNotNull((Object)consumer.receive(5000L));
        session.commit();
        consumer.close();
        Wait.assertEquals((long)0L, () -> ((QueueImpl)purgeQueue).getMessageCount());
        Wait.assertEquals((long)0L, () -> ((PagingStore)purgeQueue.getPageSubscription().getPagingStore()).getAddressSize());
        Wait.assertFalse(() -> ((PageSubscription)purgeQueue.getPageSubscription()).isPaging(), (long)5000L, (long)100L);
        StorageManager sm = this.server.getStorageManager();
        for (int i3 = 0; i3 < 1000; ++i3) {
            long tx = sm.generateID();
            PageTransactionInfoImpl txinfo = new PageTransactionInfoImpl(tx);
            sm.storePageTransaction(tx, (PageTransactionInfo)txinfo);
            sm.commit(tx);
            tx = sm.generateID();
            sm.updatePageTransaction(tx, (PageTransactionInfo)txinfo, 1);
            sm.commit(tx);
        }
        this.server.stop();
        this.server.start();
        Wait.assertEquals((int)0, () -> this.server.getPagingManager().getTransactions().size());
    }

    @Test
    public void testPreparedACKRemoveAndRestart() throws Exception {
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        int numberOfMessages = 10;
        this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true).setAckBatchSize(0);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)ADDRESS));
        Queue queue = this.server.locateQueue(ADDRESS);
        ClientProducer producer = session.createProducer(ADDRESS);
        byte[] body = new byte[1024];
        ByteBuffer bb = ByteBuffer.wrap(body);
        for (int j = 1; j <= 1024; ++j) {
            bb.put(JournalPagingTest.getSamplebyte(j));
        }
        queue.getPageSubscription().getPagingStore().startPaging();
        this.forcePage(queue);
        for (int i = 0; i < 10; ++i) {
            ClientMessage message = session.createMessage(true);
            message.putIntProperty("count", i);
            ActiveMQBuffer bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(body);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            if (i != 4) continue;
            session.commit();
            queue.getPageSubscription().getPagingStore().forceAnotherPage();
        }
        session.commit();
        session.close();
        session = this.sf.createSession(true, false, false);
        ClientConsumer cons = session.createConsumer(ADDRESS);
        session.start();
        for (int i = 0; i <= 4; ++i) {
            XidImpl xidConsumeNoCommit = this.newXID();
            session.start((Xid)xidConsumeNoCommit, 0);
            ClientMessage firstMessageConsumed = cons.receive(5000L);
            Assertions.assertNotNull((Object)firstMessageConsumed);
            firstMessageConsumed.acknowledge();
            session.end((Xid)xidConsumeNoCommit, 0x4000000);
            session.prepare((Xid)xidConsumeNoCommit);
        }
        File pagingFolder = queue.getPageSubscription().getPagingStore().getFolder();
        this.server.stop();
        File fileToRemove = new File(pagingFolder, "000000001.page");
        Assertions.assertTrue((boolean)fileToRemove.delete());
        this.server.start();
        this.sf = this.createSessionFactory(this.locator);
        session = this.sf.createSession(false, true, true);
        cons = session.createConsumer(ADDRESS);
        session.start();
        for (int i = 5; i < 10; ++i) {
            ClientMessage message = cons.receive(1000L);
            Assertions.assertNotNull((Object)message);
            Assertions.assertEquals((int)i, (int)message.getIntProperty("count"));
            message.acknowledge();
        }
        Assertions.assertNull((Object)cons.receiveImmediate());
        session.commit();
    }

    private void forcePage(Queue queue) throws InterruptedException {
        long timeout = System.currentTimeMillis() + 5000L;
        while (timeout > System.currentTimeMillis() && !queue.getPageSubscription().getPagingStore().isPaging()) {
            Thread.sleep(10L);
        }
        Assertions.assertTrue((boolean)queue.getPageSubscription().getPagingStore().isPaging());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInabilityToCreateDirectoryDuringPaging() throws Exception {
        try (AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();){
            this.clearDataRecreateServerDirs();
            Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false).setPagingDirectory("/" + UUID.randomUUID().toString());
            this.server = this.createServer(true, config, 10240, 102400L);
            this.server.start();
            int numberOfMessages = 100;
            this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
            this.sf = this.createSessionFactory(this.locator);
            ClientSession session = this.sf.createSession(false, true, true);
            session.createQueue(QueueConfiguration.of((SimpleString)ADDRESS));
            ClientProducer producer = session.createProducer(ADDRESS);
            ClientMessage message = null;
            byte[] body = new byte[1024];
            ByteBuffer bb = ByteBuffer.wrap(body);
            for (int j = 1; j <= 1024; ++j) {
                bb.put(JournalPagingTest.getSamplebyte(j));
            }
            for (int i = 0; i < 100; ++i) {
                message = session.createMessage(true);
                ActiveMQBuffer bodyLocal = message.getBodyBuffer();
                bodyLocal.writeBytes(body);
                message.putIntProperty(SimpleString.of((String)"id"), i);
                try {
                    producer.send((org.apache.activemq.artemis.api.core.Message)message);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Assertions.assertTrue((boolean)Wait.waitFor(() -> this.server.getState() == ActiveMQServer.SERVER_STATE.STOPPED, (long)5000L, (long)200L));
            session.close();
            this.sf.close();
            this.locator.close();
        }
        catch (Throwable throwable) {
            Assertions.assertTrue((boolean)this.loggerHandler.findText(new String[]{"AMQ144010"}));
            throw throwable;
        }
        Assertions.assertTrue((boolean)this.loggerHandler.findText(new String[]{"AMQ144010"}));
    }

    @Test
    public void testDeletePhysicalPages() throws Exception {
        ClientMessage msg;
        int msgCount;
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultInVMConfig().setPersistDeliveryCountBeforeDelivery(true);
        config.setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        int numberOfMessages = 300;
        this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(false, false, false);
        session.createQueue(QueueConfiguration.of((SimpleString)ADDRESS));
        ClientProducer producer = session.createProducer(ADDRESS);
        ClientMessage message = null;
        byte[] body = new byte[1024];
        ByteBuffer bb = ByteBuffer.wrap(body);
        for (int j = 1; j <= 1024; ++j) {
            bb.put(JournalPagingTest.getSamplebyte(j));
        }
        for (int i = 0; i < 300; ++i) {
            message = session.createMessage(true);
            ActiveMQBuffer bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(body);
            message.putIntProperty(SimpleString.of((String)"id"), i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            if (i % 1000 != 0) continue;
            session.commit();
        }
        session.commit();
        session.close();
        session = null;
        this.sf.close();
        this.locator.close();
        this.server.stop();
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        this.sf = this.createSessionFactory(this.locator);
        Queue queue = this.server.locateQueue(ADDRESS);
        Wait.assertEquals((long)300L, () -> ((Queue)queue).getMessageCount());
        ClientSession sessionConsumer = this.sf.createSession(false, false, false);
        sessionConsumer.start();
        ClientConsumer consumer = sessionConsumer.createConsumer(ADDRESS);
        for (msgCount = 0; msgCount < 300; ++msgCount) {
            logger.debug("Received {}", (Object)msgCount);
            msg = consumer.receive(100L);
            if (msg == null) {
                logger.debug("It's null. leaving now");
                sessionConsumer.commit();
                Assertions.fail((String)"Didn't receive a message");
            }
            msg.acknowledge();
            if (msgCount % 5 != 0) continue;
            logger.debug("commit");
            sessionConsumer.commit();
        }
        sessionConsumer.commit();
        sessionConsumer.close();
        this.sf.close();
        this.locator.close();
        Wait.assertEquals((long)0L, () -> ((Queue)queue).getMessageCount());
        Wait.assertFalse(() -> ((PagingStore)queue.getPagingStore()).isPaging(), (long)1000L, (long)100L);
        this.server.stop();
        JournalPagingTest.deleteDirectory(new File(this.getPageDir()));
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        this.sf = this.createSessionFactory(this.locator);
        queue = this.server.locateQueue(ADDRESS);
        this.sf = this.createSessionFactory(this.locator);
        session = this.sf.createSession(false, false, false);
        producer = session.createProducer(ADDRESS);
        for (int i = 0; i < 600; ++i) {
            message = session.createMessage(true);
            ActiveMQBuffer bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(body);
            message.putIntProperty(SimpleString.of((String)"theid"), i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            if (i % 1000 != 0) continue;
            session.commit();
        }
        session.commit();
        this.server.stop();
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        this.sf = this.createSessionFactory(this.locator);
        sessionConsumer = this.sf.createSession(false, false, false);
        sessionConsumer.start();
        consumer = sessionConsumer.createConsumer(ADDRESS);
        for (msgCount = 0; msgCount < 300; ++msgCount) {
            logger.debug("Received {}", (Object)msgCount);
            msg = consumer.receive(100L);
            if (msg == null) {
                logger.debug("It's null. leaving now");
                sessionConsumer.commit();
                Assertions.fail((String)"Didn't receive a message");
            }
            msg.acknowledge();
            if (msgCount % 5 != 0) continue;
            logger.debug("commit");
            sessionConsumer.commit();
        }
        sessionConsumer.commit();
        sessionConsumer.close();
    }

    @Override
    protected void applySettings(ActiveMQServer server, Configuration configuration, int pageSize, long maxAddressSize, Integer maxReadPageMessages, Integer maxReadPageBytes, Map<String, AddressSettings> settings) {
        server.getConfiguration().setAddressQueueScanPeriod(100L);
    }
}

