/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.persistence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.jms.server.config.impl.TransportConfigurationEncodingSupport;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TransportConfigurationEncodingSupportTest {
    @Test
    public void testTransportConfiguration() throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("port", 5665);
        params.put("host", RandomUtil.randomString());
        TransportConfiguration config = new TransportConfiguration(NettyConnectorFactory.class.getName(), params);
        ActiveMQBuffer buffer = ActiveMQBuffers.fixedBuffer((int)TransportConfigurationEncodingSupport.getEncodeSize((TransportConfiguration)config));
        TransportConfigurationEncodingSupport.encode((ActiveMQBuffer)buffer, (TransportConfiguration)config);
        Assertions.assertEquals((int)buffer.capacity(), (int)buffer.writerIndex());
        buffer.readerIndex(0);
        TransportConfiguration decoded = TransportConfigurationEncodingSupport.decode((ActiveMQBuffer)buffer);
        Assertions.assertNotNull((Object)decoded);
        Assertions.assertEquals((Object)config.getName(), (Object)decoded.getName());
        Assertions.assertEquals((Object)config.getFactoryClassName(), (Object)decoded.getFactoryClassName());
        Assertions.assertEquals((int)config.getParams().size(), (int)decoded.getParams().size());
        for (String key : config.getParams().keySet()) {
            Assertions.assertEquals((Object)config.getParams().get(key).toString(), (Object)decoded.getParams().get(key).toString());
        }
    }

    @Test
    public void testTransportConfigurations() throws Exception {
        ArrayList<Pair> connectorConfigs = new ArrayList<Pair>();
        HashMap<String, Integer> primaryParams = new HashMap<String, Integer>();
        primaryParams.put("port", 5665);
        TransportConfiguration primary1 = new TransportConfiguration(NettyConnectorFactory.class.getName(), primaryParams);
        HashMap<String, Integer> backupParams = new HashMap<String, Integer>();
        backupParams.put("port", 5775);
        TransportConfiguration backup1 = new TransportConfiguration(NettyConnectorFactory.class.getName(), backupParams);
        HashMap<String, Integer> primaryParams2 = new HashMap<String, Integer>();
        primaryParams2.put("port", 6665);
        TransportConfiguration primary2 = new TransportConfiguration(NettyConnectorFactory.class.getName(), primaryParams2);
        connectorConfigs.add(new Pair((Object)primary1, (Object)backup1));
        connectorConfigs.add(new Pair((Object)primary2, null));
        ActiveMQBuffer buffer = ActiveMQBuffers.fixedBuffer((int)TransportConfigurationEncodingSupport.getEncodeSize(connectorConfigs));
        TransportConfigurationEncodingSupport.encodeConfigs((ActiveMQBuffer)buffer, connectorConfigs);
        Assertions.assertEquals((int)buffer.capacity(), (int)buffer.writerIndex());
        buffer.readerIndex(0);
        List decodedConfigs = TransportConfigurationEncodingSupport.decodeConfigs((ActiveMQBuffer)buffer);
        Assertions.assertNotNull((Object)decodedConfigs);
        Assertions.assertEquals((int)2, (int)decodedConfigs.size());
        TransportConfigurationEncodingSupportTest.assertEquivalent((TransportConfiguration)((Pair)connectorConfigs.get(0)).getA(), (TransportConfiguration)((Pair)decodedConfigs.get(0)).getA());
        TransportConfigurationEncodingSupportTest.assertEquivalent((TransportConfiguration)((Pair)connectorConfigs.get(0)).getB(), (TransportConfiguration)((Pair)decodedConfigs.get(0)).getB());
        TransportConfigurationEncodingSupportTest.assertEquivalent((TransportConfiguration)((Pair)connectorConfigs.get(1)).getA(), (TransportConfiguration)((Pair)decodedConfigs.get(1)).getA());
        Assertions.assertNull((Object)((Pair)decodedConfigs.get(1)).getB());
    }

    private static void assertEquivalent(TransportConfiguration expected, TransportConfiguration actual) {
        Assertions.assertEquals((Object)expected.getFactoryClassName(), (Object)actual.getFactoryClassName());
        Assertions.assertEquals((Object)expected.getName(), (Object)actual.getName());
        Assertions.assertEquals((int)expected.getParams().size(), (int)actual.getParams().size());
        for (Map.Entry entry : expected.getParams().entrySet()) {
            String key = (String)entry.getKey();
            Assertions.assertEquals((Object)expected.getParams().get(key).toString(), (Object)actual.getParams().get(key).toString());
        }
    }
}

