/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.plugin;

import io.micrometer.core.instrument.Meter;
import org.apache.activemq.artemis.core.config.MetricsConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.metrics.plugins.SimpleMetricsPlugin;
import org.apache.activemq.artemis.tests.integration.plugin.MetricsPluginTest;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SystemMetricsTest
extends ActiveMQTestBase {
    String[] fileDescriptorsMetrics = new String[]{"process.files.open", "process.files.max"};
    String[] processorMetrics = new String[]{"system.cpu.count", "system.load.average.1m", "system.cpu.usage", "process.cpu.usage"};
    String[] uptimeMetrics = new String[]{"process.uptime", "process.start.time"};

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
    }

    @Test
    public void testFileDescriptorsMetricsPositive() throws Exception {
        this.internalTestMetrics(true, false, true, false, false, this.fileDescriptorsMetrics);
    }

    @Test
    public void testFileDescriptorsMetricsNegative() throws Exception {
        this.internalTestMetrics(false, false, false, false, false, this.fileDescriptorsMetrics);
    }

    @Test
    public void testProcessorMetricsPositive() throws Exception {
        this.internalTestMetrics(true, false, false, true, false, this.processorMetrics);
    }

    @Test
    public void testProcessorMetricsNegative() throws Exception {
        this.internalTestMetrics(false, false, false, false, false, this.processorMetrics);
    }

    @Test
    public void testUptimeMetricsPositive() throws Exception {
        this.internalTestMetrics(true, false, false, false, true, this.uptimeMetrics);
    }

    @Test
    public void testUptimeMetricsNegative() throws Exception {
        this.internalTestMetrics(false, false, false, false, false, this.uptimeMetrics);
    }

    private void internalTestMetrics(boolean found, boolean diskSpace, boolean fileDescriptors, boolean processor, boolean uptime, String ... matches) throws Exception {
        ActiveMQServer server = this.createServer(false, this.createDefaultInVMConfig().setMetricsConfiguration(new MetricsConfiguration().setPlugin(new SimpleMetricsPlugin().init(null)).setFileDescriptors(fileDescriptors).setProcessor(processor).setUptime(uptime)));
        server.start();
        boolean result = false;
        String brokerTagValue = "";
        block0: for (Meter.Id meterId : MetricsPluginTest.getMetrics(server).keySet()) {
            for (String match : matches) {
                if (!meterId.getName().startsWith(match)) continue;
                result = true;
                brokerTagValue = meterId.getTag("broker");
                continue block0;
            }
        }
        Assertions.assertEquals((Object)found, (Object)result);
        if (found) {
            Assertions.assertEquals((Object)brokerTagValue, (Object)server.getConfiguration().getName());
        }
    }
}

