/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.retention;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.DistributedLockManagerConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationPrimaryPolicyConfiguration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.lockmanager.file.FileBasedLockManager;
import org.apache.activemq.artemis.tests.integration.retention.ReplayTest;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.jupiter.api.BeforeEach;

public class ReplayWithReplicationTest
extends ReplayTest {
    private DistributedLockManagerConfiguration managerConfiguration;
    ActiveMQServer backupServer;

    File newTemporaryFolder(String name) {
        File newFolder = new File(this.temporaryFolder, name);
        newFolder.mkdirs();
        return newFolder;
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.managerConfiguration = new DistributedLockManagerConfiguration(FileBasedLockManager.class.getName(), Collections.singletonMap("locks-folder", this.newTemporaryFolder("manager").toString()));
        int timeout = (int)TimeUnit.SECONDS.toMillis(30L);
        Configuration liveConfiguration = this.createLiveConfiguration();
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)liveConfiguration));
        this.server.setIdentity("PRIMARY");
        this.server.getConfiguration().setJournalRetentionDirectory(this.getJournalDir() + "retention");
        this.server.getConfiguration().setJournalFileSize(102400);
        this.server.start();
        this.server.addAddressInfo(new AddressInfo("t1").addRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((String)"t1").setAddress("t1").setRoutingType(RoutingType.ANYCAST));
        this.server.addAddressInfo(new AddressInfo("t2").addRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((String)"t2").setAddress("t2").setRoutingType(RoutingType.ANYCAST));
        Configuration backupConfiguration = this.createBackupConfiguration();
        ((ReplicationBackupPolicyConfiguration)backupConfiguration.getHAPolicyConfiguration()).setAllowFailBack(true);
        this.backupServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)backupConfiguration));
        this.backupServer.setIdentity("BACKUP");
        this.backupServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)this.backupServer).isStarted());
        Wait.assertTrue(() -> this.backupServer.isReplicaSync(), (long)timeout);
    }

    protected HAPolicyConfiguration createReplicationLiveConfiguration() {
        ReplicationPrimaryPolicyConfiguration haPolicy = ReplicationPrimaryPolicyConfiguration.withDefault();
        haPolicy.setDistributedManagerConfiguration(this.managerConfiguration);
        return haPolicy;
    }

    protected HAPolicyConfiguration createReplicationBackupConfiguration() {
        ReplicationBackupPolicyConfiguration haPolicy = ReplicationBackupPolicyConfiguration.withDefault();
        haPolicy.setDistributedManagerConfiguration(this.managerConfiguration);
        haPolicy.setClusterName("cluster");
        return haPolicy;
    }

    protected Configuration createLiveConfiguration() throws Exception {
        ConfigurationImpl conf = new ConfigurationImpl();
        conf.setName("localhost::live");
        File liveDir = this.newTemporaryFolder("live");
        conf.setBrokerInstance(liveDir);
        conf.addAcceptorConfiguration("live", "tcp://localhost:61616");
        conf.addConnectorConfiguration("backup", "tcp://localhost:61617");
        conf.addConnectorConfiguration("live", "tcp://localhost:61616");
        conf.setClusterUser("mycluster");
        conf.setClusterPassword("mypassword");
        conf.setHAPolicyConfiguration(this.createReplicationLiveConfiguration());
        ClusterConnectionConfiguration ccconf = new ClusterConnectionConfiguration();
        ccconf.setStaticConnectors(new ArrayList()).getStaticConnectors().add("backup");
        ccconf.setName("cluster");
        ccconf.setConnectorName("live");
        conf.addClusterConfiguration(ccconf);
        conf.setSecurityEnabled(false).setJMXManagementEnabled(false).setJournalType(JournalType.MAPPED).setJournalFileSize(524288).setConnectionTTLOverride(60000L);
        return conf;
    }

    protected Configuration createBackupConfiguration() throws Exception {
        ConfigurationImpl conf = new ConfigurationImpl();
        conf.setName("localhost::backup");
        File backupDir = this.newTemporaryFolder("backup");
        conf.setBrokerInstance(backupDir);
        conf.setHAPolicyConfiguration(this.createReplicationBackupConfiguration());
        conf.addAcceptorConfiguration("backup", "tcp://localhost:61617");
        conf.addConnectorConfiguration("live", "tcp://localhost:61616");
        conf.addConnectorConfiguration("backup", "tcp://localhost:61617");
        conf.setClusterUser("mycluster");
        conf.setClusterPassword("mypassword");
        ClusterConnectionConfiguration ccconf = new ClusterConnectionConfiguration();
        ccconf.setStaticConnectors(new ArrayList()).getStaticConnectors().add("live");
        ccconf.setName("cluster");
        ccconf.setConnectorName("backup");
        conf.addClusterConfiguration(ccconf);
        conf.setSecurityEnabled(false).setJMXManagementEnabled(false).setJournalType(JournalType.MAPPED).setJournalFileSize(524288).setConnectionTTLOverride(60000L);
        return conf;
    }
}

