/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.routing;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.BroadcastGroupConfiguration;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.routing.KeyType;
import org.apache.activemq.artemis.core.server.routing.policies.FirstElementPolicy;
import org.apache.activemq.artemis.core.server.routing.policies.Policy;
import org.apache.activemq.artemis.core.server.routing.policies.PolicyFactory;
import org.apache.activemq.artemis.core.server.routing.policies.PolicyFactoryResolver;
import org.apache.activemq.artemis.core.server.routing.targets.Target;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.apache.activemq.artemis.tests.integration.routing.RoutingTestBase;
import org.apache.activemq.artemis.tests.integration.security.SecurityTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class KeyTypeTest
extends RoutingTestBase {
    private static final String MOCK_POLICY_NAME = "MOCK_POLICY";
    private final String protocol;
    private final List<String> keys = new ArrayList<String>();

    @Parameters(name="protocol: {0}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        for (String protocol : Arrays.asList("AMQP", "CORE", "OPENWIRE")) {
            data.add(new Object[]{protocol});
        }
        return data;
    }

    public KeyTypeTest(String protocol) {
        this.protocol = protocol;
    }

    @BeforeEach
    public void setup() throws Exception {
        PolicyFactoryResolver.getInstance().registerPolicyFactory(MOCK_POLICY_NAME, new PolicyFactory(){

            public Policy create() {
                return new FirstElementPolicy(KeyTypeTest.MOCK_POLICY_NAME){

                    public Target selectTarget(List<Target> targets, String key) {
                        KeyTypeTest.this.keys.add(key);
                        return super.selectTarget(targets, key);
                    }
                };
            }
        });
    }

    @TestTemplate
    public void testClientIDKey() throws Exception {
        this.setupPrimaryServerWithDiscovery(0, GROUP_ADDRESS, GROUP_PORT, true, true, false);
        this.setupRouterServerWithDiscovery(0, KeyType.CLIENT_ID, MOCK_POLICY_NAME, null, true, null, 1);
        this.startServers(0);
        ConnectionFactory connectionFactory = this.createFactory(this.protocol, false, "localhost", 61616, "test", null, null);
        this.keys.clear();
        try (Connection connection = connectionFactory.createConnection();){
            connection.start();
        }
        Assertions.assertEquals((int)1, (int)this.keys.size());
        Assertions.assertEquals((Object)"test", (Object)this.keys.get(0));
    }

    @Override
    protected boolean isForceUniqueStorageManagerIds() {
        return false;
    }

    @TestTemplate
    public void testClientIDKeyOnBackup() throws Exception {
        this.setupPrimaryServerWithDiscovery(0, GROUP_ADDRESS, GROUP_PORT, true, true, false);
        this.setupDiscoveryClusterConnection("cluster0", 0, "dg1", "queues", MessageLoadBalancingType.OFF, 1, true);
        this.setupRouterServerWithCluster(0, KeyType.CLIENT_ID, "FIRST_ELEMENT", null, true, null, 1, "cluster0");
        this.setupBackupServer(1, 0, false, ClusterTestBase.HAType.SharedNothingReplication, true);
        UDPBroadcastEndpointFactory endpoint = new UDPBroadcastEndpointFactory().setGroupAddress(GROUP_ADDRESS).setGroupPort(GROUP_PORT);
        List connectorInfos = this.getServer(1).getConfiguration().getConnectorConfigurations().keySet().stream().collect(Collectors.toList());
        BroadcastGroupConfiguration bcConfig = new BroadcastGroupConfiguration().setName("bg1").setBroadcastPeriod(1000L).setConnectorInfos(connectorInfos).setEndpointFactory((BroadcastEndpointFactory)endpoint);
        DiscoveryGroupConfiguration dcConfig = new DiscoveryGroupConfiguration().setName("dg1").setRefreshTimeout(5000L).setDiscoveryInitialWaitTimeout(5000L).setBroadcastEndpointFactory((BroadcastEndpointFactory)endpoint);
        this.getServer(1).getConfiguration().addBroadcastGroupConfiguration(bcConfig).addDiscoveryGroupConfiguration(dcConfig.getName(), dcConfig);
        this.setupDiscoveryClusterConnection("cluster0", 1, "dg1", "queues", MessageLoadBalancingType.OFF, 1, true);
        this.setupRouterServerWithCluster(1, KeyType.CLIENT_ID, MOCK_POLICY_NAME, null, true, null, 1, "cluster0");
        this.startServers(0, 1);
        KeyTypeTest.waitForTopology(this.getServer(0), 1, 1);
        this.getServer(0).fail(true);
        this.waitForFailoverTopology(1, new int[0]);
        ConnectionFactory connectionFactory = this.createFactory(this.protocol, false, "localhost", 61617, "test", null, null);
        this.keys.clear();
        try (Connection connection = connectionFactory.createConnection();){
            connection.start();
        }
        Assertions.assertEquals((int)1, (int)this.keys.size());
        Assertions.assertEquals((Object)"test", (Object)this.keys.get(0));
    }

    @TestTemplate
    public void testSNIHostKey() throws Exception {
        String localHostname = "localhost.localdomain";
        if (!this.checkLocalHostname(localHostname) && !this.checkLocalHostname(localHostname = "artemis.localtest.me")) {
            localHostname = "localhost";
            Assumptions.assumeTrue(("CORE".equals(this.protocol) && this.checkLocalHostname(localHostname) ? (byte)1 : 0) != 0);
        }
        this.setupPrimaryServerWithDiscovery(0, GROUP_ADDRESS, GROUP_PORT, true, true, false);
        this.getDefaultServerAcceptor(0).getParams().put("sslEnabled", true);
        this.getDefaultServerAcceptor(0).getParams().put("keyStorePath", "server-keystore.jks");
        this.getDefaultServerAcceptor(0).getParams().put("keyStorePassword", "securepass");
        this.setupRouterServerWithDiscovery(0, KeyType.SNI_HOST, MOCK_POLICY_NAME, null, true, null, 1);
        this.startServers(0);
        ConnectionFactory connectionFactory = this.createFactory(this.protocol, true, localHostname, 61616, null, null, null);
        try (Connection connection = connectionFactory.createConnection();){
            connection.start();
        }
        Assertions.assertEquals((int)1, (int)this.keys.size());
        Assertions.assertEquals((Object)localHostname, (Object)this.keys.get(0));
    }

    @TestTemplate
    public void testSourceIPKey() throws Exception {
        this.setupPrimaryServerWithDiscovery(0, GROUP_ADDRESS, GROUP_PORT, true, true, false);
        this.setupRouterServerWithDiscovery(0, KeyType.SOURCE_IP, MOCK_POLICY_NAME, null, true, null, 1);
        this.startServers(0);
        ConnectionFactory connectionFactory = this.createFactory(this.protocol, false, "localhost", 61616, null, null, null);
        try (Connection connection = connectionFactory.createConnection();){
            connection.start();
        }
        Assertions.assertEquals((int)1, (int)this.keys.size());
        Assertions.assertEquals((Object)InetAddress.getLoopbackAddress().getHostAddress(), (Object)this.keys.get(0));
    }

    @TestTemplate
    public void testUserNameKey() throws Exception {
        this.setupPrimaryServerWithDiscovery(0, GROUP_ADDRESS, GROUP_PORT, true, true, false);
        this.setupRouterServerWithDiscovery(0, KeyType.USER_NAME, MOCK_POLICY_NAME, null, true, null, 1);
        this.startServers(0);
        ConnectionFactory connectionFactory = this.createFactory(this.protocol, false, "localhost", 61616, null, "admin", "admin");
        try (Connection connection = connectionFactory.createConnection();){
            connection.start();
        }
        Assertions.assertEquals((int)1, (int)this.keys.size());
        Assertions.assertEquals((Object)"admin", (Object)this.keys.get(0));
    }

    @TestTemplate
    public void testRoleNameKeyLocalTarget() throws Exception {
        Connection connection2;
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager("PropertiesLogin");
        this.servers[0] = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultConfig(true).setSecurityEnabled(true), (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, (boolean)false));
        this.setupRouterServerWithLocalTarget(0, KeyType.ROLE_NAME, "b", "b");
        HierarchicalRepository securityRepository = this.servers[0].getSecurityRepository();
        Role role = new Role("b", true, true, true, true, true, true, false, false, true, true, false, false);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(role);
        securityRepository.addMatch("ActiveMQ.Advisory.#", roles);
        this.startServers(0);
        boolean noRetriesSuchThatWeGetAnErrorOnRejection = false;
        ConnectionFactory connectionFactory = this.createFactory(this.protocol, false, "localhost", 61616, null, "a", "a", 0);
        try {
            connection2 = connectionFactory.createConnection();
            try {
                connection2.start();
                Assertions.fail((String)"Expect to be rejected as not in role b");
            }
            finally {
                if (connection2 != null) {
                    connection2.close();
                }
            }
        }
        catch (Exception connection2) {
            // empty catch block
        }
        connectionFactory = this.createFactory(this.protocol, false, "localhost", 61616, null, "b", "b");
        connection2 = connectionFactory.createConnection();
        try {
            connection2.start();
        }
        finally {
            if (connection2 != null) {
                connection2.close();
            }
        }
    }

    private boolean checkLocalHostname(String host) {
        try {
            return InetAddress.getByName(host).isLoopbackAddress();
        }
        catch (UnknownHostException ignore) {
            return false;
        }
    }

    static {
        URL resource;
        String path = System.getProperty("java.security.auth.login.config");
        if (path == null && (resource = SecurityTest.class.getClassLoader().getResource("login.config")) != null) {
            path = resource.getFile();
            System.setProperty("java.security.auth.login.config", path);
        }
    }
}

