/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp.client;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpResource;
import org.apache.activemq.transport.amqp.client.AmqpSupport;
import org.apache.activemq.transport.amqp.client.AmqpValidator;
import org.apache.activemq.transport.amqp.client.util.AsyncResult;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Endpoint;
import org.apache.qpid.proton.engine.EndpointState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AmqpAbstractResource<E extends Endpoint>
implements AmqpResource {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected AsyncResult openRequest;
    protected AsyncResult closeRequest;
    private AmqpValidator amqpStateInspector;
    private E endpoint;

    @Override
    public void open(AsyncResult request) {
        this.openRequest = request;
        this.doOpen();
        this.getEndpoint().setContext((Object)this);
    }

    @Override
    public boolean isOpen() {
        return this.getEndpoint().getRemoteState() == EndpointState.ACTIVE;
    }

    @Override
    public void opened() {
        if (this.openRequest != null) {
            this.openRequest.onSuccess();
            this.openRequest = null;
        }
    }

    @Override
    public void detach(AsyncResult request) {
        if (this.getEndpoint().getLocalState() == EndpointState.CLOSED || this.getEndpoint().getRemoteState() == EndpointState.CLOSED) {
            if (this.getEndpoint().getLocalState() != EndpointState.CLOSED) {
                this.doDetach();
                this.getEndpoint().free();
            }
            request.onSuccess();
        } else {
            this.closeRequest = request;
            this.doDetach();
        }
    }

    @Override
    public void close(AsyncResult request) {
        if (this.getEndpoint().getLocalState() == EndpointState.CLOSED || this.getEndpoint().getRemoteState() == EndpointState.CLOSED) {
            if (this.getEndpoint().getLocalState() != EndpointState.CLOSED) {
                this.doClose();
                this.getEndpoint().free();
            }
            request.onSuccess();
        } else {
            this.closeRequest = request;
            this.doClose();
        }
    }

    @Override
    public boolean isClosed() {
        return this.getEndpoint().getLocalState() == EndpointState.CLOSED;
    }

    @Override
    public void closed() {
        this.getEndpoint().close();
        this.getEndpoint().free();
        if (this.closeRequest != null) {
            this.closeRequest.onSuccess();
            this.closeRequest = null;
        }
    }

    @Override
    public void failed() {
        this.failed(new Exception("Remote request failed."));
    }

    @Override
    public void failed(Exception cause) {
        if (this.openRequest != null) {
            if (this.endpoint != null) {
                this.endpoint.close();
            }
            this.openRequest.onFailure(cause);
            this.openRequest = null;
        }
        if (this.closeRequest != null) {
            this.closeRequest.onFailure(cause);
            this.closeRequest = null;
        }
    }

    @Override
    public void remotelyClosed(AmqpConnection connection) {
        Exception error = AmqpSupport.convertToException(this.getEndpoint().getRemoteCondition());
        if (this.endpoint != null) {
            this.endpoint.close();
        }
        logger.info("Resource {} was remotely closed", (Object)this);
        connection.fireClientException(error);
    }

    @Override
    public void locallyClosed(AmqpConnection connection, Exception error) {
        if (this.endpoint != null) {
            this.endpoint.close();
        }
        logger.info("Resource {} was locally closed", (Object)this);
        connection.fireClientException(error);
    }

    public E getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(E endpoint) {
        this.endpoint = endpoint;
    }

    public AmqpValidator getStateInspector() {
        return this.amqpStateInspector;
    }

    public void setStateInspector(AmqpValidator stateInspector) {
        if (stateInspector == null) {
            stateInspector = new AmqpValidator();
        }
        this.amqpStateInspector = stateInspector;
    }

    public EndpointState getLocalState() {
        if (this.getEndpoint() == null) {
            return EndpointState.UNINITIALIZED;
        }
        return this.getEndpoint().getLocalState();
    }

    public EndpointState getRemoteState() {
        if (this.getEndpoint() == null) {
            return EndpointState.UNINITIALIZED;
        }
        return this.getEndpoint().getRemoteState();
    }

    public boolean hasRemoteError() {
        return this.getEndpoint().getRemoteCondition().getCondition() != null;
    }

    @Override
    public void processRemoteOpen(AmqpConnection connection) throws IOException {
        this.doOpenInspection();
        this.doOpenCompletion();
    }

    @Override
    public void processRemoteDetach(AmqpConnection connection) throws IOException {
        this.doDetachedInspection();
        if (this.isAwaitingClose()) {
            logger.debug("{} is now closed: ", (Object)this);
            this.closed();
        } else {
            this.remotelyClosed(connection);
        }
    }

    @Override
    public void processRemoteClose(AmqpConnection connection) throws IOException {
        this.doClosedInspection();
        if (this.isAwaitingClose()) {
            logger.debug("{} is now closed: ", (Object)this);
            this.closed();
        } else if (this.isAwaitingOpen()) {
            logger.warn("Open of {} failed: ", (Object)this);
            Exception openError = this.hasRemoteError() ? AmqpSupport.convertToException(this.getEndpoint().getRemoteCondition()) : this.getOpenAbortException();
            this.failed(openError);
        } else {
            this.remotelyClosed(connection);
        }
    }

    @Override
    public void processDeliveryUpdates(AmqpConnection connection, Delivery delivery) throws IOException {
    }

    @Override
    public void processFlowUpdates(AmqpConnection connection) throws IOException {
    }

    protected void doOpen() {
        this.getEndpoint().open();
    }

    protected void doClose() {
        this.getEndpoint().close();
    }

    protected void doDetach() {
        throw new UnsupportedOperationException("Endpoint cannot be detached.");
    }

    protected void doOpenCompletion() {
        logger.debug("{} is now open: ", (Object)this);
        this.opened();
    }

    protected Exception getOpenAbortException() {
        return new IOException("Open failed unexpectedly.");
    }

    protected abstract void doOpenInspection();

    protected abstract void doClosedInspection();

    protected void doDetachedInspection() {
    }

    private boolean isAwaitingOpen() {
        return this.openRequest != null;
    }

    private boolean isAwaitingClose() {
        return this.closeRequest != null;
    }
}

