/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.security.AccessController;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.controller.ModelControllerClientFactory;
import org.jboss.as.controller.ProcessStateNotifier;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.ContentRepositoryCleaner;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class ContentCleanerService
implements Service {
    @Deprecated(forRemoval=true)
    private static final String UNSUPPORTED_PROPERTY = "org.wildfly.unsupported.content.repository.obsolescence";
    public static final long DEFAULT_INTERVAL = System.getSecurityManager() == null ? Long.getLong("org.wildfly.unsupported.content.repository.obsolescence", 300000L).longValue() : AccessController.doPrivileged(() -> Long.getLong(UNSUPPORTED_PROPERTY, 300000L)).longValue();
    private static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"content-repository-cleaner"});
    private final Supplier<ModelControllerClientFactory> clientFactorySupplier;
    private final Supplier<ScheduledExecutorService> scheduledExecutorSupplier;
    private final Supplier<ProcessStateNotifier> processStateNotifierSupplier;
    private final Supplier<ExecutorService> executorServiceSupplier;
    private ContentRepositoryCleaner deploymentContentCleaner;
    private final long interval = DEFAULT_INTERVAL;
    private final boolean server;
    private final TimeUnit unit = TimeUnit.MILLISECONDS;

    public static void addService(ServiceTarget serviceTarget, ServiceName clientFactoryService, ServiceName scheduledExecutorServiceName) {
        ServiceBuilder builder = serviceTarget.addService(SERVICE_NAME);
        Supplier mccfSupplier = builder.requires(clientFactoryService);
        Supplier cpsnSupplier = builder.requires(ControlledProcessStateService.INTERNAL_SERVICE_NAME);
        Supplier sesSupplier = builder.requires(scheduledExecutorServiceName);
        Supplier<ExecutorService> esSupplier = Services.requireServerExecutor(builder);
        builder.setInstance((Service)new ContentCleanerService(true, mccfSupplier, cpsnSupplier, sesSupplier, esSupplier));
        builder.install();
    }

    public static void addServiceOnHostController(ServiceTarget serviceTarget, ServiceName hostControllerServiceName, ServiceName clientFactoryServiceName, ServiceName hostControllerExecutorServiceName, ServiceName scheduledExecutorServiceName) {
        ServiceBuilder builder = serviceTarget.addService(SERVICE_NAME);
        Supplier mccfSupplier = builder.requires(clientFactoryServiceName);
        Supplier cpsnSupplier = builder.requires(ControlledProcessStateService.INTERNAL_SERVICE_NAME);
        Supplier sesSupplier = builder.requires(scheduledExecutorServiceName);
        Supplier esSupplier = builder.requires(hostControllerExecutorServiceName);
        builder.setInstance((Service)new ContentCleanerService(false, mccfSupplier, cpsnSupplier, sesSupplier, esSupplier));
        builder.install();
    }

    private ContentCleanerService(boolean server, Supplier<ModelControllerClientFactory> clientFactorySupplier, Supplier<ProcessStateNotifier> processStateNotifierSupplier, Supplier<ScheduledExecutorService> scheduledExecutorSupplier, Supplier<ExecutorService> executorServiceSupplier) {
        this.server = server;
        this.clientFactorySupplier = clientFactorySupplier;
        this.processStateNotifierSupplier = processStateNotifierSupplier;
        this.scheduledExecutorSupplier = scheduledExecutorSupplier;
        this.executorServiceSupplier = executorServiceSupplier;
    }

    public synchronized void start(StartContext context) throws StartException {
        this.deploymentContentCleaner = new ContentRepositoryCleaner(this.clientFactorySupplier.get().createSuperUserClient((Executor)this.executorServiceSupplier.get(), false), this.processStateNotifierSupplier.get(), this.scheduledExecutorSupplier.get(), this.unit.toMillis(this.interval), this.server);
        this.deploymentContentCleaner.startScan();
    }

    public synchronized void stop(StopContext context) {
        ContentRepositoryCleaner contentCleaner = this.deploymentContentCleaner;
        this.deploymentContentCleaner = null;
        contentCleaner.stopScan();
    }
}

