/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.servlet.api.SessionConfigWrapper;
import jakarta.servlet.ServletContext;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.web.session.AffinityLocator;
import org.jboss.as.web.session.SessionIdentifierCodec;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.server.deployment.DeploymentConfiguration;
import org.wildfly.clustering.server.immutable.Immutability;
import org.wildfly.clustering.session.SessionManagerFactory;
import org.wildfly.clustering.web.container.SessionManagementProvider;
import org.wildfly.clustering.web.container.SessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.container.WebDeploymentConfiguration;
import org.wildfly.clustering.web.service.WebDeploymentServiceDescriptor;
import org.wildfly.clustering.web.service.session.DistributableSessionManagementConfiguration;
import org.wildfly.clustering.web.service.session.DistributableSessionManagementProvider;
import org.wildfly.clustering.web.undertow.routing.DistributableAffinityLocator;
import org.wildfly.clustering.web.undertow.routing.DistributableSessionIdentifierCodec;
import org.wildfly.clustering.web.undertow.session.DistributableSessionManagerFactory;
import org.wildfly.clustering.web.undertow.session.SessionManagerFactoryConfigurationAdapter;
import org.wildfly.clustering.web.undertow.session.WebDeploymentConfigurationAdapter;
import org.wildfly.extension.undertow.CookieConfig;
import org.wildfly.extension.undertow.session.AffinitySessionConfigWrapper;
import org.wildfly.extension.undertow.session.CodecSessionConfigWrapper;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.service.DeploymentServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class UndertowDistributableSessionManagementProvider
implements SessionManagementProvider {
    private final DistributableSessionManagementProvider provider;
    private final Immutability immutability;

    public UndertowDistributableSessionManagementProvider(DistributableSessionManagementProvider provider, Immutability immutability) {
        this.provider = provider;
        this.immutability = immutability;
    }

    public DeploymentServiceInstaller getSessionManagerFactoryServiceInstaller(ServiceName name, final SessionManagerFactoryConfiguration configuration) {
        DeploymentServiceInstaller providedInstaller = this.provider.getSessionManagerFactoryServiceInstaller(new SessionManagerFactoryConfigurationAdapter<DistributableSessionManagementConfiguration>(configuration, this.provider.getSessionManagementConfiguration(), this.immutability));
        Function<SessionManagerFactory<ServletContext, Map<String, Object>>, io.undertow.servlet.api.SessionManagerFactory> mapper = new Function<SessionManagerFactory<ServletContext, Map<String, Object>>, io.undertow.servlet.api.SessionManagerFactory>(){

            @Override
            public io.undertow.servlet.api.SessionManagerFactory apply(SessionManagerFactory<ServletContext, Map<String, Object>> factory) {
                return new DistributableSessionManagerFactory(factory, configuration);
            }
        };
        DeploymentServiceInstaller installer = (DeploymentServiceInstaller)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((ServiceDependency)ServiceDependency.on((UnaryServiceDescriptor)WebDeploymentServiceDescriptor.SESSION_MANAGER_FACTORY, (String)configuration.getDeploymentName()).map((Function)mapper)).provides(name)).build();
        return DeploymentServiceInstaller.combine((DeploymentServiceInstaller[])new DeploymentServiceInstaller[]{providedInstaller, installer});
    }

    public DeploymentServiceInstaller getSessionAffinityServiceInstaller(DeploymentPhaseContext context, ServiceName name, WebDeploymentConfiguration configuration) {
        DeploymentServiceInstaller locatorInstaller = this.provider.getRouteLocatorServiceInstaller(context, (DeploymentConfiguration)new WebDeploymentConfigurationAdapter(configuration));
        final ServiceDependency locator = ServiceDependency.on((UnaryServiceDescriptor)WebDeploymentServiceDescriptor.ROUTE_LOCATOR, (String)configuration.getDeploymentName());
        Function<CookieConfig, SessionConfigWrapper> wrapperFactory = new Function<CookieConfig, SessionConfigWrapper>(){

            @Override
            public SessionConfigWrapper apply(CookieConfig config) {
                UnaryOperator routeLocator = (UnaryOperator)locator.get();
                DistributableSessionIdentifierCodec codec = new DistributableSessionIdentifierCodec(routeLocator);
                return config != null ? new AffinitySessionConfigWrapper(config, (AffinityLocator)new DistributableAffinityLocator(routeLocator)) : new CodecSessionConfigWrapper((SessionIdentifierCodec)codec);
            }
        };
        DeploymentServiceInstaller wrapperFactoryInstaller = (DeploymentServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((Supplier)org.wildfly.clustering.function.Supplier.of((Object)wrapperFactory)).requires((Consumer)locator)).provides(name)).build();
        return DeploymentServiceInstaller.combine((DeploymentServiceInstaller[])new DeploymentServiceInstaller[]{locatorInstaller, wrapperFactoryInstaller});
    }
}

