/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.xml;

import java.util.concurrent.atomic.AtomicBoolean;
import org.wildfly.common.annotation.NotNull;
import org.wildfly.common.xml.Log;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class XMLReaderFactoryUtil {
    private static final AtomicBoolean TO_BE_LOGGED = new AtomicBoolean(true);

    @NotNull
    public static XMLReader create() throws SAXException {
        XMLReader instance;
        block11: {
            boolean toBeLogged;
            block10: {
                block9: {
                    block8: {
                        instance = XMLReaderFactory.createXMLReader();
                        toBeLogged = TO_BE_LOGGED.compareAndSet(true, false);
                        try {
                            instance.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                        }
                        catch (SAXNotRecognizedException | SAXNotSupportedException e) {
                            if (!toBeLogged) break block8;
                            Log.XML_FACTORY_LOGGER.xmlFactoryPropertyNotSupported(e, "http://apache.org/xml/features/disallow-doctype-decl", instance.getClass().getCanonicalName());
                        }
                    }
                    try {
                        instance.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                    }
                    catch (SAXNotRecognizedException | SAXNotSupportedException e) {
                        if (!toBeLogged) break block9;
                        Log.XML_FACTORY_LOGGER.xmlFactoryPropertyNotSupported(e, "http://apache.org/xml/features/nonvalidating/load-external-dtd", instance.getClass().getCanonicalName());
                    }
                }
                try {
                    instance.setFeature("http://xml.org/sax/features/external-general-entities", false);
                }
                catch (SAXNotRecognizedException | SAXNotSupportedException e) {
                    if (!toBeLogged) break block10;
                    Log.XML_FACTORY_LOGGER.xmlFactoryPropertyNotSupported(e, "http://xml.org/sax/features/external-general-entities", instance.getClass().getCanonicalName());
                }
            }
            try {
                instance.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            }
            catch (SAXNotRecognizedException | SAXNotSupportedException e) {
                if (!toBeLogged) break block11;
                Log.XML_FACTORY_LOGGER.xmlFactoryPropertyNotSupported(e, "http://xml.org/sax/features/external-parameter-entities", instance.getClass().getCanonicalName());
            }
        }
        return instance;
    }

    private XMLReaderFactoryUtil() {
        throw new IllegalStateException("No instance");
    }
}

