/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.OptionalInt;
import java.util.function.Supplier;
import org.wildfly.clustering.context.Context;
import org.wildfly.clustering.marshalling.ByteBufferInputStream;
import org.wildfly.clustering.marshalling.ByteBufferOutputStream;
import org.wildfly.clustering.marshalling.Logger;
import org.wildfly.clustering.marshalling.Marshaller;

public interface ByteBufferMarshaller
extends Marshaller<Object, ByteBuffer> {
    public Object readFrom(InputStream var1) throws IOException;

    public void writeTo(OutputStream var1, Object var2) throws IOException;

    @Override
    default public Object read(ByteBuffer buffer) throws IOException {
        try (Context context = this.getContextProvider().get();){
            Object object;
            try (ByteBufferInputStream input = new ByteBufferInputStream(buffer);){
                object = this.readFrom(input);
            }
            return object;
        }
    }

    @Override
    default public ByteBuffer write(Object object) throws IOException {
        try (Context context = this.getContextProvider().get();){
            ByteBuffer byteBuffer;
            OptionalInt size = this.size(object);
            try (ByteBufferOutputStream output = new ByteBufferOutputStream(size);){
                this.writeTo(output, object);
                ByteBuffer buffer = output.getBuffer();
                if (Logger.INSTANCE.isLoggable(System.Logger.Level.DEBUG)) {
                    if (size.isPresent()) {
                        int actualSize;
                        int predictedSize = size.getAsInt();
                        if (predictedSize < (actualSize = buffer.limit() - buffer.arrayOffset())) {
                            Logger.INSTANCE.log(System.Logger.Level.DEBUG, "Buffer size prediction too small for {0} ({1}), predicted = {3}, actual = {4}", object, object != null ? object.getClass().getCanonicalName() : null, predictedSize, actualSize);
                        }
                    } else {
                        Logger.INSTANCE.log(System.Logger.Level.DEBUG, "Buffer size prediction missing for {0} ({1})", object, object != null ? object.getClass().getCanonicalName() : null);
                    }
                }
                byteBuffer = buffer;
            }
            return byteBuffer;
        }
    }

    default public OptionalInt size(Object object) {
        return OptionalInt.empty();
    }

    default public Supplier<Context> getContextProvider() {
        return org.wildfly.clustering.function.Supplier.of((Object)Context.EMPTY);
    }
}

