/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import org.jboss.as.clustering.jgroups.ProtocolPropertiesRepository;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.clustering.jgroups.subsystem.ChannelResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsBindingFactory;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsExtension;
import org.jboss.as.clustering.jgroups.subsystem.StackResourceDefinitionRegistrar;
import org.jboss.as.clustering.naming.BinderServiceInstaller;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.ServiceNameFactory;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.SubsystemResourceRegistration;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ParentResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.SubsystemResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jgroups.JChannel;
import org.jgroups.Version;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.conf.XmlConfigurator;
import org.jgroups.stack.Protocol;
import org.wildfly.clustering.jgroups.spi.ChannelConfiguration;
import org.wildfly.clustering.jgroups.spi.ForkChannelFactory;
import org.wildfly.clustering.jgroups.spi.JGroupsServiceDescriptor;
import org.wildfly.clustering.server.service.ClusteringServiceDescriptor;
import org.wildfly.clustering.server.service.DefaultChannelServiceInstallerProvider;
import org.wildfly.clustering.server.service.LegacyClusteringServiceDescriptor;
import org.wildfly.clustering.server.service.ProvidedUnaryServiceInstallerProvider;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.ManagementResourceRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrationContext;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.SubsystemResourceDefinitionRegistrar;
import org.wildfly.subsystem.resource.capability.CapabilityReference;
import org.wildfly.subsystem.resource.capability.CapabilityReferenceAttributeDefinition;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public class JGroupsSubsystemResourceDefinitionRegistrar
implements SubsystemResourceDefinitionRegistrar,
BiPredicate<OperationContext, Resource>,
ResourceServiceConfigurator {
    public static final SubsystemResourceRegistration REGISTRATION = SubsystemResourceRegistration.of((String)"jgroups");
    static final ParentResourceDescriptionResolver RESOLVER = new SubsystemResourceDescriptionResolver(REGISTRATION.getName(), JGroupsSubsystemResourceDefinitionRegistrar.class);
    static final RuntimeCapability<Void> DEFAULT_CHANNEL_CAPABILITY = RuntimeCapability.Builder.of((NullaryServiceDescriptor)JGroupsServiceDescriptor.DEFAULT_CHANNEL).build();
    static final CapabilityReferenceAttributeDefinition<JChannel> DEFAULT_CHANNEL = ((CapabilityReferenceAttributeDefinition.Builder)((CapabilityReferenceAttributeDefinition.Builder)((CapabilityReferenceAttributeDefinition.Builder)new CapabilityReferenceAttributeDefinition.Builder("default-channel", CapabilityReference.builder(DEFAULT_CHANNEL_CAPABILITY, (UnaryServiceDescriptor)JGroupsServiceDescriptor.CHANNEL).build()).setXmlName("default")).setAttributeGroup("channels")).setRequired(false)).build();
    private static final RuntimeCapability<Void> DEFAULT_CHANNEL_CONFIGURATION_CAPABILITY = RuntimeCapability.Builder.of((NullaryServiceDescriptor)ChannelConfiguration.DEFAULT_SERVICE_DESCRIPTOR).build();
    private static final RuntimeCapability<Void> DEFAULT_CHANNEL_FACTORY_CAPABILITY = RuntimeCapability.Builder.of((NullaryServiceDescriptor)ForkChannelFactory.DEFAULT_SERVICE_DESCRIPTOR).build();
    private static final String PROTOCOL_DEFAULTS_RESOURCE = "jgroups-defaults.xml";

    private static ProtocolStackConfigurator loadDefaultProtocolStackConfigurator() throws IllegalStateException {
        XmlConfigurator xmlConfigurator;
        block8: {
            URL url = JGroupsSubsystemResourceDefinitionRegistrar.find(PROTOCOL_DEFAULTS_RESOURCE, JGroupsExtension.class.getClassLoader());
            JGroupsLogger.ROOT_LOGGER.debugf("Loading JGroups protocol defaults from %s", url.toString());
            InputStream input = url.openStream();
            try {
                xmlConfigurator = XmlConfigurator.getInstance((InputStream)input);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(JGroupsLogger.ROOT_LOGGER.parserFailure(url));
                }
            }
            input.close();
        }
        return xmlConfigurator;
    }

    private static URL find(String resource, ClassLoader ... loaders) {
        for (ClassLoader loader : loaders) {
            URL url;
            if (loader == null || (url = loader.getResource(resource)) == null) continue;
            return url;
        }
        throw new IllegalArgumentException(JGroupsLogger.ROOT_LOGGER.notFound(resource));
    }

    @Override
    public boolean test(OperationContext context, Resource resource) {
        return resource.getModel().hasDefined(DEFAULT_CHANNEL.getName());
    }

    public ManagementResourceRegistration register(SubsystemRegistration parent, ManagementResourceRegistrationContext context) {
        RuntimeCapability defaultCommandDispatcherFactory = RuntimeCapability.Builder.of((NullaryServiceDescriptor)ClusteringServiceDescriptor.DEFAULT_COMMAND_DISPATCHER_FACTORY).setAllowMultipleRegistrations(true).build();
        RuntimeCapability defaultLegacyCommandDispatcherFactory = RuntimeCapability.Builder.of((NullaryServiceDescriptor)LegacyClusteringServiceDescriptor.DEFAULT_COMMAND_DISPATCHER_FACTORY).setAllowMultipleRegistrations(true).build();
        RuntimeCapability defaultGroup = RuntimeCapability.Builder.of((NullaryServiceDescriptor)ClusteringServiceDescriptor.DEFAULT_GROUP).setAllowMultipleRegistrations(true).build();
        RuntimeCapability defaultLegacyGroup = RuntimeCapability.Builder.of((NullaryServiceDescriptor)LegacyClusteringServiceDescriptor.DEFAULT_GROUP).setAllowMultipleRegistrations(true).build();
        ResourceDescriptor descriptor = ((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)ResourceDescriptor.builder((ResourceDescriptionResolver)RESOLVER).addAttributes(List.of(DEFAULT_CHANNEL))).addCapabilities(List.of(DEFAULT_CHANNEL_CAPABILITY, DEFAULT_CHANNEL_CONFIGURATION_CAPABILITY, DEFAULT_CHANNEL_FACTORY_CAPABILITY, defaultCommandDispatcherFactory, defaultLegacyCommandDispatcherFactory, defaultGroup, defaultLegacyGroup), (BiPredicate)this)).withRuntimeHandler(ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this))).build();
        ManagementResourceRegistration registration = parent.registerSubsystemModel(ResourceDefinition.builder((ResourceRegistration)REGISTRATION, (ResourceDescriptionResolver)RESOLVER).build());
        ManagementResourceRegistrar.of((ResourceDescriptor)descriptor).register(registration);
        new ChannelResourceDefinitionRegistrar().register(registration, context);
        new StackResourceDefinitionRegistrar().register(registration, context);
        return registration;
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        JGroupsLogger.ROOT_LOGGER.activatingSubsystem(Version.printVersion());
        PathAddress address = context.getCurrentAddress();
        if (context.getProcessType().isServer() && !context.isBooting() && context.readResourceFromRoot(address.getParent(), false).hasChild(SubsystemResourceRegistration.of((String)"infinispan").getPathElement())) {
            context.addStep((ctx, operation) -> {
                ctx.reloadRequired();
                ctx.completeStep(OperationContext.RollbackHandler.REVERT_RELOAD_REQUIRED_ROLLBACK_HANDLER);
            }, OperationContext.Stage.RUNTIME);
            return ResourceServiceInstaller.combine((ResourceServiceInstaller[])new ResourceServiceInstaller[0]);
        }
        LinkedList<Object> installers = new LinkedList<Object>();
        Supplier<ProtocolPropertiesRepository> factory = new Supplier<ProtocolPropertiesRepository>(){

            @Override
            public ProtocolPropertiesRepository get() {
                ProtocolStackConfigurator configurator = JGroupsSubsystemResourceDefinitionRegistrar.loadDefaultProtocolStackConfigurator();
                final IdentityHashMap protocolProperties = new IdentityHashMap();
                try {
                    for (ProtocolConfiguration config : configurator.getProtocolStack()) {
                        String protocolClassName = "org.jgroups.protocols." + config.getProtocolName();
                        Class<Protocol> protocolClass = Protocol.class.getClassLoader().loadClass(protocolClassName).asSubclass(Protocol.class);
                        protocolProperties.put(protocolClass, Collections.unmodifiableMap(config.getProperties()));
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException(e);
                }
                return new ProtocolPropertiesRepository(){

                    @Override
                    public Map<String, String> getProperties(Class<? extends Protocol> protocolClass) {
                        return protocolProperties.getOrDefault(protocolClass, Map.of());
                    }
                };
            }
        };
        installers.add((ResourceServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((Supplier)factory).provides(ServiceNameFactory.resolveServiceName(ProtocolPropertiesRepository.SERVICE_DESCRIPTOR))).blocking()).build());
        String defaultChannel = DEFAULT_CHANNEL.resolveModelAttribute(context, model).asStringOrNull();
        if (defaultChannel != null) {
            installers.add((ResourceServiceInstaller)CapabilityServiceInstaller.builder(DEFAULT_CHANNEL_CAPABILITY, (ServiceDependency)ServiceDependency.on((UnaryServiceDescriptor)JGroupsServiceDescriptor.CHANNEL, (String)defaultChannel)).build());
            installers.add((ResourceServiceInstaller)CapabilityServiceInstaller.builder(DEFAULT_CHANNEL_CONFIGURATION_CAPABILITY, (ServiceDependency)ServiceDependency.on((UnaryServiceDescriptor)ChannelConfiguration.SERVICE_DESCRIPTOR, (String)defaultChannel)).build());
            installers.add((ResourceServiceInstaller)CapabilityServiceInstaller.builder(DEFAULT_CHANNEL_FACTORY_CAPABILITY, (ServiceDependency)ServiceDependency.on((UnaryServiceDescriptor)ForkChannelFactory.SERVICE_DESCRIPTOR, (String)defaultChannel)).build());
            if (!defaultChannel.equals("default")) {
                installers.add(new BinderServiceInstaller(JGroupsBindingFactory.CHANNEL.apply("default"), context.getCapabilityServiceName(JGroupsServiceDescriptor.CHANNEL, defaultChannel)));
                installers.add(new BinderServiceInstaller(JGroupsBindingFactory.CHANNEL_FACTORY.apply("default"), context.getCapabilityServiceName(ForkChannelFactory.SERVICE_DESCRIPTOR, defaultChannel)));
            }
            new ProvidedUnaryServiceInstallerProvider(DefaultChannelServiceInstallerProvider.class, DefaultChannelServiceInstallerProvider.class.getClassLoader()).apply(defaultChannel).forEach(installers::add);
        }
        return ResourceServiceInstaller.combine(installers);
    }
}

