/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.function.Function;
import org.jboss.as.clustering.controller.DurationAttributeDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.ThreadPoolConfiguration;
import org.jboss.as.clustering.jgroups.subsystem.ThreadPoolResourceRegistration;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.capability.UnaryCapabilityNameResolver;
import org.jboss.as.controller.descriptions.ParentResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.ChildResourceDefinitionRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrationContext;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public enum ThreadPoolResourceDefinitionRegistrar implements ChildResourceDefinitionRegistrar,
ThreadPoolResourceRegistration,
ResourceServiceConfigurator
{
    DEFAULT("default", 0, 200, Duration.ofMinutes(1L));

    static final PathElement WILDCARD_PATH;
    private final PathElement path;
    private final RuntimeCapability<Void> capability;
    private final AttributeDefinition minThreads;
    private final AttributeDefinition maxThreads;
    private final DurationAttributeDefinition keepAlive;

    private static PathElement pathElement(String name) {
        return PathElement.pathElement((String)"thread-pool", (String)name);
    }

    private ThreadPoolResourceDefinitionRegistrar(String name, int defaultMinThreads, int defaultMaxThreads, Duration defaultKeepAlive) {
        this.path = ThreadPoolResourceDefinitionRegistrar.pathElement(name);
        this.capability = RuntimeCapability.Builder.of((UnaryServiceDescriptor)this).setDynamicNameMapper((Function)UnaryCapabilityNameResolver.GRANDPARENT).build();
        this.minThreads = ThreadPoolResourceDefinitionRegistrar.createAttribute("min-threads", ModelType.INT, new ModelNode(defaultMinThreads), IntRangeValidator.NON_NEGATIVE);
        this.maxThreads = ThreadPoolResourceDefinitionRegistrar.createAttribute("max-threads", ModelType.INT, new ModelNode(defaultMaxThreads), IntRangeValidator.NON_NEGATIVE);
        this.keepAlive = new DurationAttributeDefinition.Builder("keepalive-time", ChronoUnit.MILLIS).setDefaultValue(defaultKeepAlive).build();
    }

    private static AttributeDefinition createAttribute(String name, ModelType type, ModelNode defaultValue, ParameterValidator validator) {
        return ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(false)).setDefaultValue(defaultValue)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setValidator(validator)).build();
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent, ManagementResourceRegistrationContext context) {
        ParentResourceDescriptionResolver resolver = JGroupsSubsystemResourceDefinitionRegistrar.RESOLVER.createChildResolver(this.path, WILDCARD_PATH);
        ResourceDescriptor descriptor = ((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)ResourceDescriptor.builder((ResourceDescriptionResolver)resolver).addAttributes(List.of(this.getMinThreads(), this.getMaxThreads(), this.getKeepAlive()))).addCapability(this.capability)).withRuntimeHandler(ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this))).build();
        ManagementResourceRegistration registration = parent.registerSubModel(ResourceDefinition.builder((ResourceRegistration)this, (ResourceDescriptionResolver)resolver).build());
        ManagementResourceRegistrar.of((ResourceDescriptor)descriptor).register(registration);
        return registration;
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final int minThreads = this.minThreads.resolveModelAttribute(context, model).asInt();
        final int maxThreads = this.maxThreads.resolveModelAttribute(context, model).asInt();
        final Duration keepAlive = this.keepAlive.resolve(context, model);
        ThreadPoolConfiguration configuration = new ThreadPoolConfiguration(){

            @Override
            public int getMinThreads() {
                return minThreads;
            }

            @Override
            public int getMaxThreads() {
                return maxThreads;
            }

            @Override
            public Duration getKeepAlive() {
                return keepAlive;
            }
        };
        return (ResourceServiceInstaller)CapabilityServiceInstaller.builder(this.capability, (Object)configuration).build();
    }

    @Override
    public AttributeDefinition getMinThreads() {
        return this.minThreads;
    }

    @Override
    public AttributeDefinition getMaxThreads() {
        return this.maxThreads;
    }

    @Override
    public DurationAttributeDefinition getKeepAlive() {
        return this.keepAlive;
    }

    public PathElement getPathElement() {
        return this.path;
    }

    static {
        WILDCARD_PATH = ThreadPoolResourceDefinitionRegistrar.pathElement("*");
    }
}

