/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.jboss.as.clustering.controller.DurationAttributeDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CacheResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.CacheResourceRegistration;
import org.jboss.as.clustering.infinispan.subsystem.JGroupsTransportResourceDefinitionRegistrar;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.capability.UnaryCapabilityNameResolver;
import org.jboss.dmr.ModelNode;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.capability.ResourceCapabilityReference;
import org.wildfly.subsystem.service.ServiceDependency;

public class ClusteredCacheResourceDefinitionRegistrar
extends CacheResourceDefinitionRegistrar {
    static final DurationAttributeDefinition REMOTE_TIMEOUT = new DurationAttributeDefinition.Builder("remote-timeout", ChronoUnit.MILLIS).setDefaultValue(Duration.ofMillis(17500L)).build();

    public ClusteredCacheResourceDefinitionRegistrar(CacheResourceRegistration registration) {
        super(registration);
    }

    @Override
    public ResourceDescriptor.Builder apply(ResourceDescriptor.Builder builder) {
        return (ResourceDescriptor.Builder)((ResourceDescriptor.Builder)super.apply(builder).addAttributes(List.of(REMOTE_TIMEOUT))).addResourceCapabilityReference(ResourceCapabilityReference.builder((RuntimeCapability)CAPABILITY, JGroupsTransportResourceDefinitionRegistrar.JGROUPS).withRequirementNameResolver((Function)UnaryCapabilityNameResolver.PARENT).build());
    }

    @Override
    public ServiceDependency<ConfigurationBuilder> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        final Duration remoteTimeout = REMOTE_TIMEOUT.resolve(context, model);
        return super.resolve(context, model).map((Function)new UnaryOperator<ConfigurationBuilder>(){

            @Override
            public ConfigurationBuilder apply(ConfigurationBuilder builder) {
                builder.clustering().remoteTimeout(remoteTimeout.toMillis(), TimeUnit.MILLISECONDS);
                return builder;
            }
        });
    }
}

