/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.function.Function;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.jboss.as.clustering.infinispan.persistence.hotrod.HotRodStoreConfiguration;
import org.jboss.as.clustering.infinispan.persistence.hotrod.HotRodStoreConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceRegistration;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.infinispan.client.RemoteCacheContainer;
import org.wildfly.clustering.infinispan.client.service.HotRodCacheConfigurationAttributeGroup;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.service.ServiceDependency;

public class HotRodStoreResourceDefinitionRegistrar
extends StoreResourceDefinitionRegistrar<HotRodStoreConfiguration, HotRodStoreConfigurationBuilder> {
    static final HotRodCacheConfigurationAttributeGroup CACHE_ATTRIBUTE_GROUP = new HotRodCacheConfigurationAttributeGroup(CAPABILITY);

    HotRodStoreResourceDefinitionRegistrar() {
        super(new StoreResourceDefinitionRegistrar.Configurator<HotRodStoreConfiguration, HotRodStoreConfigurationBuilder>(){

            @Override
            public ResourceRegistration getResourceRegistration() {
                return StoreResourceRegistration.HOTROD;
            }

            public ServiceDependency<HotRodStoreConfigurationBuilder> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
                final String cacheConfiguration = CACHE_ATTRIBUTE_GROUP.getCacheAttribute().resolveModelAttribute(context, model).asStringOrNull();
                return CACHE_ATTRIBUTE_GROUP.getContainerAttribute().resolve(context, model).map((Function)new Function<RemoteCacheContainer, HotRodStoreConfigurationBuilder>(){

                    @Override
                    public HotRodStoreConfigurationBuilder apply(RemoteCacheContainer container) {
                        return ((HotRodStoreConfigurationBuilder)new ConfigurationBuilder().persistence().addStore(HotRodStoreConfigurationBuilder.class)).remoteCacheContainer(container).cacheConfiguration(cacheConfiguration);
                    }
                });
            }
        });
    }

    @Override
    public ResourceDescriptor.Builder apply(ResourceDescriptor.Builder builder) {
        return (ResourceDescriptor.Builder)super.apply(builder).addAttributes(CACHE_ATTRIBUTE_GROUP.getAttributes());
    }
}

