/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi.builders;

import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.helpers.queues.Queues;
import io.smallrye.mutiny.operators.AbstractMulti;
import io.smallrye.mutiny.operators.multi.builders.BaseMultiEmitter;
import io.smallrye.mutiny.operators.multi.builders.BufferItemMultiEmitter;
import io.smallrye.mutiny.subscription.BackPressureFailure;
import io.smallrye.mutiny.subscription.BackPressureStrategy;
import io.smallrye.mutiny.subscription.MultiEmitter;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public final class EmitterBasedMulti<T>
extends AbstractMulti<T> {
    public static final int HINT = 16;
    private final Consumer<MultiEmitter<? super T>> consumer;
    private final BackPressureStrategy backpressure;
    private final int overflowBufferSize;

    public EmitterBasedMulti(Consumer<MultiEmitter<? super T>> consumer, BackPressureStrategy backpressure) {
        this(consumer, backpressure, -1);
    }

    public EmitterBasedMulti(Consumer<MultiEmitter<? super T>> consumer, BackPressureStrategy backpressure, int overflowBufferSize) {
        this.consumer = consumer;
        this.backpressure = backpressure;
        this.overflowBufferSize = overflowBufferSize;
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> downstream) {
        BaseMultiEmitter emitter;
        switch (this.backpressure) {
            case DROP: {
                emitter = new DropItemOnOverflowMultiEmitter<T>(downstream);
                break;
            }
            case ERROR: {
                emitter = new ErrorOnOverflowMultiEmitter<T>(downstream);
                break;
            }
            case IGNORE: {
                emitter = new IgnoreBackPressureMultiEmitter<T>(downstream);
                break;
            }
            case LATEST: {
                emitter = new DropLatestOnOverflowMultiEmitter<T>(downstream);
                break;
            }
            default: {
                emitter = this.overflowBufferSize == -1 ? new BufferItemMultiEmitter<T>(downstream, Queues.unbounded(16).get(), this.overflowBufferSize) : new BufferItemMultiEmitter<T>(downstream, Queues.createMpscArrayQueue(this.overflowBufferSize), this.overflowBufferSize);
            }
        }
        downstream.onSubscribe(emitter);
        try {
            this.consumer.accept(emitter.serialize());
        }
        catch (Throwable ex) {
            emitter.fail(ex);
        }
    }

    static final class DropItemOnOverflowMultiEmitter<T>
    extends NoOverflowBaseMultiEmitter<T> {
        DropItemOnOverflowMultiEmitter(MultiSubscriber<? super T> downstream) {
            super(downstream);
        }

        @Override
        void onOverflow() {
        }
    }

    static final class ErrorOnOverflowMultiEmitter<T>
    extends NoOverflowBaseMultiEmitter<T> {
        ErrorOnOverflowMultiEmitter(MultiSubscriber<? super T> downstream) {
            super(downstream);
        }

        @Override
        void onOverflow() {
            this.fail(new BackPressureFailure("Could not emit value due to lack of requests"));
        }
    }

    static final class IgnoreBackPressureMultiEmitter<T>
    extends BaseMultiEmitter<T> {
        IgnoreBackPressureMultiEmitter(MultiSubscriber<? super T> downstream) {
            super(downstream);
        }

        @Override
        public MultiEmitter<T> emit(T item) {
            long r;
            this.downstream.onItem(item);
            while ((r = this.requested.get()) != 0L && !this.requested.compareAndSet(r, r - 1L)) {
            }
            return this;
        }
    }

    static final class DropLatestOnOverflowMultiEmitter<T>
    extends BaseMultiEmitter<T> {
        private final AtomicReference<T> queue = new AtomicReference();
        private Throwable failure;
        private volatile boolean done;
        private final AtomicInteger wip = new AtomicInteger();

        DropLatestOnOverflowMultiEmitter(MultiSubscriber<? super T> downstream) {
            super(downstream);
        }

        @Override
        public MultiEmitter<T> emit(T t) {
            this.queue.set(t);
            this.drain();
            return this;
        }

        @Override
        public void failed(Throwable e) {
            this.failure = e;
            this.done = true;
            this.drain();
        }

        @Override
        public void completion() {
            this.done = true;
            this.drain();
        }

        @Override
        void onRequested() {
            this.drain();
        }

        @Override
        void onUnsubscribed() {
            if (this.wip.getAndIncrement() == 0) {
                this.queue.lazySet(null);
            }
        }

        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            AtomicReference<T> q = this.queue;
            do {
                boolean d;
                long e;
                long r = this.requested.get();
                for (e = 0L; e != r; ++e) {
                    boolean empty;
                    if (this.isCancelled()) {
                        q.lazySet(null);
                        return;
                    }
                    d = this.done;
                    Object o = q.getAndSet(null);
                    boolean bl = empty = o == null;
                    if (d && empty) {
                        Throwable ex = this.failure;
                        if (ex != null) {
                            super.failed(ex);
                        } else {
                            super.completion();
                        }
                        return;
                    }
                    if (empty) break;
                    this.downstream.onItem(o);
                }
                if (e == r) {
                    boolean empty;
                    if (this.isCancelled()) {
                        q.lazySet(null);
                        return;
                    }
                    d = this.done;
                    boolean bl = empty = q.get() == null;
                    if (d && empty) {
                        Throwable ex = this.failure;
                        if (ex != null) {
                            super.failed(ex);
                        } else {
                            super.completion();
                        }
                        return;
                    }
                }
                if (e == 0L) continue;
                Subscriptions.produced(this.requested, e);
            } while ((missed = this.wip.addAndGet(-missed)) != 0);
        }
    }

    static abstract class NoOverflowBaseMultiEmitter<T>
    extends BaseMultiEmitter<T> {
        NoOverflowBaseMultiEmitter(MultiSubscriber<? super T> downstream) {
            super(downstream);
        }

        @Override
        public final MultiEmitter<T> emit(T t) {
            if (this.requested.get() != 0L) {
                this.downstream.onItem(t);
                Subscriptions.produced(this.requested, 1L);
            } else {
                this.onOverflow();
            }
            return this;
        }

        abstract void onOverflow();
    }
}

