/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.marshalling;

import java.io.IOException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.OneToManyTranscoder;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.util.Util;
import org.wildfly.clustering.marshalling.MarshalledValue;
import org.wildfly.clustering.marshalling.MarshalledValueFactory;

public class MarshalledValueTranscoder<C>
extends OneToManyTranscoder {
    private final MarshalledValueFactory<C> factory;
    private final MediaType type;

    public MarshalledValueTranscoder(MediaType type, MarshalledValueFactory<C> factory) {
        super(type, new MediaType[]{MediaType.APPLICATION_OBJECT});
        this.type = type;
        this.factory = factory;
    }

    protected Object doTranscode(Object content, MediaType contentType, MediaType destinationType) {
        if (this.type.match(destinationType)) {
            if (this.type.match(contentType)) {
                return content;
            }
            MarshalledValue value = (MarshalledValue)content;
            try {
                return value.get(this.factory.getMarshallingContext());
            }
            catch (IOException e) {
                throw new CacheException((Throwable)e);
            }
        }
        if (destinationType.match(MediaType.APPLICATION_OBJECT)) {
            return this.factory.createMarshalledValue(content);
        }
        throw Log.CONTAINER.unsupportedConversion(Util.toStr((Object)content), contentType, destinationType);
    }
}

