/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.loading.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.search.mapper.orm.loading.impl.EntityLoadingCacheLookupStrategyImplementor;
import org.hibernate.search.mapper.orm.loading.impl.PersistenceContextLookupStrategy;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.util.common.annotation.impl.SuppressForbiddenApis;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

@SuppressForbiddenApis(reason="EntityPersister is needed to retrieve/use EntityDataAccess")
class PersistenceContextThenSecondLevelCacheLookupStrategy
implements EntityLoadingCacheLookupStrategyImplementor {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final EntityLoadingCacheLookupStrategyImplementor persistenceContextLookupStrategy;
    private final EntityPersister persister;
    private final EntityDataAccess cacheAccess;
    private final SessionImplementor session;

    static EntityLoadingCacheLookupStrategyImplementor create(EntityMappingType entityMappingType, SessionImplementor session) {
        PersistenceContextLookupStrategy persistenceContextLookupStrategy = PersistenceContextLookupStrategy.create(session);
        EntityPersister entityPersister = entityMappingType.getEntityPersister();
        EntityDataAccess cacheAccess = entityPersister.getCacheAccessStrategy();
        if (cacheAccess == null) {
            log.skippingSecondLevelCacheLookupsForNonCachedEntityTypeEntityLoader(entityPersister.getEntityName());
            return persistenceContextLookupStrategy;
        }
        return new PersistenceContextThenSecondLevelCacheLookupStrategy(persistenceContextLookupStrategy, entityPersister, cacheAccess, session);
    }

    private PersistenceContextThenSecondLevelCacheLookupStrategy(EntityLoadingCacheLookupStrategyImplementor persistenceContextLookupStrategy, EntityPersister persister, EntityDataAccess cacheAccess, SessionImplementor session) {
        this.persistenceContextLookupStrategy = persistenceContextLookupStrategy;
        this.persister = persister;
        this.cacheAccess = cacheAccess;
        this.session = session;
    }

    @Override
    public Object lookup(EntityKey entityKey) {
        Object fromPersistenceContext = this.persistenceContextLookupStrategy.lookup(entityKey);
        if (fromPersistenceContext != null) {
            return fromPersistenceContext;
        }
        Object key = this.cacheAccess.generateCacheKey(entityKey.getIdentifier(), this.persister, this.session.getSessionFactory(), this.session.getTenantIdentifier());
        if (!this.cacheAccess.contains(key)) {
            return null;
        }
        try {
            return this.session.get(this.persister.getEntityName(), entityKey.getIdentifier());
        }
        catch (ObjectNotFoundException ignored) {
            return null;
        }
    }
}

