/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.configuration;

import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.counter.api.Storage;
import org.infinispan.counter.configuration.AbstractCounterConfiguration;
import org.infinispan.counter.configuration.CounterConfigurationBuilder;
import org.infinispan.counter.configuration.CounterManagerConfigurationBuilder;
import org.infinispan.counter.configuration.StrongCounterConfigurationBuilder;
import org.infinispan.counter.configuration.WeakCounterConfigurationBuilder;
import org.infinispan.counter.logging.Log;

abstract class AbstractCounterConfigurationBuilder<T extends AbstractCounterConfiguration, S extends AbstractCounterConfigurationBuilder<T, S>>
implements CounterConfigurationBuilder<T, S> {
    final AttributeSet attributes;
    private final CounterManagerConfigurationBuilder builder;

    AbstractCounterConfigurationBuilder(CounterManagerConfigurationBuilder builder, AttributeSet attributes) {
        this.builder = builder;
        this.attributes = attributes;
    }

    @Override
    public final S name(String name) {
        this.attributes.attribute(AbstractCounterConfiguration.NAME).set((Object)name);
        return (S)((AbstractCounterConfigurationBuilder)this.self());
    }

    @Override
    public final S initialValue(long initialValue) {
        this.attributes.attribute(AbstractCounterConfiguration.INITIAL_VALUE).set((Object)initialValue);
        return (S)((AbstractCounterConfigurationBuilder)this.self());
    }

    @Override
    public final S storage(Storage mode) {
        this.attributes.attribute(AbstractCounterConfiguration.STORAGE).set((Object)mode);
        return (S)((AbstractCounterConfigurationBuilder)this.self());
    }

    public void validate() {
        this.attributes.attributes().forEach(Attribute::validate);
        if (!this.builder.isGlobalStateEnabled() && this.attributes.attribute(AbstractCounterConfiguration.STORAGE).get() == Storage.PERSISTENT) {
            throw Log.CONTAINER.invalidPersistentStorageMode();
        }
    }

    @Override
    public String name() {
        return (String)this.attributes.attribute(AbstractCounterConfiguration.NAME).get();
    }

    @Override
    public StrongCounterConfigurationBuilder addStrongCounter() {
        return this.builder.addStrongCounter();
    }

    @Override
    public WeakCounterConfigurationBuilder addWeakCounter() {
        return this.builder.addWeakCounter();
    }
}

