/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.near;

import io.netty.channel.Channel;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryExpired;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryModified;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryRemoved;
import org.infinispan.client.hotrod.annotation.ClientCacheFailover;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.configuration.NearCacheConfiguration;
import org.infinispan.client.hotrod.event.ClientCacheEntryExpiredEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryModifiedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryRemovedEvent;
import org.infinispan.client.hotrod.event.ClientCacheFailoverEvent;
import org.infinispan.client.hotrod.event.impl.ClientListenerNotifier;
import org.infinispan.client.hotrod.impl.InternalRemoteCache;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.client.hotrod.near.NearCache;
import org.infinispan.commons.util.BloomFilter;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.MurmurHash3BloomFilter;
import org.infinispan.commons.util.Util;

public class NearCacheService<K, V>
implements NearCache<K, V> {
    private static final Log log = LogFactory.getLog(NearCacheService.class);
    private final NearCacheConfiguration config;
    private final ClientListenerNotifier listenerNotifier;
    private Object listener;
    private byte[] listenerId;
    private NearCache<K, V> cache;
    private Runnable invalidationCallback;
    private final int bloomFilterBits;
    private final int bloomFilterUpdateThreshold;
    private final AtomicInteger nearCacheRemovals;
    private InternalRemoteCache<K, V> remote;
    private Channel channelUsed;

    protected NearCacheService(NearCacheConfiguration config, ClientListenerNotifier listenerNotifier) {
        this.config = config;
        this.listenerNotifier = listenerNotifier;
        int maxEntries = config.maxEntries();
        if (maxEntries > 0 && config.bloomFilter()) {
            this.bloomFilterBits = NearCacheService.determineBloomFilterBits(maxEntries);
            this.bloomFilterUpdateThreshold = maxEntries / 16 + 3;
            this.nearCacheRemovals = new AtomicInteger();
        } else {
            this.bloomFilterBits = -1;
            this.bloomFilterUpdateThreshold = -1;
            this.nearCacheRemovals = null;
        }
    }

    public Channel start(InternalRemoteCache<K, V> remote) {
        if (this.cache == null) {
            this.cache = this.createNearCache(this.config, this::entryRemovedFromNearCache);
            this.listener = new InvalidatedNearCacheListener(this);
            if (this.bloomFilterBits > 0) {
                this.channelUsed = remote.addNearCacheListener(this.listener, this.bloomFilterBits);
            } else {
                remote.addClientListener(this.listener);
            }
            this.listenerId = this.listenerNotifier.findListenerId(this.listener);
        }
        this.remote = remote;
        return this.channelUsed;
    }

    private static int determineBloomFilterBits(int maxEntries) {
        int bloomFilterBitScaler = Integer.parseInt(System.getProperty("infinispan.bloom-filter.bit-multiplier", "4"));
        return maxEntries * bloomFilterBitScaler;
    }

    void entryRemovedFromNearCache(K key, MetadataValue<V> value) {
        block3: {
            int removals;
            if (this.nearCacheRemovals == null) {
                return;
            }
            while (true) {
                if ((removals = this.nearCacheRemovals.get()) >= this.bloomFilterUpdateThreshold) {
                    if (!this.nearCacheRemovals.compareAndSet(removals, 0)) continue;
                    log.tracef("Updating bloom filter due to reaching update threshold with %d for %s", removals, this.remote.getName());
                    this.remote.updateBloomFilter();
                    break block3;
                }
                if (this.nearCacheRemovals.compareAndSet(removals, removals + 1)) break;
            }
            log.tracef("Incremented nearCacheRemovals to %d for %s", removals + 1, this.remote.getName());
        }
    }

    public void stop(RemoteCache<K, V> remote) {
        if (log.isTraceEnabled()) {
            log.tracef("Stop near cache, remove underlying listener id %s", Util.printArray((byte[])this.listenerId));
        }
        remote.removeClientListener(this.listener);
        this.cache.clear();
    }

    protected NearCache<K, V> createNearCache(NearCacheConfiguration config, BiConsumer<K, MetadataValue<V>> removedConsumer) {
        return config.nearCacheFactory().createNearCache(config, removedConsumer);
    }

    public static <K, V> NearCacheService<K, V> create(NearCacheConfiguration config, ClientListenerNotifier listenerNotifier) {
        return new NearCacheService<K, V>(config, listenerNotifier);
    }

    @Override
    public boolean replace(K key, MetadataValue<V> prevValue, MetadataValue<V> newValue) {
        boolean replaced = this.cache.replace(key, prevValue, newValue);
        if (log.isTraceEnabled()) {
            log.tracef("Replaced key=%s and value=%s with new value=%s in near cache (listenerId=%s): %s", new Object[]{key, prevValue, newValue, Util.printArray((byte[])this.listenerId), replaced});
        }
        return replaced;
    }

    @Override
    public boolean putIfAbsent(K key, MetadataValue<V> value) {
        boolean inserted = this.cache.putIfAbsent(key, value);
        if (log.isTraceEnabled()) {
            log.tracef("Conditionally put %s if absent in near cache (listenerId=%s): %s", value, Util.printArray((byte[])this.listenerId), inserted);
        }
        return inserted;
    }

    @Override
    public boolean remove(K key) {
        boolean removed = this.cache.remove(key);
        if (removed) {
            if (this.invalidationCallback != null) {
                this.invalidationCallback.run();
            }
            if (log.isTraceEnabled()) {
                log.tracef("Removed key=%s from near cache (listenedId=%s)", key, Util.printArray((byte[])this.listenerId));
            }
        } else {
            log.tracef("Received false positive remove for key=%s from near cache (listenedId=%s)", key, Util.printArray((byte[])this.listenerId));
            this.entryRemovedFromNearCache(key, null);
        }
        return removed;
    }

    @Override
    public boolean remove(K key, MetadataValue<V> value) {
        boolean removed = this.cache.remove(key, value);
        if (log.isTraceEnabled()) {
            log.tracef("Removed value=%s for key=%s from near cache (listenedId=%s): %s", new Object[]{value, key, Util.printArray((byte[])this.listenerId), removed});
        }
        return removed;
    }

    @Override
    public MetadataValue<V> get(K key) {
        boolean listenerConnected = this.isConnected();
        if (listenerConnected) {
            MetadataValue<V> value = this.cache.get(key);
            if (log.isTraceEnabled()) {
                log.tracef("Get key=%s returns value=%s (listenerId=%s)", key, value, Util.printArray((byte[])this.listenerId));
            }
            return value;
        }
        if (log.isTraceEnabled()) {
            log.tracef("Near cache disconnected from server, returning null for key=%s (listenedId=%s)", key, Util.printArray((byte[])this.listenerId));
        }
        return null;
    }

    @Override
    public void clear() {
        this.cache.clear();
        if (this.nearCacheRemovals != null) {
            this.nearCacheRemovals.set(0);
        }
        if (log.isTraceEnabled()) {
            log.tracef("Cleared near cache (listenerId=%s)", Util.printArray((byte[])this.listenerId));
        }
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public Iterator<Map.Entry<K, MetadataValue<V>>> iterator() {
        return this.cache.iterator();
    }

    boolean isConnected() {
        return this.listenerNotifier.isListenerConnected(this.listenerId);
    }

    public void setInvalidationCallback(Runnable r) {
        this.invalidationCallback = r;
    }

    public int getBloomFilterBits() {
        return this.bloomFilterBits;
    }

    public NearCacheConfiguration getConfig() {
        return this.config;
    }

    public byte[] getListenerId() {
        return this.listenerId;
    }

    public byte[] calculateBloomBits() {
        if (this.bloomFilterBits <= 0) {
            return null;
        }
        BloomFilter bloomFilter = MurmurHash3BloomFilter.createFilter((int)this.bloomFilterBits);
        for (Map.Entry entry : this.cache) {
            bloomFilter.addToFilter((Object)this.remote.keyToBytes(entry.getKey()));
        }
        IntSet intSet = bloomFilter.getIntSet();
        return intSet.toBitSet();
    }

    @ClientListener
    private static class InvalidatedNearCacheListener<K, V> {
        private static final Log log = LogFactory.getLog(InvalidatedNearCacheListener.class);
        private final NearCache<K, V> cache;

        private InvalidatedNearCacheListener(NearCache<K, V> cache) {
            this.cache = cache;
        }

        @ClientCacheEntryModified
        public void handleModifiedEvent(ClientCacheEntryModifiedEvent<K> event) {
            this.invalidate(event.getKey());
        }

        @ClientCacheEntryRemoved
        public void handleRemovedEvent(ClientCacheEntryRemovedEvent<K> event) {
            this.invalidate(event.getKey());
        }

        @ClientCacheEntryExpired
        public void handleExpiredEvent(ClientCacheEntryExpiredEvent<K> event) {
            this.invalidate(event.getKey());
        }

        @ClientCacheFailover
        public void handleFailover(ClientCacheFailoverEvent e) {
            if (log.isTraceEnabled()) {
                log.trace("Clear near cache after fail-over of server");
            }
            this.cache.clear();
        }

        private void invalidate(K key) {
            this.cache.remove(key);
        }
    }
}

