/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.metadata.coarse;

import java.time.Duration;
import java.time.Instant;
import org.wildfly.clustering.session.ImmutableSessionMetaData;
import org.wildfly.clustering.session.cache.metadata.coarse.ImmutableSessionMetaDataEntry;

public class DefaultImmutableSessionMetaData
implements ImmutableSessionMetaData {
    private final ImmutableSessionMetaDataEntry entry;

    public DefaultImmutableSessionMetaData(ImmutableSessionMetaDataEntry entry) {
        this.entry = entry;
    }

    public boolean isNew() {
        return this.entry.isNew();
    }

    public Instant getCreationTime() {
        return this.entry.getCreationTime();
    }

    public Instant getLastAccessStartTime() {
        return !this.isNew() ? this.entry.getLastAccessStartTime().get() : null;
    }

    public Instant getLastAccessEndTime() {
        return !this.isNew() ? this.entry.getLastAccessEndTime().get() : null;
    }

    public Duration getTimeout() {
        return this.entry.getTimeout();
    }

    public String toString() {
        return String.format("{ new = %s, creation-time = %s, last-access-start-time = %s, last-access-end-time = %s, timeout = %s }", this.isNew(), this.getCreationTime(), this.getLastAccessStartTime(), this.getLastAccessEndTime(), this.getTimeout());
    }
}

