/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem.deployment;

import java.lang.reflect.Method;
import java.util.Collection;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.component.stateful.StatefulTimeoutInfo;
import org.jboss.as.ejb3.subsystem.deployment.AbstractEJBComponentRuntimeHandler;
import org.jboss.as.ejb3.subsystem.deployment.EJBComponentType;
import org.jboss.as.ejb3.subsystem.deployment.StatefulSessionBeanDeploymentResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.invocation.proxy.MethodIdentifier;

public class StatefulSessionBeanRuntimeHandler
extends AbstractEJBComponentRuntimeHandler<StatefulSessionComponent> {
    public static final StatefulSessionBeanRuntimeHandler INSTANCE = new StatefulSessionBeanRuntimeHandler();

    private StatefulSessionBeanRuntimeHandler() {
        super(EJBComponentType.STATEFUL, StatefulSessionComponent.class);
    }

    @Override
    protected void executeReadAttribute(String attributeName, OperationContext context, StatefulSessionComponent component, PathAddress address) {
        StatefulComponentDescription componentDescription = (StatefulComponentDescription)component.getComponentDescription();
        ModelNode result = context.getResult();
        if (StatefulSessionBeanDeploymentResourceDefinition.STATEFUL_TIMEOUT.getName().equals(attributeName)) {
            StatefulTimeoutInfo statefulTimeout = componentDescription.getStatefulTimeout();
            if (statefulTimeout != null) {
                result.set(statefulTimeout.getValue() + 32L + statefulTimeout.getTimeUnit().toString());
            }
        } else if (StatefulSessionBeanDeploymentResourceDefinition.AFTER_BEGIN_METHOD.getName().equals(attributeName)) {
            Method afterBeginMethod = component.getAfterBeginMethod();
            if (afterBeginMethod != null) {
                result.set(afterBeginMethod.toString());
            }
        } else if (StatefulSessionBeanDeploymentResourceDefinition.BEFORE_COMPLETION_METHOD.getName().equals(attributeName)) {
            Method beforeCompletionMethod = component.getBeforeCompletionMethod();
            if (beforeCompletionMethod != null) {
                result.set(beforeCompletionMethod.toString());
            }
        } else if (StatefulSessionBeanDeploymentResourceDefinition.AFTER_COMPLETION_METHOD.getName().equals(attributeName)) {
            Method afterCompletionMethod = component.getAfterCompletionMethod();
            if (afterCompletionMethod != null) {
                result.set(afterCompletionMethod.toString());
            }
        } else if (StatefulSessionBeanDeploymentResourceDefinition.PASSIVATION_CAPABLE.getName().equals(attributeName)) {
            result.set(componentDescription.isPassivationApplicable());
        } else if (StatefulSessionBeanDeploymentResourceDefinition.REMOVE_METHODS.getName().equals(attributeName)) {
            Collection<StatefulComponentDescription.StatefulRemoveMethod> removeMethods = componentDescription.getRemoveMethods();
            for (StatefulComponentDescription.StatefulRemoveMethod removeMethod : removeMethods) {
                ModelNode removeMethodNode = result.add();
                ModelNode beanMethodNode = removeMethodNode.get(StatefulSessionBeanDeploymentResourceDefinition.BEAN_METHOD.getName());
                MethodIdentifier methodIdentifier = removeMethod.getMethodIdentifier();
                beanMethodNode.set(methodIdentifier.getReturnType() + " " + methodIdentifier.getName() + "(" + String.join((CharSequence)", ", methodIdentifier.getParameterTypes()) + ")");
                ModelNode retainIfExceptionNode = removeMethodNode.get(StatefulSessionBeanDeploymentResourceDefinition.RETAIN_IF_EXCEPTION.getName());
                retainIfExceptionNode.set(removeMethod.getRetainIfException());
            }
        } else {
            super.executeReadAttribute(attributeName, context, component, address);
        }
    }
}

