/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.predicate.impl;

import java.util.List;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.search.common.impl.AbstractLuceneValueFieldSearchQueryElementFactory;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexValueFieldContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneLeafSingleFieldPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinPolygonPredicateBuilder;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.engine.spatial.GeoPolygon;

public class LuceneGeoPointSpatialWithinPolygonPredicate
extends AbstractLuceneLeafSingleFieldPredicate {
    private LuceneGeoPointSpatialWithinPolygonPredicate(Builder builder) {
        super(builder);
    }

    static class Builder
    extends AbstractLuceneLeafSingleFieldPredicate.AbstractBuilder<GeoPoint>
    implements SpatialWithinPolygonPredicateBuilder {
        protected GeoPolygon polygon;

        Builder(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<GeoPoint> field) {
            super(scope, field);
        }

        public void polygon(GeoPolygon polygon) {
            this.polygon = polygon;
        }

        public SearchPredicate build() {
            return new LuceneGeoPointSpatialWithinPolygonPredicate(this);
        }

        @Override
        protected Query buildQuery(PredicateRequestContext context) {
            List points = this.polygon.points();
            double[] polyLats = new double[points.size()];
            double[] polyLons = new double[points.size()];
            for (int i = 0; i < points.size(); ++i) {
                polyLats[i] = ((GeoPoint)points.get(i)).latitude();
                polyLons[i] = ((GeoPoint)points.get(i)).longitude();
            }
            Polygon lucenePolygon = new Polygon(polyLats, polyLons, new Polygon[0]);
            return LatLonPoint.newPolygonQuery((String)this.absoluteFieldPath, (Polygon[])new Polygon[]{lucenePolygon});
        }
    }

    public static class Factory
    extends AbstractLuceneValueFieldSearchQueryElementFactory<SpatialWithinPolygonPredicateBuilder, GeoPoint> {
        @Override
        public Builder create(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<GeoPoint> field) {
            return new Builder(scope, field);
        }
    }
}

