/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.threads.BoundedQueueThreadPoolAdd;
import org.jboss.as.threads.EnhancedQueueExecutorService;
import org.jboss.as.threads.PoolAttributeDefinitions;
import org.jboss.as.threads.ThreadsLogger;
import org.jboss.as.threads.ThreadsWriteAttributeOperationHandler;
import org.jboss.as.threads.TimeSpec;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class BoundedQueueThreadPoolWriteAttributeHandler
extends ThreadsWriteAttributeOperationHandler {
    private final ServiceName serviceNameBase;
    private final RuntimeCapability<Void> capability;

    public BoundedQueueThreadPoolWriteAttributeHandler(boolean blocking, RuntimeCapability<Void> capability, ServiceName serviceNameBase) {
        super(blocking ? BoundedQueueThreadPoolAdd.BLOCKING_ATTRIBUTES : BoundedQueueThreadPoolAdd.NON_BLOCKING_ATTRIBUTES);
        this.serviceNameBase = serviceNameBase;
        this.capability = capability;
    }

    @Override
    protected void applyOperation(OperationContext context, ModelNode model, String attributeName, ServiceController<?> service, boolean forRollback) throws OperationFailedException {
        EnhancedQueueExecutorService pool = (EnhancedQueueExecutorService)service.getService();
        if (PoolAttributeDefinitions.KEEPALIVE_TIME.getName().equals(attributeName)) {
            TimeUnit defaultUnit = pool.getKeepAliveUnit();
            TimeSpec spec = BoundedQueueThreadPoolWriteAttributeHandler.getTimeSpec(context, model, defaultUnit);
            pool.setKeepAlive(spec);
        } else if (PoolAttributeDefinitions.MAX_THREADS.getName().equals(attributeName)) {
            pool.setMaxThreads(PoolAttributeDefinitions.MAX_THREADS.resolveModelAttribute(context, model).asInt());
        } else if (PoolAttributeDefinitions.CORE_THREADS.getName().equals(attributeName)) {
            ModelNode coreNode = PoolAttributeDefinitions.CORE_THREADS.resolveModelAttribute(context, model);
            int coreCount = coreNode.isDefined() ? coreNode.asInt() : PoolAttributeDefinitions.MAX_THREADS.resolveModelAttribute(context, model).asInt();
            pool.setCoreThreads(coreCount);
        } else if (PoolAttributeDefinitions.QUEUE_LENGTH.getName().equals(attributeName)) {
            if (forRollback) {
                context.revertReloadRequired();
            } else {
                context.reloadRequired();
            }
        } else if (PoolAttributeDefinitions.ALLOW_CORE_TIMEOUT.getName().equals(attributeName)) {
            pool.setAllowCoreTimeout(PoolAttributeDefinitions.ALLOW_CORE_TIMEOUT.resolveModelAttribute(context, model).asBoolean());
        } else if (!forRollback) {
            throw ThreadsLogger.ROOT_LOGGER.unsupportedBoundedQueueThreadPoolAttribute(attributeName);
        }
    }

    @Override
    protected ServiceController<?> getService(OperationContext context, ModelNode model) throws OperationFailedException {
        String name = context.getCurrentAddressValue();
        ServiceName serviceName = null;
        ServiceController controller = null;
        if (this.capability != null) {
            serviceName = this.capability.getCapabilityServiceName(context.getCurrentAddress());
            controller = context.getServiceRegistry(true).getService(serviceName);
            if (controller != null) {
                return controller;
            }
        }
        if (this.serviceNameBase != null) {
            serviceName = this.serviceNameBase.append(new String[]{name});
            controller = context.getServiceRegistry(true).getService(serviceName);
        }
        if (controller == null) {
            throw ThreadsLogger.ROOT_LOGGER.boundedQueueThreadPoolServiceNotFound(serviceName);
        }
        return controller;
    }
}

