/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.client.configuration;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import org.apache.cxf.Bus;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.jboss.logging.Logger;
import org.jboss.wsf.stack.cxf.client.configuration.SecurityActions;
import org.jboss.wsf.stack.cxf.i18n.Loggers;

public class SecurityProviderConfig {
    private static Logger log = Logger.getLogger(SecurityProviderConfig.class);
    public static final boolean BC_GLOBALLY_AVAILABLE;
    private static final boolean NO_LOCAL_BC;

    public static void setup(Bus bus) {
        if (!NO_LOCAL_BC && !BC_GLOBALLY_AVAILABLE && Holder.provider != null) {
            bus.getInInterceptors().add(Holder.inInterceptor);
            bus.getOutInterceptors().add(Holder.outInterceptor);
        }
    }

    private static void useIvParameterSpec() {
        AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                String ivParameterSpec = "org.apache.xml.security.cipher.gcm.useIvParameterSpec";
                if (System.getProperty(ivParameterSpec) == null) {
                    System.setProperty(ivParameterSpec, "true");
                    return false;
                }
                return true;
            }
        });
    }

    static {
        boolean bl = BC_GLOBALLY_AVAILABLE = Security.getProvider("BC") != null;
        if (BC_GLOBALLY_AVAILABLE) {
            try {
                SecurityProviderConfig.useIvParameterSpec();
            }
            catch (Throwable t) {
                Logger.getLogger(SecurityProviderConfig.class).trace((Object)t);
            }
        }
        NO_LOCAL_BC = SecurityActions.getBoolean("org.jboss.ws.cxf.noLocalBC");
    }

    private static class Holder {
        static final Provider provider = Holder.getBCProvider();
        static final Interceptor inInterceptor = new Interceptor("receive");
        static final Interceptor outInterceptor = new Interceptor("setup");

        private Holder() {
        }

        private static Provider getBCProvider() {
            Provider provider = null;
            try {
                Class<?> clazz = SecurityProviderConfig.class.getClassLoader().loadClass("org.bouncycastle.jce.provider.BouncyCastleProvider");
                provider = (Provider)clazz.newInstance();
                if (provider.getVersion() < 1.5) {
                    SecurityProviderConfig.useIvParameterSpec();
                }
            }
            catch (Throwable t) {
                Loggers.ROOT_LOGGER.cannotLoadBouncyCastleProvider("org.jboss.ws.cxf.noLocalBC", t);
            }
            return provider;
        }
    }

    private static class Interceptor
    extends AbstractPhaseInterceptor<Message> {
        public Interceptor(String phase) {
            super(phase);
        }

        public void handleMessage(Message message) throws Fault {
            Exchange exchange = message.getExchange();
            exchange.put(Provider.class, (Object)Holder.provider);
        }
    }
}

