/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.environment.thread.impl;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;
import org.hibernate.search.engine.environment.thread.impl.SimpleThreadFactory;
import org.hibernate.search.engine.environment.thread.spi.ThreadProvider;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.util.common.annotation.impl.SuppressForbiddenApis;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class EmbeddedThreadProvider
implements ThreadProvider {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    public static final String NAME = "embedded";
    private static final Supplier<ThreadGroup> THREAD_GROUP_PROVIDER;
    private final String commonThreadNamePrefix;

    public EmbeddedThreadProvider() {
        this("Hibernate Search - ");
    }

    public EmbeddedThreadProvider(String commonThreadNamePrefix) {
        this.commonThreadNamePrefix = commonThreadNamePrefix;
    }

    @Override
    public String createThreadName(String prefix, int threadNumber) {
        return this.createFullThreadNamePrefix(prefix) + threadNumber;
    }

    @Override
    @SuppressForbiddenApis(reason="It's unclear how we will handle this without the security manager; we'll see when the security manager actually gets removed from the JDK")
    public ThreadFactory createThreadFactory(String prefix) {
        ThreadGroup group = THREAD_GROUP_PROVIDER.get();
        String namePrefix = this.createFullThreadNamePrefix(prefix);
        return new SimpleThreadFactory(group, namePrefix);
    }

    private String createFullThreadNamePrefix(String prefix) {
        return this.commonThreadNamePrefix + prefix + " - ";
    }

    static {
        Supplier<ThreadGroup> provider = null;
        try {
            Class<?> smClass = Thread.currentThread().getContextClassLoader().loadClass("java.lang.SecurityManager");
            Method getSecurityManager = System.class.getDeclaredMethod("getSecurityManager", new Class[0]);
            Method getThreadGroup = smClass.getDeclaredMethod("getThreadGroup", new Class[0]);
            provider = () -> {
                try {
                    Object sm = getSecurityManager.invoke(null, new Object[0]);
                    if (sm != null) {
                        return (ThreadGroup)getThreadGroup.invoke(sm, new Object[0]);
                    }
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw log.securityManagerInvocationProblem(e.getMessage(), e);
                }
                return Thread.currentThread().getThreadGroup();
            };
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            provider = () -> Thread.currentThread().getThreadGroup();
        }
        THREAD_GROUP_PROVIDER = provider;
    }
}

