/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.accesscontrol;

import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.accesscontrol.AccessRequirement;
import org.jboss.as.cli.accesscontrol.BaseAccessRequirement;
import org.wildfly.common.Assert;

public class ControllerModeAccess
extends BaseAccessRequirement {
    private final Mode mode;
    private AccessRequirement requirement = AccessRequirement.NONE;

    ControllerModeAccess(Mode mode) {
        this.mode = Assert.checkNotNullParam("mode", mode);
    }

    public void setRequirement(AccessRequirement requirement) {
        this.requirement = Assert.checkNotNullParam("requirement", requirement);
    }

    @Override
    protected boolean checkAccess(CommandContext ctx) {
        if (ctx.isDomainMode()) {
            return this.mode == Mode.DOMAIN ? this.requirement.isSatisfied(ctx) : false;
        }
        return this.mode == Mode.STANDALONE ? this.requirement.isSatisfied(ctx) : false;
    }

    public String toString() {
        return this.mode + " " + this.requirement;
    }

    public static enum Mode {
        DOMAIN,
        STANDALONE;

    }
}

