/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.parsing.arguments;

import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.parsing.BackQuotesState;
import org.jboss.as.cli.parsing.CharacterHandler;
import org.jboss.as.cli.parsing.DefaultParsingState;
import org.jboss.as.cli.parsing.ParsingContext;
import org.jboss.as.cli.parsing.QuotesState;
import org.jboss.as.cli.parsing.WordCharacterHandler;
import org.jboss.as.cli.parsing.arguments.BytesValueState;
import org.jboss.as.cli.parsing.arguments.ExpressionValueState;
import org.jboss.as.cli.parsing.arguments.ListItemSeparatorState;
import org.jboss.as.cli.parsing.arguments.NameValueSeparatorState;

public class ArgumentValueState
extends DefaultParsingState {
    public static final String ID = "ARG_VALUE";
    public static final ArgumentValueState INSTANCE = new ArgumentValueState();
    public static final String BYTES_TOKEN = "bytes{";
    private static final char[] BYTES_TOKEN_CHARS = "bytes{".toCharArray();

    public ArgumentValueState() {
        super(ID);
        this.setEnterHandler(new CharacterHandler(){

            @Override
            public void handle(ParsingContext ctx) throws CommandFormatException {
                char ch = ctx.getCharacter();
                switch (ch) {
                    case '\"': {
                        ctx.enterState(QuotesState.QUOTES_EXCLUDED);
                        break;
                    }
                    case '$': {
                        ctx.enterState(ExpressionValueState.INSTANCE);
                        break;
                    }
                    case '`': {
                        ctx.enterState(BackQuotesState.QUOTES_INCLUDED);
                        break;
                    }
                    default: {
                        if (ch == 'b') {
                            int tokenLength = ArgumentValueState.getBytesToken(ctx);
                            if (tokenLength > 0) {
                                ctx.advanceLocation(tokenLength);
                                ctx.enterState(BytesValueState.INSTANCE);
                                break;
                            }
                            ctx.getCallbackHandler().character(ctx);
                            break;
                        }
                        ctx.getCallbackHandler().character(ctx);
                    }
                }
            }
        });
        this.setDefaultHandler(new CharacterHandler(){

            @Override
            public void handle(ParsingContext ctx) throws CommandFormatException {
                char c = ctx.getCharacter();
                if ((c == '}' || c == ']') && ctx.isLookingFor(c)) {
                    ctx.leaveState();
                } else if (c == '=' && !ctx.isDeactivated(c)) {
                    ctx.enterState(NameValueSeparatorState.INSTANCE);
                } else {
                    WordCharacterHandler.IGNORE_LB_ESCAPE_ON.handle(ctx);
                }
            }
        });
        this.enterState(',', ListItemSeparatorState.INSTANCE);
        this.enterState('\"', QuotesState.QUOTES_INCLUDED);
        this.enterState('`', BackQuotesState.QUOTES_INCLUDED);
        this.enterState('$', ExpressionValueState.INSTANCE);
        this.setReturnHandler(new CharacterHandler(){

            @Override
            public void handle(ParsingContext ctx) throws CommandFormatException {
                if (ctx.isEndOfContent()) {
                    return;
                }
                char c = ctx.getCharacter();
                if (c == ',') {
                    ctx.leaveState();
                }
            }
        });
    }

    public static int getBytesToken(ParsingContext ctx) {
        String input = ctx.getInput().substring(ctx.getLocation());
        int tokenOffset = 0;
        char[] inputChars = input.toCharArray();
        for (int i = 0; i < input.length(); ++i) {
            char c = inputChars[i];
            if (c == ' ') continue;
            if (c != BYTES_TOKEN_CHARS[tokenOffset]) {
                return -1;
            }
            if (++tokenOffset != BYTES_TOKEN_CHARS.length) continue;
            return i;
        }
        return -1;
    }
}

