/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.io.Serializable;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import org.wildfly.clustering.function.Supplier;

public interface BiFunction<T, U, R>
extends java.util.function.BiFunction<T, U, R> {
    public static final BiFunction<?, ?, ?> FORMER_IDENTITY = new FormerIdentityFunction();
    public static final BiFunction<?, ?, ?> LATTER_IDENTITY = new LatterIdentityFunction();
    public static final BiFunction<?, ?, ?> NULL = new BiFunction<Object, Object, Object>(){

        @Override
        public Object apply(Object value1, Object value2) {
            return null;
        }
    };

    default public <V1, V2> BiFunction<V1, V2, R> compose(final Function<? super V1, ? extends T> before1, final Function<? super V2, ? extends U> before2) {
        return new BiFunction<V1, V2, R>(){

            @Override
            public R apply(V1 value1, V2 value2) {
                return BiFunction.this.apply(before1.apply(value1), before2.apply(value2));
            }
        };
    }

    @Override
    default public <V> BiFunction<T, U, V> andThen(final Function<? super R, ? extends V> after) {
        return new BiFunction<T, U, V>(){

            @Override
            public V apply(T value1, U value2) {
                return after.apply(BiFunction.this.apply(value1, value2));
            }
        };
    }

    default public BiFunction<U, T, R> reverse() {
        return new BiFunction<U, T, R>(){

            @Override
            public R apply(U value2, T value1) {
                return BiFunction.this.apply(value1, value2);
            }
        };
    }

    default public BiFunction<T, U, R> withDefault(final Predicate<T> predicate1, final java.util.function.Supplier<T> defaultValue1, final Predicate<U> predicate2, final java.util.function.Supplier<U> defaultValue2) {
        return new BiFunction<T, U, R>(){

            @Override
            public R apply(T value1, U value2) {
                return BiFunction.this.apply(predicate1.test(value1) ? value1 : defaultValue1.get(), predicate2.test(value2) ? value2 : defaultValue2.get());
            }
        };
    }

    default public BiFunction<T, U, R> orDefault(final BiPredicate<T, U> predicate, final java.util.function.Supplier<R> defaultResult) {
        return new BiFunction<T, U, R>(){

            @Override
            public R apply(T value1, U value2) {
                return predicate.test(value1, value2) ? BiFunction.this.apply(value1, value2) : defaultResult.get();
            }
        };
    }

    public static <T extends R, U, R> BiFunction<T, U, R> former() {
        return FORMER_IDENTITY;
    }

    public static <T, U, R> BiFunction<T, U, R> former(final Function<T, R> function) {
        return new BiFunction<T, U, R>(){

            @Override
            public R apply(T value1, U value2) {
                return function.apply(value1);
            }
        };
    }

    public static <T, U extends R, R> BiFunction<T, U, R> latter() {
        return LATTER_IDENTITY;
    }

    public static <T, U, R> BiFunction<T, U, R> latter(final Function<U, R> function) {
        return new BiFunction<T, U, R>(){

            @Override
            public R apply(T value1, U value2) {
                return function.apply(value2);
            }
        };
    }

    public static <T, U, R> BiFunction<T, U, R> of(R result) {
        return result != null ? BiFunction.of(Supplier.of(result)) : NULL;
    }

    public static <T, U, R> BiFunction<T, U, R> of(final java.util.function.Supplier<R> supplier) {
        return supplier != null && supplier != Supplier.NULL ? new BiFunction<T, U, R>(){

            @Override
            public R apply(T ignore1, U ignore2) {
                return supplier.get();
            }
        } : NULL;
    }

    public static class FormerIdentityFunction<T extends R, U, R>
    implements BiFunction<T, U, R>,
    Serializable {
        private static final long serialVersionUID = 9008279150648512886L;

        @Override
        public R apply(T value1, U value2) {
            return (R)value1;
        }
    }

    public static class LatterIdentityFunction<T, U extends R, R>
    implements BiFunction<T, U, R>,
    Serializable {
        private static final long serialVersionUID = 1481217198136411335L;

        @Override
        public R apply(T value1, U value2) {
            return (R)value2;
        }
    }
}

