/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.wildfly.clustering.function.BiFunction;
import org.wildfly.clustering.function.Supplier;

public interface BinaryOperator<T>
extends java.util.function.BinaryOperator<T>,
BiFunction<T, T, T> {
    public static final BinaryOperator<?> FORMER_IDENTITY = new FormerIdentityOperator();
    public static final BinaryOperator<?> LATTER_IDENTITY = new LatterIdentityOperator();
    public static final BinaryOperator<?> NULL = new BinaryOperator<Object>(){

        @Override
        public Object apply(Object value1, Object value2) {
            return null;
        }
    };

    default public BinaryOperator<T> compose(final UnaryOperator<T> before1, final UnaryOperator<T> before2) {
        return new BinaryOperator<T>(){

            @Override
            public T apply(T value1, T value2) {
                return BinaryOperator.this.apply(before1.apply(value1), before2.apply(value2));
            }
        };
    }

    default public BinaryOperator<T> andThen(final UnaryOperator<T> after) {
        return new BinaryOperator<T>(){

            @Override
            public T apply(T value1, T value2) {
                return after.apply(BinaryOperator.this.apply(value1, value2));
            }
        };
    }

    default public BinaryOperator<T> reverse() {
        return new BinaryOperator<T>(){

            @Override
            public T apply(T value2, T value1) {
                return BinaryOperator.this.apply(value1, value2);
            }
        };
    }

    default public BinaryOperator<T> withDefault(final Predicate<T> predicate1, final java.util.function.Supplier<T> defaultValue1, final Predicate<T> predicate2, final java.util.function.Supplier<T> defaultValue2) {
        return new BinaryOperator<T>(){

            @Override
            public T apply(T value1, T value2) {
                return BinaryOperator.this.apply(predicate1.test(value1) ? value1 : defaultValue1.get(), predicate2.test(value2) ? value2 : defaultValue2.get());
            }
        };
    }

    default public BinaryOperator<T> orDefault(final BiPredicate<T, T> predicate, final java.util.function.Supplier<T> defaultResult) {
        return new BinaryOperator<T>(){

            @Override
            public T apply(T value1, T value2) {
                return predicate.test(value1, value2) ? BinaryOperator.this.apply(value1, value2) : defaultResult.get();
            }
        };
    }

    public static <T> BinaryOperator<T> former() {
        return FORMER_IDENTITY;
    }

    public static <T> BinaryOperator<T> latter() {
        return LATTER_IDENTITY;
    }

    public static <T> BinaryOperator<T> of(T result) {
        return result != null ? BinaryOperator.of(Supplier.of(result)) : NULL;
    }

    public static <T> BinaryOperator<T> of(final java.util.function.Supplier<T> supplier) {
        return supplier != null && supplier != Supplier.NULL ? new BinaryOperator<T>(){

            @Override
            public T apply(T ignore1, T ignore2) {
                return supplier.get();
            }
        } : NULL;
    }

    public static class FormerIdentityOperator<T>
    extends BiFunction.FormerIdentityFunction<T, T, T>
    implements BinaryOperator<T> {
        private static final long serialVersionUID = 1776702302523048465L;
    }

    public static class LatterIdentityOperator<T>
    extends BiFunction.LatterIdentityFunction<T, T, T>
    implements BinaryOperator<T> {
        private static final long serialVersionUID = -8741076230246655393L;
    }
}

