/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.platform.mbean.AbstractPlatformMBeanAttributeHandler;
import org.jboss.as.platform.mbean.ExtendedGarbageCollectorMBean;
import org.jboss.as.platform.mbean.GarbageCollectorResourceDefinition;
import org.jboss.as.platform.mbean.PlatformMBeanConstants;
import org.jboss.as.platform.mbean.PlatformMBeanUtil;
import org.jboss.as.platform.mbean.logging.PlatformMBeanLogger;
import org.jboss.dmr.ModelNode;

class GarbageCollectorMXBeanAttributeHandler
extends AbstractPlatformMBeanAttributeHandler {
    static final GarbageCollectorMXBeanAttributeHandler INSTANCE = new GarbageCollectorMXBeanAttributeHandler();

    private GarbageCollectorMXBeanAttributeHandler() {
    }

    @Override
    protected void executeReadAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String gcName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        String name = operation.require("name").asString();
        GarbageCollectorMXBean gcMBean = null;
        for (GarbageCollectorMXBean mbean : ManagementFactory.getGarbageCollectorMXBeans()) {
            if (!gcName.equals(PlatformMBeanUtil.escapeMBeanName(mbean.getName()))) continue;
            gcMBean = mbean;
        }
        if (gcMBean == null) {
            throw PlatformMBeanLogger.ROOT_LOGGER.unknownGarbageCollector(gcName);
        }
        if (GarbageCollectorResourceDefinition.GARBAGE_COLLECTOR_EXTENDED_READ_ATTRIBUTES.contains(name)) {
            GarbageCollectorMXBeanAttributeHandler.storeExtendedResult(gcName, name, context.getResult());
        } else if (PlatformMBeanConstants.OBJECT_NAME.getName().equals(name)) {
            String objName = PlatformMBeanUtil.getObjectNameStringWithNameKey("java.lang:type=GarbageCollector", gcName);
            context.getResult().set(objName);
        } else if ("name".equals(name)) {
            context.getResult().set(PlatformMBeanUtil.escapeMBeanName(gcMBean.getName()));
        } else if (PlatformMBeanConstants.VALID.getName().equals(name)) {
            context.getResult().set(gcMBean.isValid());
        } else if ("memory-pool-names".equals(name)) {
            ModelNode result = context.getResult();
            result.setEmptyList();
            for (String pool : gcMBean.getMemoryPoolNames()) {
                result.add(PlatformMBeanUtil.escapeMBeanName(pool));
            }
        } else if ("collection-count".equals(name)) {
            context.getResult().set(gcMBean.getCollectionCount());
        } else if ("collection-time".equals(name)) {
            context.getResult().set(gcMBean.getCollectionTime());
        } else {
            if (GarbageCollectorResourceDefinition.GARBAGE_COLLECTOR_READ_ATTRIBUTES.contains(name) || GarbageCollectorResourceDefinition.GARBAGE_COLLECTOR_METRICS.contains(name)) {
                throw PlatformMBeanLogger.ROOT_LOGGER.badReadAttributeImpl(name);
            }
            throw GarbageCollectorMXBeanAttributeHandler.unknownAttribute(operation);
        }
    }

    static void storeExtendedResult(String gcName, String name, ModelNode store) {
        ExtendedGarbageCollectorMBean mbean = new ExtendedGarbageCollectorMBean(gcName);
        if ("last-gc-info".equals(name)) {
            ExtendedGarbageCollectorMBean.GcInfo info;
            if (mbean.isAttributeDefined("LastGcInfo") && (info = mbean.getLastGcInfo()) != null) {
                store.set(PlatformMBeanUtil.getDetypedGcInfo(info));
            }
        } else if (GarbageCollectorResourceDefinition.GARBAGE_COLLECTOR_EXTENDED_READ_ATTRIBUTES.contains(name)) {
            throw PlatformMBeanLogger.ROOT_LOGGER.badReadAttributeImpl(name);
        }
    }

    @Override
    protected void executeWriteAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        throw GarbageCollectorMXBeanAttributeHandler.unknownAttribute(operation);
    }
}

