/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.work.spi;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.OperationSubmitter;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.mapper.pojo.work.IndexingPlanSynchronizationStrategyConfigurationContext;
import org.hibernate.search.mapper.pojo.work.SearchIndexingPlanExecutionReport;
import org.hibernate.search.mapper.pojo.work.impl.DelegatingSearchIndexingPlanExecutionReport;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingPlan;
import org.hibernate.search.util.common.annotation.Incubating;
import org.hibernate.search.util.common.impl.Contracts;

@Incubating
public class ConfiguredIndexingPlanSynchronizationStrategy {
    private final DocumentCommitStrategy documentCommitStrategy;
    private final DocumentRefreshStrategy documentRefreshStrategy;
    private final Consumer<? super CompletableFuture<? extends SearchIndexingPlanExecutionReport>> indexingFutureHandler;
    private final OperationSubmitter operationSubmitter;

    protected ConfiguredIndexingPlanSynchronizationStrategy(Builder configurationContext) {
        this.documentCommitStrategy = configurationContext.documentCommitStrategy;
        this.documentRefreshStrategy = configurationContext.documentRefreshStrategy;
        this.indexingFutureHandler = configurationContext.indexingFutureHandler;
        this.operationSubmitter = configurationContext.operationSubmitter;
    }

    public DocumentCommitStrategy documentCommitStrategy() {
        return this.documentCommitStrategy;
    }

    public DocumentRefreshStrategy documentRefreshStrategy() {
        return this.documentRefreshStrategy;
    }

    public void executeAndSynchronize(PojoIndexingPlan indexingPlan) {
        CompletionStage reportFuture = indexingPlan.executeAndReport(this.operationSubmitter).thenApply(DelegatingSearchIndexingPlanExecutionReport::new);
        this.indexingFutureHandler.accept((CompletableFuture<? extends SearchIndexingPlanExecutionReport>)reportFuture);
    }

    public static final class Builder
    implements IndexingPlanSynchronizationStrategyConfigurationContext {
        private final FailureHandler failureHandler;
        private DocumentCommitStrategy documentCommitStrategy = DocumentCommitStrategy.NONE;
        private DocumentRefreshStrategy documentRefreshStrategy = DocumentRefreshStrategy.NONE;
        private Consumer<? super CompletableFuture<? extends SearchIndexingPlanExecutionReport>> indexingFutureHandler = future -> {};
        private OperationSubmitter operationSubmitter = OperationSubmitter.blocking();

        public Builder(FailureHandler failureHandler) {
            this.failureHandler = failureHandler;
        }

        @Override
        public void documentCommitStrategy(DocumentCommitStrategy strategy) {
            Contracts.assertNotNull((Object)strategy, (String)"strategy");
            this.documentCommitStrategy = strategy;
        }

        @Override
        public void documentRefreshStrategy(DocumentRefreshStrategy strategy) {
            Contracts.assertNotNull((Object)strategy, (String)"strategy");
            this.documentRefreshStrategy = strategy;
        }

        @Override
        public void indexingFutureHandler(Consumer<? super CompletableFuture<? extends SearchIndexingPlanExecutionReport>> handler) {
            Contracts.assertNotNull(handler, (String)"handler");
            this.indexingFutureHandler = handler;
        }

        @Override
        public FailureHandler failureHandler() {
            return this.failureHandler;
        }

        @Override
        public void operationSubmitter(OperationSubmitter operationSubmitter) {
            this.operationSubmitter = operationSubmitter;
        }

        public ConfiguredIndexingPlanSynchronizationStrategy build() {
            return new ConfiguredIndexingPlanSynchronizationStrategy(this);
        }
    }
}

