/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.embedded.user;

import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.infinispan.Cache;
import org.wildfly.clustering.cache.CacheEntryMutator;
import org.wildfly.clustering.cache.CacheEntryMutatorFactory;
import org.wildfly.clustering.cache.infinispan.embedded.EmbeddedCacheConfiguration;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.session.cache.user.MutableUserSessions;
import org.wildfly.clustering.session.cache.user.UserSessionsFactory;
import org.wildfly.clustering.session.infinispan.embedded.user.UserSessionsKey;
import org.wildfly.clustering.session.user.UserSessions;

public class InfinispanUserSessionsFactory<D, S>
implements UserSessionsFactory<Map<D, S>, D, S> {
    private final Cache<UserSessionsKey, Map<D, S>> cache;
    private final Cache<UserSessionsKey, Map<D, S>> writeOnlyCache;
    private final CacheEntryMutatorFactory<UserSessionsKey, Map<D, S>> mutatorFactory;

    public InfinispanUserSessionsFactory(EmbeddedCacheConfiguration configuration) {
        this.cache = configuration.getCache();
        this.writeOnlyCache = configuration.getWriteOnlyCache();
        this.mutatorFactory = configuration.getCacheEntryMutatorFactory();
    }

    public UserSessions<D, S> createUserSessions(String id, Map<D, S> value) {
        UserSessionsKey key = new UserSessionsKey(id);
        CacheEntryMutator mutator = this.mutatorFactory.createMutator((Object)key, value);
        return new MutableUserSessions(value, (Runnable)mutator);
    }

    public CompletionStage<Map<D, S>> createValueAsync(String id, Void context) {
        ConcurrentHashMap sessions = new ConcurrentHashMap();
        return this.writeOnlyCache.putAsync((Object)new UserSessionsKey(id), sessions).thenApply((Function)org.wildfly.clustering.function.Function.of(sessions));
    }

    public CompletionStage<Map<D, S>> findValueAsync(String id) {
        return this.cache.getAsync((Object)new UserSessionsKey(id));
    }

    public CompletionStage<Void> removeAsync(String id) {
        return this.writeOnlyCache.removeAsync((Object)new UserSessionsKey(id)).thenAccept((java.util.function.Consumer)Consumer.empty());
    }
}

