/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.mail.extension;

import java.util.function.Supplier;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.resource.definition.ResourceDefinitionInjectionSource;
import org.jboss.as.mail.extension.MailLogger;
import org.jboss.as.mail.extension.MailSessionManagedReferenceFactory;
import org.jboss.as.mail.extension.SessionProvider;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.LifecycleEvent;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;

class MailSessionDefinitionInjectionSource
extends ResourceDefinitionInjectionSource
implements Supplier<SessionProvider> {
    private final SessionProvider provider;

    public MailSessionDefinitionInjectionSource(String jndiName, SessionProvider provider) {
        super(jndiName);
        this.provider = provider;
    }

    @Override
    public SessionProvider get() {
        return this.provider;
    }

    public void getResourceValue(InjectionSource.ResolutionContext context, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, Injector<ManagedReferenceFactory> injector) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        try {
            this.startMailSession(this.jndiName, eeModuleDescription, context, phaseContext.getServiceTarget(), serviceBuilder, injector);
        }
        catch (Exception e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
    }

    private void startMailSession(final String jndiName, EEModuleDescription moduleDescription, InjectionSource.ResolutionContext context, ServiceTarget serviceTarget, ServiceBuilder<?> valueSourceServiceBuilder, Injector<ManagedReferenceFactory> injector) {
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoForEnvEntry((String)context.getApplicationName(), (String)context.getModuleName(), (String)context.getComponentName(), (!context.isCompUsesModule() ? 1 : 0) != 0, (String)jndiName);
        BinderService binderService = new BinderService(bindInfo.getBindName(), (Object)this);
        ServiceBuilder binderBuilder = serviceTarget.addService(bindInfo.getBinderServiceName(), (Service)binderService);
        binderService.getManagedObjectInjector().inject((Object)new MailSessionManagedReferenceFactory(this));
        binderBuilder.addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)binderService.getNamingStoreInjector()).addListener(new LifecycleListener(){
            private volatile boolean bound;

            public void handleEvent(ServiceController<?> controller, LifecycleEvent event) {
                switch (event) {
                    case UP: {
                        MailLogger.ROOT_LOGGER.boundMailSession(jndiName);
                        this.bound = true;
                        break;
                    }
                    case DOWN: {
                        if (!this.bound) break;
                        MailLogger.ROOT_LOGGER.unboundMailSession(jndiName);
                        break;
                    }
                    case REMOVED: {
                        MailLogger.ROOT_LOGGER.debugf("Removed Mail Session [%s]", jndiName);
                    }
                }
            }
        });
        binderBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        valueSourceServiceBuilder.addDependency(bindInfo.getBinderServiceName(), ManagedReferenceFactory.class, injector);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MailSessionDefinitionInjectionSource that = (MailSessionDefinitionInjectionSource)o;
        return !(this.provider != null ? !this.provider.equals(that.provider) : that.provider != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.provider != null ? this.provider.hashCode() : 0);
        return result;
    }
}

