/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.codec.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonElementTypes;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.AbstractElasticsearchFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;

public final class ElasticsearchBooleanFieldCodec
extends AbstractElasticsearchFieldCodec<Boolean> {
    public ElasticsearchBooleanFieldCodec(Gson gson) {
        super(gson);
    }

    @Override
    public JsonElement encode(Boolean value) {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonPrimitive(value);
    }

    @Override
    public Boolean decode(JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return null;
        }
        return JsonElementTypes.BOOLEAN.fromElement(element);
    }

    @Override
    public Boolean decodeAggregationKey(JsonElement key, JsonElement keyAsString) {
        if (key == null || key.isJsonNull()) {
            return null;
        }
        int intValue = JsonElementTypes.INTEGER.fromElement(key);
        return intValue != 0;
    }

    @Override
    public boolean isCompatibleWith(ElasticsearchFieldCodec<?> other) {
        return other instanceof ElasticsearchBooleanFieldCodec;
    }

    @Override
    public String fromJsonElementToString(JsonElement value) {
        if (value == null || value.isJsonNull()) {
            return null;
        }
        return Boolean.toString(value.getAsBoolean());
    }
}

